/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.intermodal;

import org.goplanit.converter.IdMapperType;
import org.goplanit.converter.intermodal.IntermodalWriter;
import org.goplanit.io.converter.intermodal.PlanitIntermodalWriterSettings;
import org.goplanit.io.converter.network.PlanitNetworkWriter;
import org.goplanit.io.converter.network.PlanitNetworkWriterFactory;
import org.goplanit.io.converter.network.PlanitNetworkWriterSettings;
import org.goplanit.io.converter.zoning.PlanitZoningWriter;
import org.goplanit.io.converter.zoning.PlanitZoningWriterFactory;
import org.goplanit.io.converter.zoning.PlanitZoningWriterSettings;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.xml.generated.XMLElementMacroscopicNetwork;
import org.goplanit.xml.generated.XMLElementMacroscopicZoning;
import org.goplanit.zoning.Zoning;

public class PlanitIntermodalWriter
implements IntermodalWriter {
    protected final PlanitIntermodalWriterSettings settings;
    protected final XMLElementMacroscopicNetwork xmlRawNetwork;
    protected final XMLElementMacroscopicZoning xmlRawZoning;
    protected IdMapperType idMapper = IdMapperType.XML;

    protected PlanitIntermodalWriter(String outputDirectory, XMLElementMacroscopicNetwork xmlRawNetwork, XMLElementMacroscopicZoning xmlRawZoning) {
        this(outputDirectory, null, xmlRawNetwork, xmlRawZoning);
    }

    protected PlanitIntermodalWriter(String outputDirectory, String countryName, XMLElementMacroscopicNetwork xmlRawNetwork, XMLElementMacroscopicZoning xmlRawZoning) {
        this.settings = new PlanitIntermodalWriterSettings(outputDirectory, countryName);
        this.xmlRawNetwork = xmlRawNetwork;
        this.xmlRawZoning = xmlRawZoning;
    }

    @Override
    public void write(MacroscopicNetwork macroscopicNetwork, Zoning zoning) throws PlanItException {
        PlanitNetworkWriterSettings networkSettings = this.getSettings().getNetworkSettings();
        PlanitNetworkWriter networkWriter = PlanitNetworkWriterFactory.create(networkSettings.getOutputPathDirectory(), networkSettings.getCountry(), this.xmlRawNetwork);
        networkWriter.setIdMapperType(this.getIdMapperType());
        networkWriter.write(macroscopicNetwork);
        PlanitZoningWriterSettings zoningSettings = this.getSettings().getZoningSettings();
        PlanitZoningWriter zoningWriter = PlanitZoningWriterFactory.create(zoningSettings.getOutputPathDirectory(), zoningSettings.getCountry(), macroscopicNetwork.getCoordinateReferenceSystem());
        zoningWriter.setIdMapperType(this.getIdMapperType());
        zoningWriter.write(zoning);
    }

    @Override
    public IdMapperType getIdMapperType() {
        return this.idMapper;
    }

    @Override
    public void setIdMapperType(IdMapperType idMapper) {
        this.idMapper = idMapper;
    }

    @Override
    public void reset() {
        this.getSettings().reset();
    }

    @Override
    public PlanitIntermodalWriterSettings getSettings() {
        return this.settings;
    }
}

