/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.network;

import java.math.BigInteger;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.converter.IdMapperType;
import org.goplanit.converter.network.NetworkWriter;
import org.goplanit.io.converter.PlanitWriterImpl;
import org.goplanit.io.converter.network.PlanitNetworkWriterSettings;
import org.goplanit.io.xml.util.EnumConversionUtil;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.TransportLayerNetwork;
import org.goplanit.network.layer.MacroscopicNetworkLayerImpl;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.Modes;
import org.goplanit.utils.mode.PhysicalModeFeatures;
import org.goplanit.utils.mode.UsabilityModeFeatures;
import org.goplanit.utils.network.layer.TransportLayer;
import org.goplanit.utils.network.layer.macroscopic.AccessGroupProperties;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentTypes;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.network.layer.physical.Links;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.network.layer.physical.Nodes;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.goplanit.xml.generated.Direction;
import org.goplanit.xml.generated.LengthUnit;
import org.goplanit.xml.generated.XMLElementAccessGroup;
import org.goplanit.xml.generated.XMLElementConfiguration;
import org.goplanit.xml.generated.XMLElementInfrastructureLayer;
import org.goplanit.xml.generated.XMLElementInfrastructureLayers;
import org.goplanit.xml.generated.XMLElementLayerConfiguration;
import org.goplanit.xml.generated.XMLElementLinkLengthType;
import org.goplanit.xml.generated.XMLElementLinkSegment;
import org.goplanit.xml.generated.XMLElementLinkSegmentType;
import org.goplanit.xml.generated.XMLElementLinkSegmentTypes;
import org.goplanit.xml.generated.XMLElementLinks;
import org.goplanit.xml.generated.XMLElementMacroscopicNetwork;
import org.goplanit.xml.generated.XMLElementModes;
import org.goplanit.xml.generated.XMLElementNodes;
import org.goplanit.xml.generated.XMLElementPhysicalFeatures;
import org.goplanit.xml.generated.XMLElementUsabilityFeatures;

public class PlanitNetworkWriter
extends PlanitWriterImpl<TransportLayerNetwork<?, ?>>
implements NetworkWriter {
    private static final Logger LOGGER = Logger.getLogger(PlanitNetworkWriter.class.getCanonicalName());
    private final XMLElementMacroscopicNetwork xmlRawNetwork;
    private final PlanitNetworkWriterSettings settings;
    public static final String DEFAULT_NETWORK_FILE_NAME = "network.xml";

    private String getXmlModeReference(Mode mode) {
        if (mode.isPredefinedModeType()) {
            return mode.getXmlId();
        }
        return this.getModeIdMapper().apply(mode);
    }

    private void populateLinkSegment(XMLElementLinkSegment xmlLinkSegment, MacroscopicLinkSegment linkSegment) {
        xmlLinkSegment.setId(this.getLinkSegmentIdMapper().apply(linkSegment));
        xmlLinkSegment.setMaxspeed(linkSegment.getPhysicalSpeedLimitKmH());
        xmlLinkSegment.setNumberoflanes(BigInteger.valueOf(linkSegment.getNumberOfLanes()));
        if (!linkSegment.hasLinkSegmentType()) {
            LOGGER.severe(String.format("missing link segment type on link segment %s (id:%d)", linkSegment.getExternalId(), linkSegment.getId()));
        } else {
            xmlLinkSegment.setTyperef(this.getLinkSegmentTypeIdMapper().apply(linkSegment.getLinkSegmentType()));
        }
    }

    private void populateLinkSegments(XMLElementLinks.Link xmlLink, Link link) {
        XMLElementLinkSegment xmlLinkSegment;
        List<XMLElementLinkSegment> xmlLinkSegments = xmlLink.getLinksegment();
        if (link.hasLinkSegmentAb()) {
            xmlLinkSegment = new XMLElementLinkSegment();
            xmlLinkSegment.setDir(Direction.A_B);
            this.populateLinkSegment(xmlLinkSegment, (MacroscopicLinkSegment)link.getLinkSegmentAb());
            xmlLinkSegments.add(xmlLinkSegment);
        }
        if (link.hasLinkSegmentBa()) {
            xmlLinkSegment = new XMLElementLinkSegment();
            xmlLinkSegment.setDir(Direction.B_A);
            this.populateLinkSegment(xmlLinkSegment, (MacroscopicLinkSegment)link.getLinkSegmentBa());
            xmlLinkSegments.add(xmlLinkSegment);
        }
        if (xmlLinkSegments == null && (link.hasLinkSegmentAb() || link.hasLinkSegmentBa())) {
            LOGGER.severe(String.format("link %s (id:%d) has no xm Link segment element, but does have link segments", link.getExternalId(), link.getId()));
        }
    }

    private void populateXmlLink(List<XMLElementLinks.Link> xmlLinkList, Link link) throws PlanItException {
        double geographicLength;
        XMLElementLinks.Link xmlLink = new XMLElementLinks.Link();
        xmlLink.setId(this.getLinkIdMapper().apply(link));
        if (link.hasExternalId()) {
            xmlLink.setExternalid(link.getExternalId());
        }
        boolean useOverrideLength = true;
        if (this.getGeoUtils() != null && link.hasGeometry() && Precision.isEqual(geographicLength = this.getGeoUtils().getDistanceInKilometres(link.getGeometry()), link.getLengthKm(), 1.0E-6)) {
            useOverrideLength = false;
        }
        if (useOverrideLength) {
            XMLElementLinkLengthType xmlLinkLength = new XMLElementLinkLengthType();
            xmlLinkLength.setUnit(LengthUnit.KM);
            xmlLinkLength.setValue(link.getLengthKm());
            xmlLink.setLength(xmlLinkLength);
        }
        if (link.hasName()) {
            xmlLink.setName(link.getName());
        }
        xmlLink.setNodearef(this.getVertexIdMapper().apply((Vertex)link.getNodeA()));
        xmlLink.setNodebref(this.getVertexIdMapper().apply((Vertex)link.getNodeB()));
        xmlLink.setLineString(this.createGmlLineStringType(link.getGeometry()));
        this.populateLinkSegments(xmlLink, link);
        xmlLinkList.add(xmlLink);
    }

    private void populateXmlLinks(XMLElementInfrastructureLayer xmlNetworkLayer, Links links) throws PlanItException {
        XMLElementLinks xmlLinks = xmlNetworkLayer.getLinks();
        if (xmlLinks == null) {
            xmlLinks = new XMLElementLinks();
            xmlNetworkLayer.setLinks(xmlLinks);
        }
        List<XMLElementLinks.Link> xmlLinkList = xmlLinks.getLink();
        for (Link link : links) {
            this.populateXmlLink(xmlLinkList, link);
        }
    }

    private void populateXmlNode(List<XMLElementNodes.Node> xmlNodeList, Node node) {
        XMLElementNodes.Node xmlNode = new XMLElementNodes.Node();
        xmlNodeList.add(xmlNode);
        xmlNode.setId(this.getVertexIdMapper().apply(node));
        if (node.hasExternalId()) {
            xmlNode.setExternalid(node.getExternalId());
        }
        xmlNode.setName(node.getName());
        xmlNode.setPoint(this.createGmlPointType(node.getPosition()));
    }

    private void populateXmlNodes(XMLElementInfrastructureLayer xmlNetworkLayer, Nodes nodes) {
        XMLElementNodes xmlNodes = xmlNetworkLayer.getNodes();
        if (xmlNodes == null) {
            xmlNodes = new XMLElementNodes();
            xmlNetworkLayer.setNodes(xmlNodes);
        }
        List<XMLElementNodes.Node> xmlNodeList = xmlNodes.getNode();
        nodes.forEach(node -> this.populateXmlNode(xmlNodeList, (Node)node));
    }

    private void populateLinkSegmentTypeAccessGroupProperties(XMLElementLinkSegmentType.Access xmlAccess, AccessGroupProperties accessGroupProperties) {
        List<XMLElementAccessGroup> accessGroupList = xmlAccess.getAccessgroup();
        XMLElementAccessGroup xmlAccessGroup = new XMLElementAccessGroup();
        Set<Mode> accessModes = accessGroupProperties.getAccessModes();
        String modeRefs = accessModes.stream().map(mode -> this.getXmlModeReference((Mode)mode)).collect(Collectors.joining(","));
        xmlAccessGroup.setModerefs(modeRefs);
        if (accessGroupProperties.isCriticalSpeedKmHSet()) {
            xmlAccessGroup.setCritspeed(accessGroupProperties.getCriticalSpeedKmH());
        }
        if (accessGroupProperties.isMaximumSpeedKmHSet()) {
            xmlAccessGroup.setMaxspeed(accessGroupProperties.getMaximumSpeedKmH());
        }
        accessGroupList.add(xmlAccessGroup);
    }

    private void populateXmlLinkSegmentType(List<XMLElementLinkSegmentType> xmlLinkSegmentTypeList, MacroscopicLinkSegmentType linkSegmentType) {
        XMLElementLinkSegmentType xmlLinkSegmentType = new XMLElementLinkSegmentType();
        xmlLinkSegmentType.setId(this.getLinkSegmentTypeIdMapper().apply(linkSegmentType));
        if (linkSegmentType.hasExternalId()) {
            xmlLinkSegmentType.setExternalid(linkSegmentType.getExternalId());
        }
        if (linkSegmentType.isExplicitCapacityPerLaneSet()) {
            xmlLinkSegmentType.setCapacitylane(linkSegmentType.getExplicitCapacityPerLane());
        }
        if (linkSegmentType.isExplicitMaximumDensityPerLaneSet()) {
            xmlLinkSegmentType.setMaxdensitylane(linkSegmentType.getExplicitMaximumDensityPerLane());
        }
        xmlLinkSegmentType.setName(linkSegmentType.getName());
        XMLElementLinkSegmentType.Access xmlTypeAccess = xmlLinkSegmentType.getAccess();
        if (xmlTypeAccess == null) {
            xmlTypeAccess = new XMLElementLinkSegmentType.Access();
            xmlLinkSegmentType.setAccess(xmlTypeAccess);
        }
        TreeSet<Mode> processedModes = new TreeSet<Mode>();
        for (Mode accessMode : linkSegmentType.getAllowedModes()) {
            if (processedModes.contains(accessMode)) continue;
            AccessGroupProperties accessProperties = linkSegmentType.getAccessProperties(accessMode);
            processedModes.addAll(accessProperties.getAccessModes());
            this.populateLinkSegmentTypeAccessGroupProperties(xmlTypeAccess, accessProperties);
        }
        xmlLinkSegmentTypeList.add(xmlLinkSegmentType);
    }

    private void populateXmlLinkSegmentTypes(XMLElementLayerConfiguration xmlLayerConfiguration, MacroscopicLinkSegmentTypes linkSegmentTypes) {
        XMLElementLinkSegmentTypes xmlLinkSegmentTypes = xmlLayerConfiguration.getLinksegmenttypes();
        if (xmlLinkSegmentTypes == null) {
            xmlLinkSegmentTypes = new XMLElementLinkSegmentTypes();
            xmlLayerConfiguration.setLinksegmenttypes(xmlLinkSegmentTypes);
        }
        List<XMLElementLinkSegmentType> xmlLinkSegmentTypeList = xmlLinkSegmentTypes.getLinksegmenttype();
        linkSegmentTypes.forEach(linkSegmentType -> this.populateXmlLinkSegmentType(xmlLinkSegmentTypeList, (MacroscopicLinkSegmentType)linkSegmentType));
    }

    private void populateModePhysicalFeatures(XMLElementModes.Mode xmlMode, PhysicalModeFeatures physicalModeFeatures) {
        XMLElementPhysicalFeatures xmlPhysicalFeatures = xmlMode.getPhysicalfeatures();
        if (xmlPhysicalFeatures == null) {
            xmlPhysicalFeatures = new XMLElementPhysicalFeatures();
            xmlMode.setPhysicalfeatures(xmlPhysicalFeatures);
        }
        try {
            xmlPhysicalFeatures.setMotorisationtype(EnumConversionUtil.planitToXml(physicalModeFeatures.getMotorisationType()));
            xmlPhysicalFeatures.setTracktype(EnumConversionUtil.planitToXml(physicalModeFeatures.getTrackType()));
            xmlPhysicalFeatures.setVehicletype(EnumConversionUtil.planitToXml(physicalModeFeatures.getVehicularType()));
        }
        catch (PlanItException e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe("unable to set physical features on mode properties");
        }
    }

    private void populateModeUsabilityFeatures(XMLElementModes.Mode xmlMode, UsabilityModeFeatures usabilityModeFeatures) {
        XMLElementUsabilityFeatures xmlUseFeatures = xmlMode.getUsabilityfeatures();
        if (xmlUseFeatures == null) {
            xmlUseFeatures = new XMLElementUsabilityFeatures();
            xmlMode.setUsabilityfeatures(xmlUseFeatures);
        }
        try {
            xmlUseFeatures.setUsedtotype(EnumConversionUtil.planitToXml(usabilityModeFeatures.getUseOfType()));
        }
        catch (PlanItException e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe("unable to set physical features on mode properties");
        }
    }

    private void populateXmlMode(List<XMLElementModes.Mode> xmlModesList, Mode mode) {
        XMLElementModes.Mode xmlMode = new XMLElementModes.Mode();
        xmlMode.setId(this.getXmlModeReference(mode));
        if (mode.hasExternalId()) {
            xmlMode.setExternalid(mode.getExternalId());
        }
        xmlMode.setMaxspeed(mode.getMaximumSpeedKmH());
        if (mode.hasName()) {
            xmlMode.setName(mode.getName());
        }
        xmlMode.setPcu(mode.getPcu());
        xmlMode.setPredefined(mode.isPredefinedModeType());
        if (mode.hasPhysicalFeatures()) {
            this.populateModePhysicalFeatures(xmlMode, mode.getPhysicalFeatures());
        }
        if (mode.hasUseFeatures()) {
            this.populateModeUsabilityFeatures(xmlMode, mode.getUseFeatures());
        }
        xmlModesList.add(xmlMode);
    }

    private void populateXmlModes(Modes modes) {
        XMLElementModes xmlModes = this.xmlRawNetwork.getConfiguration().getModes();
        if (xmlModes == null) {
            xmlModes = new XMLElementModes();
            this.xmlRawNetwork.getConfiguration().setModes(xmlModes);
        }
        List<XMLElementModes.Mode> xmlModesList = xmlModes.getMode();
        modes.forEach(mode -> this.populateXmlMode(xmlModesList, (Mode)mode));
    }

    private void populateXmlId(MacroscopicNetwork network) {
        if (!network.hasXmlId()) {
            LOGGER.warning(String.format("Network has no XML id defined, adopting internally generated id %d instead", network.getId()));
            network.setXmlId(String.valueOf(network.getId()));
        }
        this.xmlRawNetwork.setId(network.getXmlId());
    }

    protected void populateXmlConfiguration(Modes modes) {
        XMLElementConfiguration xmlConfiguration = this.xmlRawNetwork.getConfiguration();
        if (xmlConfiguration == null) {
            xmlConfiguration = new XMLElementConfiguration();
            this.xmlRawNetwork.setConfiguration(xmlConfiguration);
        }
        this.populateXmlModes(modes);
    }

    protected void populateXmlLayerConfiguration(XMLElementInfrastructureLayer xmlNetworkLayer, MacroscopicLinkSegmentTypes linkSegmentTypes) {
        XMLElementLayerConfiguration xmlLayerConfiguration = xmlNetworkLayer.getLayerconfiguration();
        if (xmlLayerConfiguration == null) {
            xmlLayerConfiguration = new XMLElementLayerConfiguration();
            xmlNetworkLayer.setLayerconfiguration(xmlLayerConfiguration);
        }
        this.populateXmlLinkSegmentTypes(xmlLayerConfiguration, linkSegmentTypes);
    }

    protected void populateXmlNetworkLayer(XMLElementInfrastructureLayers xmlInfrastructureLayers, MacroscopicNetworkLayerImpl physicalNetworkLayer) throws PlanItException {
        XMLElementInfrastructureLayer xmlNetworkLayer = new XMLElementInfrastructureLayer();
        xmlInfrastructureLayers.getLayer().add(xmlNetworkLayer);
        this.populateXmlLayerConfiguration(xmlNetworkLayer, physicalNetworkLayer.linkSegmentTypes);
        this.populateXmlLinks(xmlNetworkLayer, physicalNetworkLayer.getLinks());
        this.populateXmlNodes(xmlNetworkLayer, physicalNetworkLayer.getNodes());
    }

    protected void populateXmlNetworkLayers(MacroscopicNetwork network) throws PlanItException {
        XMLElementInfrastructureLayers xmlInfrastructureLayers = this.xmlRawNetwork.getInfrastructurelayers();
        if (xmlInfrastructureLayers == null) {
            this.xmlRawNetwork.setInfrastructurelayers(new XMLElementInfrastructureLayers());
            xmlInfrastructureLayers = this.xmlRawNetwork.getInfrastructurelayers();
        }
        xmlInfrastructureLayers.setSrsname(PlanitNetworkWriter.extractSrsName(this.getSettings()));
        for (TransportLayer networkLayer : (MacroscopicNetworkLayers)network.getTransportLayers()) {
            if (networkLayer instanceof MacroscopicNetworkLayerImpl) {
                MacroscopicNetworkLayerImpl physicalNetworkLayer = (MacroscopicNetworkLayerImpl)networkLayer;
                this.populateXmlNetworkLayer(xmlInfrastructureLayers, physicalNetworkLayer);
                continue;
            }
            LOGGER.severe(String.format("unsupported macroscopic infrastructure layer %s encountered", networkLayer.getXmlId()));
        }
    }

    protected PlanitNetworkWriter(XMLElementMacroscopicNetwork xmlRawNetwork) {
        this(null, "global", xmlRawNetwork);
    }

    protected PlanitNetworkWriter(String networkPath, XMLElementMacroscopicNetwork xmlRawNetwork) {
        this(networkPath, "global", xmlRawNetwork);
    }

    protected PlanitNetworkWriter(String networkPath, String countryName, XMLElementMacroscopicNetwork xmlRawNetwork) {
        super(IdMapperType.XML);
        this.settings = new PlanitNetworkWriterSettings(networkPath, DEFAULT_NETWORK_FILE_NAME, countryName);
        this.xmlRawNetwork = xmlRawNetwork;
    }

    @Override
    public void write(TransportLayerNetwork<?, ?> network) throws PlanItException {
        if (!(network instanceof MacroscopicNetwork)) {
            throw new PlanItException("currently the PLANit network reader only supports macroscopic infrastructure networks, the provided network is not of this type");
        }
        MacroscopicNetwork macroscopicNetwork = (MacroscopicNetwork)network;
        super.initialiseIdMappingFunctions();
        super.prepareCoordinateReferenceSystem(macroscopicNetwork.getCoordinateReferenceSystem());
        LOGGER.info(String.format("Persisting PLANit network to: %s", Paths.get(this.getSettings().getOutputPathDirectory(), this.getSettings().getFileName()).toString()));
        this.getSettings().logSettings();
        this.populateXmlId(macroscopicNetwork);
        this.populateXmlConfiguration(network.getModes());
        this.populateXmlNetworkLayers(macroscopicNetwork);
        super.persist(this.xmlRawNetwork, XMLElementMacroscopicNetwork.class, "macroscopicnetworkinput.xsd");
    }

    @Override
    public void reset() {
        this.xmlRawNetwork.setConfiguration(null);
        this.xmlRawNetwork.setInfrastructurelayers(null);
    }

    @Override
    public PlanitNetworkWriterSettings getSettings() {
        return this.settings;
    }

    public String getCountryName() {
        return this.getSettings().getCountry();
    }
}

