/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.goplanit.converter.network.NetworkReaderImpl;
import org.goplanit.converter.service.ServiceNetworkReader;
import org.goplanit.io.converter.service.PlanitServiceNetworkReaderSettings;
import org.goplanit.io.xml.util.PlanitXmlJaxbParser;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.ExternalIdAble;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.CharacterUtils;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.ServiceNetworkLayer;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.network.layer.physical.Nodes;
import org.goplanit.utils.network.layer.service.ServiceLeg;
import org.goplanit.utils.network.layer.service.ServiceLegSegment;
import org.goplanit.utils.network.layer.service.ServiceNode;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.goplanit.utils.network.layers.ServiceNetworkLayers;
import org.goplanit.utils.wrapper.MapWrapperImpl;
import org.goplanit.xml.generated.Direction;
import org.goplanit.xml.generated.XMLElementServiceLeg;
import org.goplanit.xml.generated.XMLElementServiceLegs;
import org.goplanit.xml.generated.XMLElementServiceNetwork;
import org.goplanit.xml.generated.XMLElementServiceNetworkLayer;
import org.goplanit.xml.generated.XMLElementServiceNodes;

public class PlanitServiceNetworkReader
extends NetworkReaderImpl
implements ServiceNetworkReader {
    private static final Logger LOGGER = Logger.getLogger(PlanitServiceNetworkReader.class.getCanonicalName());
    private final PlanitServiceNetworkReaderSettings settings;
    private final PlanitXmlJaxbParser<XMLElementServiceNetwork> xmlParser;
    private final ServiceNetwork serviceNetwork;
    public static final String SERVICE_NETWORK_XSD_FILE = "https://trafficplanit.github.io/PLANitManual/xsd/servicenetworkinput.xsd";

    private void parseServiceLegs(ServiceNetworkLayer serviceNetworkLayer, XMLElementServiceLegs xmlServicelegs) throws PlanItException {
        PlanItException.throwIfNull(xmlServicelegs, "No service legs element available on service network layer %s", serviceNetworkLayer.getXmlId());
        List<XMLElementServiceLeg> xmlServiceLegList = xmlServicelegs.getLeg();
        PlanItException.throwIf(xmlServiceLegList == null || xmlServiceLegList.isEmpty(), "No service leg available on service network layer %s", serviceNetworkLayer.getXmlId());
        MapWrapperImpl<String, ServiceNode> serviceNodesByXmlId = new MapWrapperImpl<String, ServiceNode>(new HashMap(), ExternalIdAble::getXmlId, serviceNetworkLayer.getServiceNodes());
        boolean registerLegsOnServiceNodes = true;
        for (XMLElementServiceLeg xmlServiceLeg : xmlServiceLegList) {
            String xmlId = xmlServiceLeg.getId();
            if (StringUtils.isNullOrBlank(xmlId)) {
                LOGGER.warning(String.format("IGNORE: Service leg in service layer %s has no XML id defined", serviceNetworkLayer.getXmlId()));
                continue;
            }
            if (StringUtils.isNullOrBlank(xmlServiceLeg.getNodearef())) {
                LOGGER.warning(String.format("IGNORE: No service node a reference present on service leg %s", xmlId));
                continue;
            }
            ServiceNode startNode = (ServiceNode)serviceNodesByXmlId.get(xmlServiceLeg.getNodearef());
            if (StringUtils.isNullOrBlank(xmlServiceLeg.getNodebref())) {
                LOGGER.warning(String.format("IGNORE: No service node b reference present on service leg %s", xmlId));
                continue;
            }
            ServiceNode endNode = (ServiceNode)serviceNodesByXmlId.get(xmlServiceLeg.getNodebref());
            String parentLinkRefs = xmlServiceLeg.getLrefs();
            if (StringUtils.isNullOrBlank(parentLinkRefs)) {
                LOGGER.warning(String.format("IGNORE: Service leg %s in service layer %s has no parent links that define the leg", xmlId, serviceNetworkLayer.getXmlId()));
                continue;
            }
            String[] parentLinkRefsArray = parentLinkRefs.split(CharacterUtils.COMMA.toString());
            boolean valid = true;
            ArrayList<Link> parentLinksInOrder = new ArrayList<Link>(parentLinkRefsArray.length);
            for (int index = 0; index < parentLinkRefsArray.length; ++index) {
                String xmlParentLinkRef = parentLinkRefsArray[index];
                Link linkInLeg = this.getBySourceId(Link.class, xmlParentLinkRef);
                if (linkInLeg == null) {
                    LOGGER.warning(String.format("Service leg %s in service layer %s references unknown parent link %s", xmlId, serviceNetworkLayer.getXmlId(), xmlParentLinkRef));
                    valid = false;
                    continue;
                }
                parentLinksInOrder.add(linkInLeg);
            }
            if (!valid) {
                LOGGER.warning(String.format("IGNORE: Service leg %s in service layer %s invalid", xmlId, serviceNetworkLayer.getXmlId()));
                continue;
            }
            ServiceLeg serviceLeg = serviceNetworkLayer.getLegs().getFactory().registerNew(startNode, endNode, parentLinksInOrder, true);
            if (!serviceLeg.validate()) {
                throw new PlanItException("Invalid service network file, inconsistency detected in service leg (%s) definition", serviceLeg.getXmlId());
            }
            serviceLeg.setXmlId(xmlId);
            if (!StringUtils.isNullOrBlank(xmlServiceLeg.getExternalid())) {
                serviceLeg.setExternalId(xmlServiceLeg.getExternalid());
            }
            this.parseLegSegmentsOfLeg(serviceNetworkLayer, serviceLeg, xmlServiceLeg);
        }
    }

    private void parseLegSegmentsOfLeg(ServiceNetworkLayer serviceNetworkLayer, ServiceLeg serviceLeg, XMLElementServiceLeg xmlServiceLeg) throws PlanItException {
        PlanItException.throwIfNull(xmlServiceLeg, "No service leg element available to extract leg segments from");
        List<XMLElementServiceLeg.Legsegment> xmlLegSegments = xmlServiceLeg.getLegsegment();
        PlanItException.throwIf(xmlLegSegments == null || xmlLegSegments.isEmpty(), "No service leg segments available on service network layer %s", serviceNetworkLayer.getXmlId());
        PlanItException.throwIf(xmlLegSegments.size() > 2, "No more than two service leg segments allowed per service leg (one per direction) on service leg %s on service layer %s", serviceLeg.getXmlId(), serviceNetworkLayer.getXmlId());
        boolean registerLegSegmentsOnLegAndNode = true;
        for (XMLElementServiceLeg.Legsegment xmlLegSegment : xmlLegSegments) {
            String xmlId = xmlLegSegment.getId();
            if (StringUtils.isNullOrBlank(xmlId)) {
                LOGGER.warning(String.format("IGNORE: Service leg segment for leg %s has no XML id defined", serviceLeg.getXmlId()));
                continue;
            }
            Direction xmlDirection = xmlLegSegment.getDir();
            if (xmlDirection == null) {
                LOGGER.warning(String.format("IGNORE: Service leg segment for leg %s has no direction defined", serviceLeg.getXmlId()));
                continue;
            }
            boolean isDirectionAb = xmlDirection.equals((Object)Direction.A_B);
            ServiceLegSegment serviceLegSegment = serviceNetworkLayer.getLegSegments().getFactory().registerNew(serviceLeg, isDirectionAb, registerLegSegmentsOnLegAndNode);
            serviceLegSegment.setXmlId(xmlId);
            if (StringUtils.isNullOrBlank(xmlLegSegment.getExternalid())) continue;
            serviceLegSegment.setExternalId(xmlLegSegment.getExternalid());
        }
    }

    private void parseServiceNodes(ServiceNetworkLayer serviceNetworkLayer, XMLElementServiceNodes xmlServicenodes) throws PlanItException {
        PlanItException.throwIfNull(xmlServicenodes, "No service nodes element available on service network layer %s", serviceNetworkLayer.getXmlId());
        List<XMLElementServiceNodes.Servicenode> xmlServiceNodeList = xmlServicenodes.getServicenode();
        PlanItException.throwIf(xmlServiceNodeList == null || xmlServiceNodeList.isEmpty(), "No service node available on service network layer %s", serviceNetworkLayer.getXmlId());
        MacroscopicNetworkLayer parentLayer = serviceNetworkLayer.getParentNetworkLayer();
        PlanItException.throwIf(parentLayer == null || parentLayer.isEmpty(), "No parent layer or empty parent layer for service network layer %s", serviceNetworkLayer.getXmlId());
        Nodes parentNodes = parentLayer.getNodes();
        PlanItException.throwIf(parentNodes == null || parentNodes.isEmpty(), "No parent nodes or empty parent nodes for service network layer %s", serviceNetworkLayer.getXmlId());
        for (XMLElementServiceNodes.Servicenode xmlServiceNode : xmlServiceNodeList) {
            String xmlId = xmlServiceNode.getId();
            if (StringUtils.isNullOrBlank(xmlId)) {
                LOGGER.warning(String.format("IGNORE: Service node in service layer %s has no XML id defined", serviceNetworkLayer.getXmlId()));
                continue;
            }
            String parentNodeXmlId = xmlServiceNode.getNoderef();
            if (StringUtils.isNullOrBlank(parentNodeXmlId)) {
                LOGGER.warning(String.format("IGNORE: Service node %s in service layer %s has no parent node XML id reference defined", xmlId, serviceNetworkLayer.getXmlId()));
                continue;
            }
            if (this.getBySourceId(Node.class, parentNodeXmlId) == null) {
                LOGGER.warning(String.format("IGNORE: Service node %s in service layer %s references unknown parent node %s", xmlId, serviceNetworkLayer.getXmlId(), parentNodeXmlId));
                continue;
            }
            ServiceNode serviceNode = serviceNetworkLayer.getServiceNodes().getFactory().registerNew(this.getBySourceId(Node.class, parentNodeXmlId));
            serviceNode.setXmlId(xmlId);
            if (StringUtils.isNullOrBlank(xmlServiceNode.getExternalid())) continue;
            serviceNode.setExternalId(xmlServiceNode.getExternalid());
        }
    }

    private ServiceNetworkLayer parseServiceNetworkLayer(XMLElementServiceNetworkLayer xmlLayer) throws PlanItException {
        String parentLayerXmlId = xmlLayer.getParentlayerref();
        if (StringUtils.isNullOrBlank(parentLayerXmlId)) {
            throw new PlanItException("Service network layer %s has no parent layer XML id defined", xmlLayer.getId());
        }
        MacroscopicNetworkLayer parentNetworkLayer = (MacroscopicNetworkLayer)((MacroscopicNetworkLayers)this.serviceNetwork.getParentNetwork().getTransportLayers()).getByXmlId(parentLayerXmlId);
        if (parentNetworkLayer == null || parentNetworkLayer.isEmpty()) {
            throw new PlanItException("Service network layer %s its parent layer %s does not exist in the parent network or is empty", xmlLayer.getId(), parentLayerXmlId);
        }
        ServiceNetworkLayer serviceNetworkLayer = ((ServiceNetworkLayers)this.serviceNetwork.getTransportLayers()).getFactory().registerNew(parentNetworkLayer);
        String xmlId = xmlLayer.getId();
        if (StringUtils.isNullOrBlank(xmlId)) {
            LOGGER.warning(String.format("Service network layer has no XML id defined, adopting internally generated id %d instead", this.serviceNetwork.getId()));
            xmlId = String.valueOf(serviceNetworkLayer.getId());
        }
        serviceNetworkLayer.setXmlId(xmlId);
        if (!StringUtils.isNullOrBlank(xmlLayer.getExternalid())) {
            serviceNetworkLayer.setExternalId(xmlLayer.getExternalid());
        }
        this.parseServiceNodes(serviceNetworkLayer, xmlLayer.getServicenodes());
        this.parseServiceLegs(serviceNetworkLayer, xmlLayer.getServicelegs());
        return serviceNetworkLayer;
    }

    private void parseServiceNetworkLayers() throws PlanItException {
        List<XMLElementServiceNetworkLayer> xmlLayers = this.xmlParser.getXmlRootElement().getServicenetworklayer();
        if (xmlLayers == null || xmlLayers.isEmpty()) {
            LOGGER.warning(String.format("IGNORE: No service layers present in service network file", new Object[0]));
            return;
        }
        for (XMLElementServiceNetworkLayer xmlLayer : xmlLayers) {
            this.parseServiceNetworkLayer(xmlLayer);
        }
    }

    private void initialiseParentXmlIdTrackers(MacroscopicNetwork network) {
        this.initialiseSourceIdMap(Node.class, ExternalIdAble::getXmlId);
        ((MacroscopicNetworkLayers)network.getTransportLayers()).forEach(layer -> this.getSourceIdContainer(Node.class).addAll(layer.getNodes()));
        this.initialiseSourceIdMap(Link.class, ExternalIdAble::getXmlId);
        ((MacroscopicNetworkLayers)network.getTransportLayers()).forEach(layer -> this.getSourceIdContainer(Link.class).addAll(layer.getLinks()));
    }

    protected PlanitServiceNetworkReader(IdGroupingToken idToken, PlanitServiceNetworkReaderSettings settings) throws PlanItException {
        this.xmlParser = new PlanitXmlJaxbParser<Class<XMLElementServiceNetwork>>(XMLElementServiceNetwork.class);
        this.settings = settings;
        this.serviceNetwork = new ServiceNetwork(idToken, settings.getParentNetwork());
    }

    protected PlanitServiceNetworkReader(PlanitServiceNetworkReaderSettings settings, ServiceNetwork serviceNetwork) throws PlanItException {
        this.xmlParser = new PlanitXmlJaxbParser<Class<XMLElementServiceNetwork>>(XMLElementServiceNetwork.class);
        this.settings = settings;
        this.serviceNetwork = serviceNetwork;
        if (!settings.getParentNetwork().equals(serviceNetwork.getParentNetwork())) {
            LOGGER.severe("parent network in service network reader settings does not match the parent network in the provided service network for the PLANit service network reader");
        }
    }

    protected PlanitServiceNetworkReader(XMLElementServiceNetwork populatedXmlRawServiceNetwork, ServiceNetwork serviceNetwork) throws PlanItException {
        this.xmlParser = new PlanitXmlJaxbParser<XMLElementServiceNetwork>(populatedXmlRawServiceNetwork);
        this.settings = new PlanitServiceNetworkReaderSettings(serviceNetwork.getParentNetwork());
        this.serviceNetwork = serviceNetwork;
    }

    protected PlanitServiceNetworkReader(String networkPathDirectory, String xmlFileExtension, ServiceNetwork serviceNetwork) throws PlanItException {
        this.xmlParser = new PlanitXmlJaxbParser<Class<XMLElementServiceNetwork>>(XMLElementServiceNetwork.class);
        this.settings = new PlanitServiceNetworkReaderSettings(serviceNetwork.getParentNetwork(), networkPathDirectory, xmlFileExtension);
        this.serviceNetwork = serviceNetwork;
    }

    @Override
    public ServiceNetwork read() throws PlanItException {
        this.xmlParser.initialiseAndParseXmlRootElement(this.getSettings().getInputDirectory(), this.getSettings().getXmlFileExtension());
        PlanItException.throwIfNull(this.xmlParser.getXmlRootElement(), "No valid PLANit XML service network could be parsed into memory, abort");
        String xmlId = this.xmlParser.getXmlRootElement().getId();
        if (StringUtils.isNullOrBlank(xmlId)) {
            LOGGER.warning(String.format("Service network has no XML id defined, adopting internally generated id %d instead", this.serviceNetwork.getId()));
            xmlId = String.valueOf(this.serviceNetwork.getId());
        }
        this.serviceNetwork.setXmlId(xmlId);
        String parentNetworkXmlId = this.xmlParser.getXmlRootElement().getParentnetwork();
        if (StringUtils.isNullOrBlank(parentNetworkXmlId)) {
            throw new PlanItException("Service network %s has no parent network defined", this.serviceNetwork.getXmlId());
        }
        if (!this.settings.getParentNetwork().getXmlId().equals(parentNetworkXmlId)) {
            throw new PlanItException("Service network %s parent network (%s) in memory does not correspond to the parent network id on file (%s)", this.serviceNetwork.getXmlId(), this.settings.getParentNetwork().getXmlId(), parentNetworkXmlId);
        }
        try {
            this.initialiseParentXmlIdTrackers(this.getSettings().getParentNetwork());
            this.parseServiceNetworkLayers();
            this.xmlParser.clearXmlContent();
        }
        catch (PlanItException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException(String.format("Error while populating service network %s in PLANitIO", this.serviceNetwork.getXmlId()), e);
        }
        return this.serviceNetwork;
    }

    @Override
    public PlanitServiceNetworkReaderSettings getSettings() {
        return this.settings;
    }

    @Override
    public void reset() {
        this.settings.reset();
    }
}

