/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.zoning;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.converter.IdMapperType;
import org.goplanit.converter.zoning.ZoningWriter;
import org.goplanit.io.converter.PlanitWriterImpl;
import org.goplanit.io.converter.zoning.PlanitZoningWriterSettings;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.zoning.Centroid;
import org.goplanit.utils.zoning.Connectoid;
import org.goplanit.utils.zoning.ConnectoidType;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.OdZone;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.goplanit.utils.zoning.TransferZoneType;
import org.goplanit.utils.zoning.UndirectedConnectoid;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.xml.generated.Connectoidnodelocationtype;
import org.goplanit.xml.generated.Connectoidtype;
import org.goplanit.xml.generated.Connectoidtypetype;
import org.goplanit.xml.generated.Intermodaltype;
import org.goplanit.xml.generated.Odconnectoid;
import org.goplanit.xml.generated.Transferzonetype;
import org.goplanit.xml.generated.XMLElementCentroid;
import org.goplanit.xml.generated.XMLElementConnectoid;
import org.goplanit.xml.generated.XMLElementConnectoids;
import org.goplanit.xml.generated.XMLElementMacroscopicZoning;
import org.goplanit.xml.generated.XMLElementTransferGroup;
import org.goplanit.xml.generated.XMLElementTransferZoneAccess;
import org.goplanit.xml.generated.XMLElementTransferZoneGroups;
import org.goplanit.xml.generated.XMLElementTransferZones;
import org.goplanit.xml.generated.XMLElementZones;
import org.goplanit.zoning.Zoning;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PlanitZoningWriter
extends PlanitWriterImpl<Zoning>
implements ZoningWriter {
    private static final Logger LOGGER = Logger.getLogger(PlanitZoningWriter.class.getCanonicalName());
    private final XMLElementMacroscopicZoning xmlRawZoning;
    private final CoordinateReferenceSystem sourceCrs;
    private final Map<Zone, List<Connectoid>> zoneToConnectoidMap = new HashMap<Zone, List<Connectoid>>();
    private final PlanitZoningWriterSettings settings;
    public static final String DEFAULT_ZONING_FILE_NAME = "zoning.xml";

    private static Connectoidtypetype createXmlConnectoidType(ConnectoidType connectoidType) {
        switch (connectoidType) {
            case UNKNOWN: {
                return Connectoidtypetype.UNKNOWN;
            }
            case PT_VEHICLE_STOP: {
                return Connectoidtypetype.PT_VEH_STOP;
            }
            case TRAVELLER_ACCESS: {
                return Connectoidtypetype.TRAVELLER_ACCESS;
            }
            case NONE: {
                return Connectoidtypetype.NONE;
            }
        }
        LOGGER.warning(String.format("Unsupported connectoid type %s found, changed to `unknown`", connectoidType.value()));
        return Connectoidtypetype.UNKNOWN;
    }

    private static Transferzonetype createXmlTransferZoneType(TransferZoneType transferZoneType) {
        switch (transferZoneType) {
            case UNKNOWN: {
                return Transferzonetype.UNKNOWN;
            }
            case PLATFORM: {
                return Transferzonetype.PLATFORM;
            }
            case POLE: {
                return Transferzonetype.STOP_POLE;
            }
            case SMALL_STATION: {
                return Transferzonetype.SMALL_STATION;
            }
            case STATION: {
                return Transferzonetype.STATION;
            }
        }
        LOGGER.warning(String.format("Unsupported transfer zone type %s found, changed to `unknown`", transferZoneType.value()));
        return Transferzonetype.UNKNOWN;
    }

    private void createZoneToConnectoidIndices(Zoning zoning) {
        for (Connectoid connectoid : zoning.odConnectoids) {
            for (Zone zone : connectoid.getAccessZones()) {
                this.zoneToConnectoidMap.putIfAbsent(zone, new ArrayList(1));
                this.zoneToConnectoidMap.get(zone).add(connectoid);
            }
        }
        for (Connectoid connectoid : zoning.transferConnectoids) {
            for (Zone zone : connectoid.getAccessZones()) {
                this.zoneToConnectoidMap.putIfAbsent(zone, new ArrayList(1));
                this.zoneToConnectoidMap.get(zone).add(connectoid);
            }
        }
    }

    private void populateXmlTransferGroup(XMLElementTransferGroup xmlTransferGroup, TransferZoneGroup transferGroup) {
        if (xmlTransferGroup == null) {
            LOGGER.severe(String.format("Unable to add transfer zone group %s (id:%d) to xml element, xml element is null", transferGroup.getXmlId(), transferGroup.getId()));
            return;
        }
        if (!transferGroup.hasTransferZones()) {
            LOGGER.warning(String.format("DISCARD: transfer zone group %s (id:%d) has no transfer zones, it will not be populated", transferGroup.getXmlId(), transferGroup.getId()));
            return;
        }
        xmlTransferGroup.setId(this.getTransferZoneGroupIdMapper().apply(transferGroup));
        if (StringUtils.isNullOrBlank(xmlTransferGroup.getId())) {
            LOGGER.severe(String.format("Transfer zone group id for XML not set successfully for planit transfer zone group %s (id:%d)", transferGroup.getXmlId(), transferGroup.getId()));
        }
        if (transferGroup.hasExternalId()) {
            xmlTransferGroup.setExternalid(transferGroup.getExternalId());
        }
        if (transferGroup.hasName()) {
            xmlTransferGroup.setName(transferGroup.getName());
        }
        xmlTransferGroup.setTzrefs(transferGroup.getTransferZones().stream().map(transferZone -> this.getZoneIdMapper().apply((Zone)transferZone)).collect(Collectors.joining(this.getSettings().getCommaSeparator().toString())));
    }

    private void populateXmlTransferZoneGroups(Zoning zoning, XMLElementMacroscopicZoning.XMLElementIntermodal xmlIntermodal) {
        if (zoning == null || zoning.transferZoneGroups.isEmpty()) {
            return;
        }
        if (((Intermodaltype)xmlIntermodal.getValue()).getTransferzonegroups() == null) {
            ((Intermodaltype)xmlIntermodal.getValue()).setTransferzonegroups(new XMLElementTransferZoneGroups());
        }
        XMLElementTransferZoneGroups xmlTransferZoneGroups = ((Intermodaltype)xmlIntermodal.getValue()).getTransferzonegroups();
        for (TransferZoneGroup transferGroup : zoning.transferZoneGroups) {
            if (!transferGroup.hasTransferZones()) {
                LOGGER.warning(String.format("DISCARD: transfer zone group %s (id:%d) is dangling", transferGroup.getXmlId(), transferGroup.getId()));
                continue;
            }
            XMLElementTransferGroup xmlTransferGroup = new XMLElementTransferGroup();
            this.populateXmlTransferGroup(xmlTransferGroup, transferGroup);
            xmlTransferZoneGroups.getTransfergroup().add(xmlTransferGroup);
        }
    }

    private void populateXmlTransferConnectoid(XMLElementTransferZoneAccess.XMLElementTransferConnectoid xmlTransferConnectoid, DirectedConnectoid transferConnectoid) throws PlanItException {
        if (!transferConnectoid.hasAccessZones()) {
            LOGGER.warning(String.format("DISCARD: transfer connectoid %s (id:%d) is dangling", transferConnectoid.getXmlId(), transferConnectoid.getId()));
            return;
        }
        if (!transferConnectoid.hasAccessLinkSegment()) {
            LOGGER.warning(String.format("DISCARD: transfer connectoid %s (id:%d) has no access link segment", transferConnectoid.getXmlId(), transferConnectoid.getId()));
            return;
        }
        Zone firstAccessZone = transferConnectoid.getFirstAccessZone();
        if (transferConnectoid.getAccessZones().size() > 1) {
            Double lengthKm = null;
            for (Zone zone2 : transferConnectoid.getAccessZones()) {
                Optional<Double> currLengthKm = transferConnectoid.getLengthKm(zone2);
                if (lengthKm == null) {
                    lengthKm = currLengthKm.get();
                    continue;
                }
                if (!currLengthKm.isPresent() || Precision.isEqual(lengthKm, currLengthKm.get(), 1.0E-6)) continue;
                LOGGER.warning(String.format("Transfer connectoid %s (id:%d) has different lengths specified for different access zones it services, this is not yet supported in the Planit XML format, choosing first available length %.2f", transferConnectoid.getXmlId(), transferConnectoid.getId(), transferConnectoid.getLengthKm(transferConnectoid.getFirstAccessZone()).get()));
                break;
            }
        }
        Collection<Mode> explicitAllowedModes = transferConnectoid.getExplicitlyAllowedModes(firstAccessZone);
        if (transferConnectoid.getAccessZones().size() > 1) {
            boolean valid = true;
            Zone prevZone = firstAccessZone;
            for (Zone zone3 : transferConnectoid.getAccessZones()) {
                if (transferConnectoid.isAllModesAllowed(prevZone) == transferConnectoid.isAllModesAllowed(zone3)) {
                    prevZone = zone3;
                }
                if (!valid || transferConnectoid.isAllModesAllowed(zone3) || !(valid = explicitAllowedModes != null) || (valid = (valid = transferConnectoid.getExplicitlyAllowedModes(zone3).containsAll(explicitAllowedModes)) || explicitAllowedModes.containsAll(transferConnectoid.getExplicitlyAllowedModes(zone3)))) continue;
                explicitAllowedModes.addAll(transferConnectoid.getExplicitlyAllowedModes(zone3));
            }
            if (!valid) {
                LOGGER.warning(String.format("Transfer connectoid has different supported modes for different access zones it services, this is not yet supported in the Planit XML format: Allowing all modes across all access zones of connectoid instead", transferConnectoid.getXmlId(), transferConnectoid.getId()));
            }
        }
        this.populateXmlConnectoidBase(xmlTransferConnectoid, transferConnectoid, transferConnectoid.getLengthKm(firstAccessZone), explicitAllowedModes);
        String xmlTzRefs = transferConnectoid.getAccessZones().stream().map(zone -> this.getZoneIdMapper().apply((Zone)zone)).collect(Collectors.joining(","));
        xmlTransferConnectoid.setTzrefs(xmlTzRefs);
        xmlTransferConnectoid.setLsref(this.getLinkSegmentIdMapper().apply((MacroscopicLinkSegment)transferConnectoid.getAccessLinkSegment()));
        if (!transferConnectoid.isNodeAccessDownstream()) {
            xmlTransferConnectoid.setLoc(Connectoidnodelocationtype.UPSTREAM);
        }
        if (transferConnectoid.isNodeAccessDownstream() && !transferConnectoid.getAccessNode().idEquals(transferConnectoid.getAccessLinkSegment().getDownstreamVertex()) || !transferConnectoid.isNodeAccessDownstream() && !transferConnectoid.getAccessNode().idEquals(transferConnectoid.getAccessLinkSegment().getUpstreamVertex())) {
            LOGGER.warning(String.format("Transfer connectoid %s (id:%d) access node location is in conflict with the registered access node", transferConnectoid.getXmlId(), transferConnectoid.getId()));
        }
    }

    private void populateXmlTransferZone(TransferZone transferZone, Zoning zoning, XMLElementTransferZones xmlTransferZones) {
        XMLElementTransferZones.XMLElementTransferZone xmlTransferZone = new XMLElementTransferZones.XMLElementTransferZone();
        xmlTransferZones.getZone().add(xmlTransferZone);
        xmlTransferZone.setId(this.getZoneIdMapper().apply(transferZone));
        if (transferZone.hasExternalId()) {
            xmlTransferZone.setExternalid(transferZone.getExternalId());
        }
        if (transferZone.hasName()) {
            xmlTransferZone.setName(transferZone.getName());
        }
        if (!transferZone.getTransferZoneType().equals((Object)TransferZoneType.NONE)) {
            xmlTransferZone.setType(PlanitZoningWriter.createXmlTransferZoneType(transferZone.getTransferZoneType()));
        }
        if (transferZone.hasGeometry()) {
            if (transferZone.getGeometry() instanceof Polygon) {
                xmlTransferZone.setPolygon(this.createGmlPolygonType((Polygon)transferZone.getGeometry()));
            } else if (transferZone.getGeometry() instanceof LineString) {
                xmlTransferZone.setLineString(this.createGmlLineStringType((LineString)transferZone.getGeometry()));
            }
        }
        if (transferZone.hasCentroid()) {
            XMLElementCentroid xmlCentroid = new XMLElementCentroid();
            this.populateXmlCentroid(xmlCentroid, transferZone.getCentroid());
        }
    }

    private void populateXmlTransferZoneAccess(Zoning zoning, XMLElementMacroscopicZoning.XMLElementIntermodal xmlIntermodal) throws PlanItException {
        if (zoning == null || zoning.transferConnectoids.isEmpty()) {
            LOGGER.severe("transfer zone access should not be persisted when no transfer connectoids exist on the zoning");
            return;
        }
        if (((Intermodaltype)xmlIntermodal.getValue()).getTransferzoneaccess() == null) {
            ((Intermodaltype)xmlIntermodal.getValue()).setTransferzoneaccess(new XMLElementTransferZoneAccess());
        }
        XMLElementTransferZoneAccess xmlTransferZoneAccess = ((Intermodaltype)xmlIntermodal.getValue()).getTransferzoneaccess();
        for (DirectedConnectoid transferConnectoid : zoning.transferConnectoids) {
            if (!transferConnectoid.hasAccessZones()) {
                LOGGER.warning(String.format("DISCARD: transfer connectoid %s (id:%d) is dangling", transferConnectoid.getXmlId(), transferConnectoid.getId()));
                continue;
            }
            if (!transferConnectoid.hasAccessLinkSegment()) {
                LOGGER.warning(String.format("DISCARD: transfer connectoid %s (id:%d) has no access link segment", transferConnectoid.getXmlId(), transferConnectoid.getId()));
                continue;
            }
            XMLElementTransferZoneAccess.XMLElementTransferConnectoid xmlTransferConnectoidBase = new XMLElementTransferZoneAccess.XMLElementTransferConnectoid();
            this.populateXmlTransferConnectoid(xmlTransferConnectoidBase, transferConnectoid);
            xmlTransferZoneAccess.getConnectoid().add(xmlTransferConnectoidBase);
        }
    }

    private void populateXmlTransferZones(Zoning zoning, XMLElementMacroscopicZoning.XMLElementIntermodal xmlIntermodal) {
        if (zoning == null || zoning.transferConnectoids.isEmpty()) {
            LOGGER.severe("transfer zones should not be persisted when no transfer zones exist on the zoning");
            return;
        }
        if (((Intermodaltype)xmlIntermodal.getValue()).getTransferzones() == null) {
            ((Intermodaltype)xmlIntermodal.getValue()).setTransferzones(new XMLElementTransferZones());
        }
        XMLElementTransferZones xmlTransferZones = ((Intermodaltype)xmlIntermodal.getValue()).getTransferzones();
        for (TransferZone transferZone : zoning.transferZones) {
            this.populateXmlTransferZone(transferZone, zoning, xmlTransferZones);
        }
    }

    private void populateXmlCentroid(XMLElementCentroid xmlCentroid, Centroid centroid) {
        if (centroid.hasName()) {
            xmlCentroid.setName(centroid.getName());
        }
        if (centroid.hasPosition()) {
            xmlCentroid.setPoint(this.createGmlPointType(centroid.getPosition()));
        }
    }

    private void populateXmlConnectoidBase(Connectoidtype xmlConnectoidBase, Connectoid connectoid, Optional<Double> lengthKm, Collection<Mode> accessModes) throws PlanItException {
        xmlConnectoidBase.setId(this.getConnectoidIdMapper().apply(connectoid));
        if (StringUtils.isNullOrBlank(xmlConnectoidBase.getId())) {
            LOGGER.severe(String.format("Connectoid id for xml remains null for connectoid (id:%d), this is not allowed", connectoid.getId()));
        }
        if (connectoid.hasExternalId()) {
            xmlConnectoidBase.setExternalid(connectoid.getExternalId());
        }
        if (connectoid.hasName()) {
            xmlConnectoidBase.setName(connectoid.getName());
        }
        if (!connectoid.getType().equals((Object)ConnectoidType.NONE)) {
            xmlConnectoidBase.setType(PlanitZoningWriter.createXmlConnectoidType(connectoid.getType()));
        }
        if (lengthKm.isPresent()) {
            xmlConnectoidBase.setLength(lengthKm.get());
        }
        if (accessModes != null) {
            String csvModeIdString = accessModes.stream().map(mode -> this.getModeIdMapper().apply((Mode)mode)).collect(Collectors.joining(String.valueOf(this.getSettings().getCommaSeparator())));
            xmlConnectoidBase.setModes(csvModeIdString);
        }
    }

    private void populateXmlOdConnectoid(XMLElementConnectoid xmlConnectoid, UndirectedConnectoid odConnectoid, Zone accessZone) throws PlanItException {
        if (!odConnectoid.hasAccessZone(accessZone)) {
            LOGGER.severe(String.format("od conectoid %s (id:%d) is expected to support od zone %s (id:%d), but zone is not registered as access zone", odConnectoid.getXmlId(), odConnectoid.getId(), accessZone.getXmlId(), accessZone.getId()));
        }
        Odconnectoid xmlOdConnectoid = new Odconnectoid();
        xmlConnectoid.setValue(xmlOdConnectoid);
        xmlOdConnectoid.setNoderef(this.getVertexIdMapper().apply(odConnectoid.getAccessVertex()));
        this.populateXmlConnectoidBase(xmlOdConnectoid, odConnectoid, odConnectoid.getLengthKm(accessZone), odConnectoid.getExplicitlyAllowedModes(accessZone));
    }

    private void populateXmlOdZone(Zoning zoning, OdZone odZone) throws PlanItException {
        if (!this.zoneToConnectoidMap.containsKey(odZone)) {
            LOGGER.warning(String.format("DISCARD: od zone %s (id: %d) without connectoids found; dangling", odZone.getXmlId(), odZone.getId()));
            return;
        }
        XMLElementZones.Zone xmlOdZone = new XMLElementZones.Zone();
        this.xmlRawZoning.getZones().getZone().add(xmlOdZone);
        xmlOdZone.setId(this.getZoneIdMapper().apply(odZone));
        if (odZone.hasExternalId()) {
            xmlOdZone.setExternalid(odZone.getExternalId());
        }
        if (odZone.hasName()) {
            xmlOdZone.setName(odZone.getName());
        }
        if (odZone.hasCentroid()) {
            XMLElementCentroid xmlCentroid = new XMLElementCentroid();
            xmlOdZone.setCentroid(xmlCentroid);
            this.populateXmlCentroid(xmlCentroid, odZone.getCentroid());
        }
        if (odZone.hasGeometry() && odZone.getGeometry() instanceof Polygon) {
            xmlOdZone.setPolygon(this.createGmlPolygonType((Polygon)odZone.getGeometry()));
        }
        XMLElementConnectoids xmlConnectoids = new XMLElementConnectoids();
        xmlOdZone.setConnectoids(xmlConnectoids);
        for (Connectoid connectoid : this.zoneToConnectoidMap.get(odZone)) {
            if (!(connectoid instanceof UndirectedConnectoid)) continue;
            UndirectedConnectoid odConnectoid = (UndirectedConnectoid)connectoid;
            if (!odConnectoid.hasAccessZone(odZone)) {
                LOGGER.severe(String.format("od conectoid %s (id:%d) is expected to support od zone %s (id:%d), but zone is not registered as access zone", odConnectoid.getXmlId(), odConnectoid.getId(), odZone.getXmlId(), odZone.getId()));
            }
            XMLElementConnectoid xmlOdConnectoidBase = new XMLElementConnectoid();
            this.populateXmlOdConnectoid(xmlOdConnectoidBase, odConnectoid, odZone);
            xmlConnectoids.getConnectoid().add(xmlOdConnectoidBase);
        }
    }

    private void populateXmlId(Zoning zoning) {
        if (!zoning.hasXmlId()) {
            LOGGER.warning(String.format("Zoning has no XML id defined, adopting internally generated id %d instead", zoning.getId()));
            zoning.setXmlId(String.valueOf(zoning.getId()));
        }
        this.xmlRawZoning.setId(zoning.getXmlId());
    }

    private void populateCrs() throws PlanItException {
        if (this.getSettings().getDestinationCoordinateReferenceSystem() != null) {
            this.xmlRawZoning.setSrsname(PlanitZoningWriter.extractSrsName(this.getSettings()));
        }
    }

    private void populateXmlOdZones(Zoning zoning) throws PlanItException {
        if (!zoning.odZones.isEmpty()) {
            XMLElementZones xmlOdZones = this.xmlRawZoning.getZones();
            if (xmlOdZones == null) {
                xmlOdZones = new XMLElementZones();
                this.xmlRawZoning.setZones(xmlOdZones);
            }
            for (OdZone odZone : zoning.odZones) {
                this.populateXmlOdZone(zoning, odZone);
            }
        }
    }

    private void populateXmlIntermodal(Zoning zoning) throws PlanItException {
        if (zoning.transferZones.isEmpty() && zoning.transferConnectoids.isEmpty()) {
            LOGGER.severe("Transfer zones and/or connectoids should be present when creating intermodal xml elements, but they are empty, abort");
            return;
        }
        XMLElementMacroscopicZoning.XMLElementIntermodal xmlIntermodal = this.xmlRawZoning.getIntermodal();
        if (xmlIntermodal == null) {
            xmlIntermodal = new XMLElementMacroscopicZoning.XMLElementIntermodal(new Intermodaltype());
            this.xmlRawZoning.setIntermodal(xmlIntermodal);
        }
        this.populateXmlTransferZones(zoning, xmlIntermodal);
        this.populateXmlTransferZoneAccess(zoning, xmlIntermodal);
        this.populateXmlTransferZoneGroups(zoning, xmlIntermodal);
    }

    protected PlanitZoningWriter(String zoningPath, String countryName, CoordinateReferenceSystem zoningCrs, XMLElementMacroscopicZoning xmlRawZoning) {
        super(IdMapperType.XML);
        this.settings = new PlanitZoningWriterSettings(zoningPath, DEFAULT_ZONING_FILE_NAME, countryName);
        this.sourceCrs = zoningCrs;
        this.xmlRawZoning = xmlRawZoning;
    }

    @Override
    public void write(Zoning zoning) throws PlanItException {
        PlanItException.throwIfNull(zoning, "Zoning is null cannot write to Planit native format");
        super.initialiseIdMappingFunctions();
        super.prepareCoordinateReferenceSystem(this.sourceCrs);
        LOGGER.info(String.format("Persisting PLANit zoning to: %s", Paths.get(this.getSettings().getOutputPathDirectory(), this.getSettings().getFileName()).toString()));
        this.createZoneToConnectoidIndices(zoning);
        this.populateXmlId(zoning);
        this.populateCrs();
        this.populateXmlOdZones(zoning);
        if (!zoning.transferZones.isEmpty() || !zoning.transferConnectoids.isEmpty()) {
            this.populateXmlIntermodal(zoning);
        }
        super.persist(this.xmlRawZoning, XMLElementMacroscopicZoning.class, "macroscopiczoninginput.xsd");
    }

    @Override
    public void reset() {
        this.xmlRawZoning.setZones(null);
        this.xmlRawZoning.setIntermodal(null);
        this.xmlRawZoning.setSrsname(null);
        this.zoneToConnectoidMap.clear();
    }

    @Override
    public PlanitZoningWriterSettings getSettings() {
        return this.settings;
    }
}

