/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.xml.util;

import java.text.DecimalFormat;
import java.util.logging.Logger;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.misc.CharacterUtils;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PlanitXmlWriterSettings {
    private static final Logger LOGGER = Logger.getLogger(PlanitXmlWriterSettings.class.getCanonicalName());
    private String outputDirectory = null;
    private String countryName = DEFAULT_COUNTRY;
    private String fileName = null;
    public static String DEFAULT_COUNTRY = "global";
    protected DecimalFormat decimalFormat = Precision.DEFAULT_DECIMAL_FORMAT;
    protected Character tupleSeparator = CharacterUtils.SPACE;
    protected Character commaSeparator = CharacterUtils.COMMA;
    protected Character decimalSeparator = CharacterUtils.DECIMAL_POINT;
    protected CoordinateReferenceSystem destinationCoordinateReferenceSystem = null;

    public PlanitXmlWriterSettings() {
    }

    public PlanitXmlWriterSettings(String outputPathDirectory) {
        this.outputDirectory = outputPathDirectory;
    }

    public PlanitXmlWriterSettings(String outputPathDirectory, String countryName) {
        this.outputDirectory = outputPathDirectory;
        this.setCountry(countryName);
    }

    public PlanitXmlWriterSettings(String outputPathDirectory, String fileName, String countryName) {
        this.outputDirectory = outputPathDirectory;
        this.setCountry(countryName);
        this.setFileName(fileName);
    }

    public String getOutputPathDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getCountry() {
        return this.countryName;
    }

    public void setCountry(String countryName) {
        this.countryName = countryName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void logSettings() {
        LOGGER.info(String.format("Decimal fidelity set to %s", this.decimalFormat.getMaximumFractionDigits()));
        if (this.getDestinationCoordinateReferenceSystem() != null) {
            LOGGER.info(String.format("Destination Coordinate Reference System set to: %s", this.getDestinationCoordinateReferenceSystem().getName()));
        }
    }

    public DecimalFormat getDecimalFormat() {
        return this.decimalFormat;
    }

    public void setDecimalFormat(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
    }

    public Character getTupleSeparator() {
        return this.tupleSeparator;
    }

    public void setTupleSeparator(Character tupleSeparator) {
        this.tupleSeparator = tupleSeparator;
    }

    public Character getCommaSeparator() {
        return this.commaSeparator;
    }

    public void setCommaSeparator(Character commaSeparator) {
        this.commaSeparator = commaSeparator;
    }

    public Character getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public void setDecimalSeparator(Character decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
    }

    public CoordinateReferenceSystem getDestinationCoordinateReferenceSystem() {
        return this.destinationCoordinateReferenceSystem;
    }

    public void setDestinationCoordinateReferenceSystem(CoordinateReferenceSystem destinationCoordinateReferenceSystem) {
        this.destinationCoordinateReferenceSystem = destinationCoordinateReferenceSystem;
    }

    public void reset() {
        this.outputDirectory = null;
        this.fileName = null;
        this.destinationCoordinateReferenceSystem = null;
    }
}

