/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.matsim.converter;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.geotools.geometry.jts.JTS;
import org.goplanit.converter.BaseWriterImpl;
import org.goplanit.converter.IdMapperType;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.TransportLayerNetwork;
import org.goplanit.network.layer.MacroscopicNetworkLayerImpl;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.xml.PlanitXmlWriterUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Point;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public abstract class MatsimWriter<T>
extends BaseWriterImpl<T> {
    private static final Logger LOGGER = Logger.getLogger(MatsimWriter.class.getCanonicalName());
    protected int indentLevel = 0;
    protected MathTransform destinationCrsTransformer = null;
    public static final String DEFAULT_FILE_NAME_EXTENSION = ".xml";

    protected boolean validateNetwork(TransportLayerNetwork<?, ?> referenceNetwork) throws PlanItException {
        if (referenceNetwork == null) {
            LOGGER.severe("Matsim macroscopic planit network to extract from is null");
            return false;
        }
        if (!(referenceNetwork instanceof MacroscopicNetwork)) {
            LOGGER.severe("Matsim writer currently only supports writing macroscopic networks");
            return false;
        }
        if (referenceNetwork.getTransportLayers().isEachLayerEmpty()) {
            LOGGER.severe("Planit Network to persist is empty");
            return false;
        }
        if (referenceNetwork.getTransportLayers().size() != 1) {
            LOGGER.severe(String.format("Matsim zoning writer currently only supports networks with a single layer, the provided network has %d", referenceNetwork.getTransportLayers().size()));
            return false;
        }
        if (!(referenceNetwork.getTransportLayers().getFirst() instanceof MacroscopicNetworkLayerImpl)) {
            LOGGER.severe(String.format("Matsim only supports macroscopic physical network layers, the provided network is of a different type", new Object[0]));
            return false;
        }
        return true;
    }

    protected CoordinateReferenceSystem prepareCoordinateReferenceSystem(MacroscopicNetwork network, String destinationCountry, CoordinateReferenceSystem destinationCrs) throws PlanItException {
        CoordinateReferenceSystem identifiedDestinationCrs = this.identifyDestinationCoordinateReferenceSystem(destinationCrs, destinationCountry, network.getCoordinateReferenceSystem());
        PlanItException.throwIfNull(identifiedDestinationCrs, "destination Coordinate Reference System is null, this is not allowed");
        if (!identifiedDestinationCrs.equals(network.getCoordinateReferenceSystem())) {
            this.destinationCrsTransformer = PlanitJtsUtils.findMathTransform(network.getCoordinateReferenceSystem(), identifiedDestinationCrs);
        }
        return identifiedDestinationCrs;
    }

    protected Coordinate extractDestinationCrsCompatibleCoordinate(Point location) throws MismatchedDimensionException, TransformException {
        Coordinate coordinate = null;
        coordinate = this.destinationCrsTransformer != null ? ((Point)JTS.transform(location, this.destinationCrsTransformer)).getCoordinate() : location.getCoordinate();
        return coordinate;
    }

    protected MatsimWriter(IdMapperType idMapperType) {
        super(idMapperType);
    }

    protected void writeIndentation(XMLStreamWriter xmlWriter) throws XMLStreamException {
        PlanitXmlWriterUtils.writeIndentation(xmlWriter, this.indentLevel);
    }

    protected void increaseIndentation() throws XMLStreamException {
        ++this.indentLevel;
    }

    protected void decreaseIndentation() throws XMLStreamException {
        --this.indentLevel;
    }

    protected void writeStartElementNewLine(XMLStreamWriter xmlWriter, String xmlElementName, boolean increaseIndentation) throws XMLStreamException {
        PlanitXmlWriterUtils.writeStartElementNewLine(xmlWriter, xmlElementName, this.indentLevel);
        if (increaseIndentation) {
            this.increaseIndentation();
        }
    }

    protected void writeEndElementNewLine(XMLStreamWriter xmlWriter, boolean decreaseIndentation) throws XMLStreamException {
        if (decreaseIndentation) {
            this.decreaseIndentation();
        }
        PlanitXmlWriterUtils.writeEndElementNewLine(xmlWriter, this.indentLevel);
    }
}

