/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.mode;

import org.goplanit.mode.BicycleMode;
import org.goplanit.mode.BusMode;
import org.goplanit.mode.CarHighOccupancyMode;
import org.goplanit.mode.CarMode;
import org.goplanit.mode.CarShareMode;
import org.goplanit.mode.GoodsMode;
import org.goplanit.mode.HeavyGoodsMode;
import org.goplanit.mode.LargeHeavyGoodsMode;
import org.goplanit.mode.LightRailMode;
import org.goplanit.mode.ModeImpl;
import org.goplanit.mode.MotorBikeMode;
import org.goplanit.mode.PedestrianMode;
import org.goplanit.mode.SubwayMode;
import org.goplanit.mode.TrainMode;
import org.goplanit.mode.TramMode;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.id.ManagedIdEntityFactoryImpl;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.ModeFactory;
import org.goplanit.utils.mode.Modes;
import org.goplanit.utils.mode.PhysicalModeFeatures;
import org.goplanit.utils.mode.PredefinedMode;
import org.goplanit.utils.mode.PredefinedModeType;
import org.goplanit.utils.mode.UsabilityModeFeatures;

public class ModeFactoryImpl
extends ManagedIdEntityFactoryImpl<Mode>
implements ModeFactory {
    protected final Modes modes;

    protected ModeFactoryImpl(IdGroupingToken groupId, Modes modes) {
        super(groupId);
        this.modes = modes;
    }

    @Override
    public PredefinedMode createPredefinedMode(IdGroupingToken groupId, PredefinedModeType modeType) throws PlanItException {
        switch (modeType) {
            case BICYCLE: {
                return new BicycleMode(groupId);
            }
            case BUS: {
                return new BusMode(groupId);
            }
            case CAR: {
                return new CarMode(groupId);
            }
            case CAR_SHARE: {
                return new CarShareMode(groupId);
            }
            case CAR_HIGH_OCCUPANCY: {
                return new CarHighOccupancyMode(groupId);
            }
            case GOODS_VEHICLE: {
                return new GoodsMode(groupId);
            }
            case HEAVY_GOODS_VEHICLE: {
                return new HeavyGoodsMode(groupId);
            }
            case LARGE_HEAVY_GOODS_VEHICLE: {
                return new LargeHeavyGoodsMode(groupId);
            }
            case LIGHTRAIL: {
                return new LightRailMode(groupId);
            }
            case MOTOR_BIKE: {
                return new MotorBikeMode(groupId);
            }
            case PEDESTRIAN: {
                return new PedestrianMode(groupId);
            }
            case SUBWAY: {
                return new SubwayMode(groupId);
            }
            case TRAIN: {
                return new TrainMode(groupId);
            }
            case TRAM: {
                return new TramMode(groupId);
            }
        }
        throw new PlanItException(String.format("mode type %s unknown", new Object[]{modeType}));
    }

    @Override
    public Mode registerNewCustomMode(String name, double maxSpeed, double pcu, PhysicalModeFeatures physicalFeatures, UsabilityModeFeatures usabilityFeatures) {
        ModeImpl newMode = new ModeImpl(this.getIdGroupingToken(), name, maxSpeed, pcu, physicalFeatures, usabilityFeatures);
        this.modes.register(newMode);
        return newMode;
    }

    @Override
    public PredefinedMode registerNew(PredefinedModeType modeType) throws PlanItException {
        PredefinedMode theMode = null;
        if (!this.modes.containsPredefinedMode(modeType)) {
            theMode = this.createPredefinedMode(this.getIdGroupingToken(), modeType);
            this.modes.register(theMode);
        } else {
            theMode = this.modes.get(modeType);
        }
        return theMode;
    }
}

