/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network;

import java.util.logging.Logger;
import org.apache.commons.collections4.map.HashedMap;
import org.goplanit.network.MacroscopicNetworkLayerConfigurator;
import org.goplanit.network.UntypedPhysicalNetwork;
import org.goplanit.network.layers.MacroscopicNetworkLayersImpl;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;

public class MacroscopicNetwork
extends UntypedPhysicalNetwork<MacroscopicNetworkLayer, MacroscopicNetworkLayers> {
    private static final Logger LOGGER = Logger.getLogger(MacroscopicNetwork.class.getCanonicalName());
    private static final long serialVersionUID = -4208133694967189790L;

    @Override
    protected MacroscopicNetworkLayersImpl createLayersContainer(IdGroupingToken networkIdToken) {
        return new MacroscopicNetworkLayersImpl(networkIdToken);
    }

    public MacroscopicNetwork(IdGroupingToken tokenId) {
        super(tokenId);
    }

    public void initialiseLayers(MacroscopicNetworkLayerConfigurator layerConfiguration) {
        if (!((MacroscopicNetworkLayers)this.getTransportLayers()).isNoLayers()) {
            LOGGER.warning("unable to initialise layers based on provided configuration, since network already has layers defined");
            return;
        }
        HashedMap<String, Long> xmlIdToId = new HashedMap<String, Long>();
        for (String layerXmlId2 : layerConfiguration.transportLayersByXmlId) {
            MacroscopicNetworkLayer newLayer = ((MacroscopicNetworkLayers)this.getTransportLayers()).getFactory().registerNew();
            newLayer.setXmlId(layerXmlId2);
            xmlIdToId.put(layerXmlId2, newLayer.getId());
        }
        layerConfiguration.modeToLayerXmlId.forEach((mode, layerXmlId) -> ((MacroscopicNetworkLayer)((MacroscopicNetworkLayers)this.getTransportLayers()).get((Long)xmlIdToId.get(layerXmlId))).registerSupportedMode((Mode)mode));
    }
}

