/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer.macroscopic;

import java.util.Set;
import java.util.logging.Logger;
import org.goplanit.network.layer.physical.LinkSegmentImpl;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;
import org.goplanit.utils.network.layer.physical.Link;

public class MacroscopicLinkSegmentImpl
extends LinkSegmentImpl
implements MacroscopicLinkSegment {
    private static final long serialVersionUID = 4574164258794764853L;
    private static final Logger LOGGER = Logger.getLogger(MacroscopicLinkSegmentImpl.class.getCanonicalName());
    protected MacroscopicLinkSegmentType linkSegmentType = null;

    protected MacroscopicLinkSegmentImpl(IdGroupingToken groupId, Link parentLink, boolean directionAB) throws PlanItException {
        super(groupId, parentLink, directionAB);
    }

    protected MacroscopicLinkSegmentImpl(MacroscopicLinkSegmentImpl macroscopicLinkSegmentImpl) {
        super(macroscopicLinkSegmentImpl);
        this.setLinkSegmentType(macroscopicLinkSegmentImpl.getLinkSegmentType());
    }

    @Override
    public double computeFreeFlowTravelTimeHour(Mode mode) {
        if (!this.isModeAllowed(mode)) {
            return Double.MAX_VALUE;
        }
        return this.getParentLink().getLengthKm() / this.getModelledSpeedLimitKmH(mode);
    }

    @Override
    public boolean isModeAllowed(Mode mode) {
        return this.linkSegmentType.isModeAllowed(mode);
    }

    @Override
    public Set<Mode> getAllowedModes() {
        return this.linkSegmentType.getAllowedModes();
    }

    @Override
    public void setLinkSegmentType(MacroscopicLinkSegmentType linkSegmentType) {
        this.linkSegmentType = linkSegmentType;
    }

    @Override
    public MacroscopicLinkSegmentType getLinkSegmentType() {
        return this.linkSegmentType;
    }

    @Override
    public MacroscopicLinkSegmentImpl clone() {
        return new MacroscopicLinkSegmentImpl(this);
    }
}

