/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.helper;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.util.OsmModeUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.physical.Link;

public class OsmModeHelper {
    private final OsmNetworkReaderSettings settings;

    protected OsmNetworkReaderSettings getSettings() {
        return this.settings;
    }

    public OsmModeHelper(OsmNetworkReaderSettings settings) {
        this.settings = settings;
    }

    public boolean isModeCompatible(Collection<String> osmModesToCheck, Collection<String> referenceOsmModes, boolean allowPseudoMatches) {
        Collection<String> overlappingModes = OsmModeUtils.extractCompatibleOsmModes(osmModesToCheck, referenceOsmModes, allowPseudoMatches);
        return this.settings.hasAnyMappedPlanitMode(overlappingModes);
    }

    public boolean isLinkModeCompatible(Link link, Collection<String> referenceOsmModes, boolean allowPseudoMatches) {
        Set<Mode> planitModes;
        HashSet<String> osmLinkModes = new HashSet<String>();
        if (link.hasEdgeSegmentAb()) {
            planitModes = ((MacroscopicLinkSegment)link.getEdgeSegmentAb()).getLinkSegmentType().getAllowedModes();
            osmLinkModes.addAll(this.settings.getMappedOsmModes(planitModes));
        }
        if (link.hasEdgeSegmentBa()) {
            planitModes = ((MacroscopicLinkSegment)link.getEdgeSegmentBa()).getLinkSegmentType().getAllowedModes();
            osmLinkModes.addAll(this.settings.getMappedOsmModes(planitModes));
        }
        if (osmLinkModes == null || osmLinkModes.isEmpty()) {
            return false;
        }
        return this.isModeCompatible(osmLinkModes, referenceOsmModes, allowPseudoMatches);
    }

    public Collection<Link> filterModeCompatibleLinks(Collection<String> referenceOsmModes, Collection<Link> potentialLinks, boolean allowPseudoModeMatches) {
        HashSet<Link> modeCompatibleLinks = new HashSet<Link>();
        for (Link link : potentialLinks) {
            if (!this.isLinkModeCompatible(link, referenceOsmModes, allowPseudoModeMatches)) continue;
            modeCompatibleLinks.add(link);
        }
        return modeCompatibleLinks;
    }
}

