/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.intermodal;

import java.net.URL;
import java.util.logging.Logger;
import org.goplanit.converter.intermodal.IntermodalReader;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.osm.converter.intermodal.OsmIntermodalReaderSettings;
import org.goplanit.osm.converter.network.OsmNetworkReader;
import org.goplanit.osm.converter.network.OsmNetworkReaderFactory;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.converter.zoning.OsmPublicTransportReaderSettings;
import org.goplanit.osm.converter.zoning.OsmZoningReader;
import org.goplanit.osm.converter.zoning.OsmZoningReaderFactory;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;
import org.goplanit.osm.util.PlanitZoningUtils;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.misc.Pair;
import org.goplanit.zoning.Zoning;

public class OsmIntermodalReader
implements IntermodalReader {
    private static final Logger LOGGER = Logger.getLogger(OsmIntermodalReader.class.getCanonicalName());
    private OsmIntermodalReaderSettings settings;
    private Zoning zoningToPopulate;

    private boolean isSettingsValid() throws PlanItException {
        OsmNetworkReaderSettings networkSettings = this.getSettings().getNetworkSettings();
        OsmPublicTransportReaderSettings ptSettings = this.getSettings().getPublicTransportSettings();
        if (!networkSettings.getCountryName().equals(ptSettings.getCountryName())) {
            LOGGER.severe(String.format("OSM intermodal reader requires both the network and zoning (pt) to utilise the same source country upon parsing, found %s and %s respctively instead", networkSettings.getCountryName(), ptSettings.getCountryName()));
            return false;
        }
        if (!networkSettings.getInputSource().equals(ptSettings.getInputSource())) {
            LOGGER.warning(String.format("OSM intermodal reader requires both the network and zoning (pt) to utilise the same osm input file upon parsing, found %s and %s respctively instead", networkSettings.getInputSource(), ptSettings.getInputSource()));
            if (networkSettings.getInputSource() != null) {
                LOGGER.warning(String.format("SALVAGED: set zoning input file to network input file instead: %s", networkSettings.getInputSource()));
                ptSettings.setInputSource(networkSettings.getInputSource());
            } else if (ptSettings.getInputSource() != null) {
                LOGGER.warning(String.format("SALVAGED: set network input file to zoning input file instead: %s", ptSettings.getInputSource()));
                networkSettings.setInputSource(ptSettings.getInputSource());
            } else {
                return false;
            }
        }
        return true;
    }

    private void removeDanglingSubNetworks(OsmNetworkReader osmNetworkReader, OsmZoningReader osmZoningReader, Zoning zoning) throws PlanItException {
        if (osmNetworkReader.getSettings().isRemoveDanglingSubnetworks()) {
            osmNetworkReader.removeDanglingSubNetworks(zoning);
        }
        if (osmZoningReader.getSettings().isRemoveDanglingZones()) {
            PlanitZoningUtils.removeDanglingZones(zoning);
        }
        if (osmZoningReader.getSettings().isRemoveDanglingTransferZoneGroups()) {
            PlanitZoningUtils.removeDanglingTransferZoneGroups(zoning);
        }
    }

    protected OsmIntermodalReader(String countryName, PlanitOsmNetwork osmNetworkToPopulate, Zoning zoningToPopulate) {
        this(new OsmIntermodalReaderSettings(countryName, osmNetworkToPopulate), zoningToPopulate);
    }

    protected OsmIntermodalReader(URL inputSource, String countryName, PlanitOsmNetwork osmNetworkToPopulate, Zoning zoningToPopulate) {
        this(new OsmIntermodalReaderSettings(inputSource, countryName, osmNetworkToPopulate), zoningToPopulate);
    }

    protected OsmIntermodalReader(OsmNetworkReaderSettings networkSettings, OsmPublicTransportReaderSettings ptSettings, PlanitOsmNetwork osmNetworkToPopulate, Zoning zoningToPopulate) throws PlanItException {
        this(new OsmIntermodalReaderSettings(networkSettings, ptSettings), zoningToPopulate);
        this.getSettings().getPublicTransportSettings().setReferenceNetwork(osmNetworkToPopulate);
    }

    protected OsmIntermodalReader(OsmIntermodalReaderSettings settings, Zoning zoningToPopulate) {
        this.settings = settings;
        this.zoningToPopulate = zoningToPopulate;
        this.getSettings().getNetworkSettings().activateRailwayParser(true);
    }

    @Override
    public Pair<MacroscopicNetwork, Zoning> read() throws PlanItException {
        if (!this.isSettingsValid()) {
            return null;
        }
        OsmNetworkReader osmNetworkReader = OsmNetworkReaderFactory.create(this.getSettings().getNetworkSettings());
        boolean originalRemoveDanglingSubNetworks = osmNetworkReader.getSettings().isRemoveDanglingSubnetworks();
        osmNetworkReader.getSettings().setRemoveDanglingSubnetworks(false);
        PlanitOsmNetwork network = (PlanitOsmNetwork)osmNetworkReader.read();
        OsmPublicTransportReaderSettings ptSettings = this.getSettings().getPublicTransportSettings();
        ptSettings.setReferenceNetwork(network);
        ptSettings.setNetworkDataForZoningReader(osmNetworkReader.createNetworkToZoningReaderData());
        OsmZoningReader osmZoningReader = OsmZoningReaderFactory.create(ptSettings, this.zoningToPopulate);
        boolean originalRemoveDanglingZones = osmZoningReader.getSettings().isRemoveDanglingZones();
        boolean originalRemoveDanglingTransferZoneGroups = osmZoningReader.getSettings().isRemoveDanglingTransferZoneGroups();
        osmZoningReader.getSettings().activateParser(true);
        osmZoningReader.getSettings().setRemoveDanglingZones(false);
        osmZoningReader.getSettings().setRemoveDanglingTransferZoneGroups(false);
        Zoning zoning = osmZoningReader.read();
        osmNetworkReader.getSettings().setRemoveDanglingSubnetworks(originalRemoveDanglingSubNetworks);
        osmZoningReader.getSettings().setRemoveDanglingZones(originalRemoveDanglingZones);
        osmZoningReader.getSettings().setRemoveDanglingTransferZoneGroups(originalRemoveDanglingTransferZoneGroups);
        this.removeDanglingSubNetworks(osmNetworkReader, osmZoningReader, zoning);
        return Pair.of(network, zoning);
    }

    @Override
    public void reset() {
        this.getSettings().reset();
    }

    @Override
    public OsmIntermodalReaderSettings getSettings() {
        return this.settings;
    }
}

