/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.intermodal;

import java.net.URL;
import java.nio.file.Paths;
import org.goplanit.osm.converter.intermodal.OsmIntermodalReader;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.converter.zoning.OsmPublicTransportReaderSettings;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.zoning.Zoning;

public class OsmIntermodalReaderFactory {
    public static OsmIntermodalReader create() {
        return OsmIntermodalReaderFactory.create("global");
    }

    public static OsmIntermodalReader create(String countryName) {
        return OsmIntermodalReaderFactory.create((URL)null, countryName);
    }

    public static OsmIntermodalReader create(String inputFile, String countryName) throws PlanItException {
        try {
            return OsmIntermodalReaderFactory.create(Paths.get(inputFile, new String[0]).toUri().toURL(), countryName);
        }
        catch (Exception e) {
            throw new PlanItException("Unable to convert input file %s to URL", (Throwable)e, inputFile);
        }
    }

    public static OsmIntermodalReader create(String inputFile, String countryName, PlanitOsmNetwork osmNetworkToPopulate, Zoning zoningToPopulate) throws PlanItException {
        try {
            return OsmIntermodalReaderFactory.create(Paths.get(inputFile, new String[0]).toUri().toURL(), countryName, osmNetworkToPopulate, zoningToPopulate);
        }
        catch (Exception e) {
            throw new PlanItException("Unable to convert input file %s to URL", (Throwable)e, inputFile);
        }
    }

    public static OsmIntermodalReader create(URL inputSource, String countryName) {
        PlanitOsmNetwork networkToPopulate = new PlanitOsmNetwork(IdGroupingToken.collectGlobalToken());
        return OsmIntermodalReaderFactory.create(inputSource, countryName, networkToPopulate, new Zoning(networkToPopulate.getIdGroupingToken(), networkToPopulate.getNetworkGroupingTokenId()));
    }

    public static OsmIntermodalReader create(URL inputSource, String countryName, PlanitOsmNetwork osmNetworkToPopulate, Zoning zoningToPopulate) {
        return new OsmIntermodalReader(inputSource, countryName, osmNetworkToPopulate, zoningToPopulate);
    }

    public static OsmIntermodalReader create(OsmNetworkReaderSettings networkSettings, OsmPublicTransportReaderSettings ptSettings) throws PlanItException {
        return OsmIntermodalReaderFactory.create(networkSettings, ptSettings, new PlanitOsmNetwork());
    }

    public static OsmIntermodalReader create(OsmNetworkReaderSettings networkSettings, PlanitOsmNetwork osmNetworkToPopulate) throws PlanItException {
        return OsmIntermodalReaderFactory.create(networkSettings, new OsmPublicTransportReaderSettings(networkSettings.getCountryName()), osmNetworkToPopulate, new Zoning(osmNetworkToPopulate.getIdGroupingToken(), osmNetworkToPopulate.getNetworkGroupingTokenId()));
    }

    public static OsmIntermodalReader create(OsmNetworkReaderSettings networkSettings, OsmPublicTransportReaderSettings ptSettings, PlanitOsmNetwork osmNetworkToPopulate) throws PlanItException {
        return OsmIntermodalReaderFactory.create(networkSettings, ptSettings, osmNetworkToPopulate, new Zoning(osmNetworkToPopulate.getIdGroupingToken(), osmNetworkToPopulate.getNetworkGroupingTokenId()));
    }

    public static OsmIntermodalReader create(OsmNetworkReaderSettings networkSettings, OsmPublicTransportReaderSettings ptSettings, PlanitOsmNetwork osmNetworkToPopulate, Zoning zoningToPopulate) throws PlanItException {
        return new OsmIntermodalReader(networkSettings, ptSettings, osmNetworkToPopulate, zoningToPopulate);
    }
}

