/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.goplanit.osm.converter.network.OsmWaySettings;
import org.goplanit.osm.defaults.OsmHighwayTypeConfiguration;
import org.goplanit.osm.defaults.OsmModeAccessDefaultsCategory;
import org.goplanit.osm.defaults.OsmSpeedLimitDefaultsCategory;
import org.goplanit.osm.tags.OsmHighwayTags;
import org.goplanit.osm.tags.OsmRailModeTags;
import org.goplanit.osm.tags.OsmRoadModeTags;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.Modes;
import org.goplanit.utils.mode.PredefinedModeType;

public class OsmHighwaySettings
extends OsmWaySettings {
    private static final Logger LOGGER = Logger.getLogger(OsmHighwaySettings.class.getCanonicalName());
    OsmSpeedLimitDefaultsCategory nonUrbanSpeedLimitDefaults;
    protected final Map<String, Pair<Double, Double>> overwriteByOsmHighwayType = new HashMap<String, Pair<Double, Double>>();
    protected String defaultOsmHighwayTypeWhenUnsupported = DEFAULT_HIGHWAY_TYPE_WHEN_UNSUPPORTED;
    protected boolean speedLimitDefaultsBasedOnUrbanArea = DEFAULT_SPEEDLIMIT_BASED_ON_URBAN_AREA;
    public static String DEFAULT_HIGHWAY_TYPE_WHEN_UNSUPPORTED = "tertiary";
    public static boolean DEFAULT_SPEEDLIMIT_BASED_ON_URBAN_AREA = true;
    public static boolean DEFAULT_HIGHWAYS_PARSER_ACTIVE = true;

    protected void initialiseDefaultMappingFromOsmRoadModes2PlanitModes(Modes planitModes) throws PlanItException {
        planitModes.getFactory().registerNew(PredefinedModeType.PEDESTRIAN);
        planitModes.getFactory().registerNew(PredefinedModeType.BICYCLE);
        planitModes.getFactory().registerNew(PredefinedModeType.MOTOR_BIKE);
        planitModes.getFactory().registerNew(PredefinedModeType.CAR);
        planitModes.getFactory().registerNew(PredefinedModeType.GOODS_VEHICLE);
        planitModes.getFactory().registerNew(PredefinedModeType.HEAVY_GOODS_VEHICLE);
        planitModes.getFactory().registerNew(PredefinedModeType.LARGE_HEAVY_GOODS_VEHICLE);
        planitModes.getFactory().registerNew(PredefinedModeType.BUS);
        this.addOsmMode2PlanitModeMapping("foot", planitModes.get(PredefinedModeType.PEDESTRIAN));
        this.addOsmMode2PlanitModeMapping("bicycle", planitModes.get(PredefinedModeType.BICYCLE));
        this.addOsmMode2PlanitModeMapping("motorcycle", planitModes.get(PredefinedModeType.MOTOR_BIKE));
        this.addOsmMode2PlanitModeMapping("motorcar", planitModes.get(PredefinedModeType.CAR));
        this.addOsmMode2PlanitModeMapping("goods", planitModes.get(PredefinedModeType.GOODS_VEHICLE));
        this.addOsmMode2PlanitModeMapping("hgv", planitModes.get(PredefinedModeType.HEAVY_GOODS_VEHICLE));
        this.addOsmMode2PlanitModeMapping("hgv_articulated", planitModes.get(PredefinedModeType.LARGE_HEAVY_GOODS_VEHICLE));
        this.addOsmMode2PlanitModeMapping("bus", planitModes.get(PredefinedModeType.BUS));
        this.setModeExternalIdsBasedOnMappedOsmModes();
    }

    @Override
    protected Collection<String> collectAllowedOsmWayModes(String osmWayValueType) {
        HashSet<String> allowedModes = null;
        if (OsmHighwayTags.isRoadBasedHighwayValueTag(osmWayValueType)) {
            Set<String> allowedRoadModesOnRoad = this.collectAllowedOsmWayModes(osmWayValueType, OsmRoadModeTags.getSupportedRoadModeTags());
            Set<String> allowedRailModesOnRoad = this.collectAllowedOsmWayModes(osmWayValueType, OsmRailModeTags.getSupportedRailModeTags());
            allowedModes = new HashSet<String>();
            allowedModes.addAll(allowedRoadModesOnRoad);
            allowedModes.addAll(allowedRailModesOnRoad);
        } else {
            LOGGER.warning(String.format("unrecognised osm highway key value type highway=%s, no allowed modes can be identified", osmWayValueType));
        }
        return allowedModes;
    }

    protected OsmHighwaySettings(OsmSpeedLimitDefaultsCategory urbanSpeedLimitDefaults, OsmSpeedLimitDefaultsCategory nonUrbanSpeedLimitDefaults, OsmModeAccessDefaultsCategory osmModeAccessHighwayDefaults) {
        super(new OsmHighwayTypeConfiguration(), urbanSpeedLimitDefaults, osmModeAccessHighwayDefaults);
        this.activateParser(DEFAULT_HIGHWAYS_PARSER_ACTIVE);
        this.nonUrbanSpeedLimitDefaults = nonUrbanSpeedLimitDefaults;
    }

    public final String getDefaultOsmHighwayTypeWhenUnsupported() {
        return this.defaultOsmHighwayTypeWhenUnsupported;
    }

    public void setDefaultWhenOsmHighwayTypeUnsupported(String defaultOsmHighwayValueWhenUnsupported) {
        this.defaultOsmHighwayTypeWhenUnsupported = defaultOsmHighwayValueWhenUnsupported;
    }

    public final boolean isApplyDefaultWhenOsmHighwayTypeDeactivated() {
        return this.defaultOsmHighwayTypeWhenUnsupported == null;
    }

    public final void removeOsmHighwayTypeWhenUnsupported() {
        this.defaultOsmHighwayTypeWhenUnsupported = null;
    }

    public boolean isOsmHighWayTypeDeactivated(String osmHighwayValue) {
        return this.isOsmWayTypeDeactivated(osmHighwayValue);
    }

    public boolean isOsmHighwayTypeActivated(String osmWayValue) {
        return this.isOsmWayTypeActivated(osmWayValue);
    }

    public void deactivateOsmHighwayType(String osmWayValue) {
        this.deactivateOsmWayType(osmWayValue);
    }

    public void deactivateAllOsmHighWayTypes() {
        this.deactivateAllOsmWayTypes();
    }

    public void deactivateAllOsmHighwayTypesExcept(String ... osmHighwayTypes) {
        this.deactivateAllOsmHighwayTypesExcept(List.of(osmHighwayTypes));
    }

    public void deactivateAllOsmHighwayTypesExcept(List<String> osmHighwayTypes) {
        this.deactivateAllOsmHighWayTypes();
        for (String osmWayType : osmHighwayTypes) {
            if (!OsmHighwayTags.isRoadBasedHighwayValueTag(osmWayType)) continue;
            this.activateOsmHighwayTypes(osmWayType);
        }
    }

    public void activateOsmHighwayType(String osmWayValue) {
        this.activateOsmWayType(osmWayValue);
    }

    public void activateOsmHighwayTypes(String ... osmHighwayValueTypes) {
        this.activateOsmWayTypes(osmHighwayValueTypes);
    }

    public void activateOsmHighwayTypes(List<String> osmHighwayValueTypes) {
        this.activateOsmWayTypes(osmHighwayValueTypes);
    }

    public void activateAllOsmHighwayTypes() {
        this.activateAllOsmWayTypes();
    }

    public void overwriteCapacityMaxDensityDefaults(String osmHighwayType, Number capacityPerLanePerHour, Number maxDensityPerLane) {
        this.overwriteOsmWayTypeDefaultCapacityMaxDensity("highway", osmHighwayType, capacityPerLanePerHour.doubleValue(), maxDensityPerLane.doubleValue());
    }

    public final Pair<Double, Double> getOverwrittenCapacityMaxDensityByOsmHighwayType(String osmWayType) {
        return this.getOverwrittenCapacityMaxDensityByOsmWayType(osmWayType);
    }

    public boolean isDefaultCapacityOrMaxDensityOverwrittenByOsmHighwayType(String osmWayType) {
        return this.isDefaultCapacityOrMaxDensityOverwrittenByOsmWayType(osmWayType);
    }

    public boolean isSpeedLimitDefaultsBasedOnUrbanArea() {
        return this.speedLimitDefaultsBasedOnUrbanArea;
    }

    public void setSpeedLimitDefaultsBasedOnUrbanArea(boolean speedLimitDefaultsBasedOnUrbanArea) {
        this.speedLimitDefaultsBasedOnUrbanArea = speedLimitDefaultsBasedOnUrbanArea;
    }

    public double getDefaultSpeedLimitByOsmHighwayType(String osmWayValue) throws PlanItException {
        if (this.isSpeedLimitDefaultsBasedOnUrbanArea()) {
            return this.getDefaultSpeedLimitByOsmWayType(osmWayValue);
        }
        return this.nonUrbanSpeedLimitDefaults.getSpeedLimit(osmWayValue);
    }

    public Double getDefaultSpeedLimitByOsmHighwayType(Map<String, String> tags) throws PlanItException {
        String osmWayKey = null;
        if (!tags.containsKey("highway")) {
            throw new PlanItException("no OSM highway key contained in provided osmTags when collecting default speed limit by OsmHighwayType");
        }
        osmWayKey = "highway";
        return this.getDefaultSpeedLimitByOsmHighwayType(tags.get(osmWayKey));
    }

    public void setOsmRoadMode2PlanitModeMapping(String osmRoadMode, Mode planitMode) {
        if (!OsmRoadModeTags.isRoadModeTag(osmRoadMode)) {
            LOGGER.warning(String.format("OSM road mode %s is not recognised when adding it to OSM to PLANit mode mapping, ignored", osmRoadMode));
            return;
        }
        this.setOsmMode2PlanitModeMapping(osmRoadMode, planitMode);
    }

    public void removeOsmRoadModePlanitModeMapping(String osmRoadMode) {
        if (!OsmRoadModeTags.isRoadModeTag(osmRoadMode)) {
            LOGGER.warning(String.format("osm road mode %s is not recognised when removing it from OSM to PLANit mode mapping, ignored", osmRoadMode));
            return;
        }
        this.removeOsmMode2PlanitModeMapping(osmRoadMode);
    }

    public void removeOsmRoadModePlanitModeMapping(List<String> osmRoadModes) {
        if (osmRoadModes == null) {
            return;
        }
        osmRoadModes.forEach(osmRoadMode -> this.removeOsmRoadModePlanitModeMapping((String)osmRoadMode));
    }

    public void deactivateAllRoadModesExcept(String ... deactivateAllRoadModesExcept) {
        List<String> exceptionList = null;
        exceptionList = deactivateAllRoadModesExcept == null ? new ArrayList<String>(0) : Arrays.asList(deactivateAllRoadModesExcept);
        this.deactivateAllRoadModesExcept(exceptionList);
    }

    public void deactivateAllRoadModesExcept(List<String> remainingOsmRoadModes) {
        Collection<String> toBeRemovedModes = OsmRoadModeTags.getSupportedRoadModeTags();
        this.deactivateAllModesExcept(toBeRemovedModes, remainingOsmRoadModes);
    }

    public void deactivateRoadModes(String ... osmRoadModes) {
        this.deactivateRoadModes(Arrays.asList(osmRoadModes));
    }

    public void deactivateRoadModes(List<String> osmRoadModes) {
        this.deactivateOsmModes(osmRoadModes);
    }

    public void removeAllRoadModes() {
        this.deactivateAllRoadModesExcept((String[])null);
    }

    public Mode getMappedPlanitRoadMode(String osmMode) {
        if (OsmRoadModeTags.isRoadModeTag(osmMode)) {
            return this.getMappedPlanitMode(osmMode);
        }
        return null;
    }

    public final Collection<String> getMappedOsmRoadModes(Mode planitMode) {
        return this.getMappedOsmModes(planitMode);
    }

    public Collection<String> collectAllowedOsmHighwayModes(String osmHighwayValueType) {
        return this.collectAllowedOsmWayModes(osmHighwayValueType);
    }

    public void addAllowedHighwayModes(String osmHighwayType, String ... osmModes) {
        this.addAllowedHighwayModes(osmHighwayType, Arrays.asList(osmModes));
    }

    public void addAllowedHighwayModes(String osmHighwayType, List<String> osmModes) {
        this.addAllowedOsmWayModes(osmHighwayType, osmModes);
    }

    public void logUnsupportedOsmHighwayTypes() {
        this.logUnsupportedOsmWayTypes();
    }
}

