/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import de.topobyte.osm4j.core.model.iface.OsmNode;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.goplanit.graph.modifier.event.handler.SyncXmlIdToIdBreakEdgeHandler;
import org.goplanit.graph.modifier.event.handler.SyncXmlIdToIdBreakEdgeSegmentHandler;
import org.goplanit.network.layer.macroscopic.AccessGroupPropertiesFactory;
import org.goplanit.osm.converter.network.OsmNetworkHandlerHelper;
import org.goplanit.osm.converter.network.OsmNetworkLayerModeParser;
import org.goplanit.osm.converter.network.OsmNetworkReaderData;
import org.goplanit.osm.converter.network.OsmNetworkReaderLayerData;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.physical.network.macroscopic.ModifiedLinkSegmentTypes;
import org.goplanit.osm.tags.OsmHighwayTags;
import org.goplanit.osm.tags.OsmLaneTags;
import org.goplanit.osm.tags.OsmOneWayTags;
import org.goplanit.osm.tags.OsmRailwayTags;
import org.goplanit.osm.util.OsmNodeUtils;
import org.goplanit.osm.util.OsmWayUtils;
import org.goplanit.osm.util.PlanitOsmUtils;
import org.goplanit.utils.arrays.ArrayUtils;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.network.layer.physical.Node;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;

public class OsmNetworkLayerParser {
    private static final Logger LOGGER = Logger.getLogger(OsmNetworkLayerParser.class.getCanonicalName());
    private final OsmNetworkReaderLayerData layerData;
    private final ModifiedLinkSegmentTypes modifiedLinkSegmentTypes = new ModifiedLinkSegmentTypes();
    private final OsmNetworkReaderData networkData;
    private final OsmNetworkReaderSettings settings;
    private final MacroscopicNetworkLayer networkLayer;
    private final OsmNetworkLayerModeParser modeParser;
    private final PlanitJtsCrsUtils geoUtils;
    private final SyncXmlIdToIdBreakEdgeHandler syncXmlIdToIdOnBreakLink = new SyncXmlIdToIdBreakEdgeHandler();
    private final SyncXmlIdToIdBreakEdgeSegmentHandler syncXmlIdToIdOnBreakLinkSegment = new SyncXmlIdToIdBreakEdgeSegmentHandler();

    private void initialiseEventListeners() {
        this.networkLayer.getLayerModifier().removeAllListeners();
        this.networkLayer.getLayerModifier().addListener(this.syncXmlIdToIdOnBreakLink);
        this.networkLayer.getLayerModifier().addListener(this.syncXmlIdToIdOnBreakLinkSegment);
    }

    private boolean isNearNetworkBoundingBox(Geometry geometry, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        return geoUtils.isGeometryNearBoundingBox(geometry, this.networkData.getBoundingBox(), 200.0);
    }

    private MacroscopicLinkSegmentType updateExistingLinkSegmentType(Set<Mode> toBeAddedModes, Set<Mode> toBeRemovedModes, Map<String, String> tags, MacroscopicLinkSegmentType linkSegmentType) throws PlanItException {
        MacroscopicLinkSegmentType finalLinkSegmentType = linkSegmentType;
        if (!(toBeAddedModes.isEmpty() && toBeRemovedModes.isEmpty() || (finalLinkSegmentType = this.modifiedLinkSegmentTypes.getModifiedLinkSegmentType(linkSegmentType, toBeAddedModes, toBeRemovedModes)) != null)) {
            finalLinkSegmentType = (MacroscopicLinkSegmentType)this.networkLayer.getLinkSegmentTypes().getFactory().createUniqueCopyOf(linkSegmentType);
            this.networkLayer.getLinkSegmentTypes().register(finalLinkSegmentType);
            finalLinkSegmentType.setXmlId(Long.toString(finalLinkSegmentType.getId()));
            if (!toBeAddedModes.isEmpty()) {
                double osmWayTypeMaxSpeed = this.settings.getDefaultSpeedLimitByOsmWayType(tags);
                AccessGroupPropertiesFactory.createOnLinkSegmentType(finalLinkSegmentType, osmWayTypeMaxSpeed, toBeAddedModes);
            }
            if (!toBeRemovedModes.isEmpty()) {
                finalLinkSegmentType.removeModeAccess(toBeRemovedModes);
            }
            this.modifiedLinkSegmentTypes.addModifiedLinkSegmentType(linkSegmentType, finalLinkSegmentType, toBeAddedModes, toBeRemovedModes);
        }
        return finalLinkSegmentType;
    }

    private void registerLinkInternalOsmNodes(Link link, int startIndex, int endIndex, OsmWay osmWay) throws PlanItException {
        for (int internalLocationIndex = startIndex; internalLocationIndex <= endIndex; ++internalLocationIndex) {
            OsmNode osmnode = this.networkData.getOsmNode(osmWay.getNodeId(internalLocationIndex));
            if (osmnode != null) {
                this.layerData.registerOsmNodeAsInternalToPlanitLink(osmnode, link);
                continue;
            }
            LOGGER.fine(String.format("OSM node %d not available although internal to parseable osm way %d, possibly outside bounding box", osmWay.getNodeId(internalLocationIndex), osmWay.getId()));
        }
    }

    private Link createAndPopulateLink(OsmWay osmWay, Map<String, String> tags, int startNodeIndex, int endNodeIndex, boolean allowTruncationIfGeometryIncomplete) throws PlanItException {
        PlanItException.throwIf(startNodeIndex < 0 || startNodeIndex >= osmWay.getNumberOfNodes(), String.format("invalid start node index %d when extracting link from Osm way %s", startNodeIndex, osmWay.getId()), new Object[0]);
        PlanItException.throwIf(endNodeIndex < 0 || endNodeIndex >= osmWay.getNumberOfNodes(), String.format("invalid end node index %d when extracting link from Osm way %s", startNodeIndex, osmWay.getId()), new Object[0]);
        Pair<Node, Integer> nodeFirstResult = this.extractFirstNode(osmWay, startNodeIndex, allowTruncationIfGeometryIncomplete);
        if (nodeFirstResult == null || nodeFirstResult.first() == null) {
            return null;
        }
        Pair<Node, Integer> nodeLastResult = this.extractLastNode(osmWay, nodeFirstResult.second(), endNodeIndex, allowTruncationIfGeometryIncomplete);
        if (nodeLastResult == null || nodeLastResult.first() == null) {
            return null;
        }
        Node nodeFirst = nodeFirstResult.first();
        Node nodeLast = nodeLastResult.first();
        if (nodeLast.idEquals(nodeFirst)) {
            LOGGER.fine(String.format("DISCARD: Osm way %d truncated to single node, unable to create planit link for it", osmWay.getId()));
            return null;
        }
        LineString lineString = null;
        try {
            lineString = this.extractPartialLinkGeometry(osmWay, nodeFirstResult.second(), nodeLastResult.second());
        }
        catch (PlanItException e) {
            LOGGER.fine(String.format("OSM way %s internal geometry incomplete, one or more internal nodes could not be created, likely outside bounding box", osmWay.getId()));
            return null;
        }
        Link link = null;
        if (nodeFirst != null) {
            Set<Edge> potentialEdges = nodeFirst.getEdges(nodeLast);
            for (Edge potentialEdge : potentialEdges) {
                Link potentialLink = (Link)potentialEdge;
                if (link == null || !potentialLink.getGeometry().equals(lineString)) continue;
                link = potentialLink;
                break;
            }
        }
        if (link == null) {
            double linkLength = 0.0;
            linkLength = this.geoUtils.getDistanceInKilometres(lineString);
            link = this.networkLayer.getLinks().getFactory().registerNew(nodeFirst, nodeLast, linkLength, true);
            link.setGeometry(lineString);
            link.setXmlId(Long.toString(link.getId()));
            link.setExternalId(String.valueOf(osmWay.getId()));
            if (tags.containsKey("name")) {
                link.setName(tags.get("name"));
            }
            if (OsmHighwayTags.hasHighwayKeyTag(tags)) {
                OsmNetworkHandlerHelper.setLinkOsmWayType(link, tags.get("highway"));
            } else if (OsmRailwayTags.hasRailwayKeyTag(tags)) {
                OsmNetworkHandlerHelper.setLinkOsmWayType(link, tags.get("railway"));
            }
        }
        return link;
    }

    private MacroscopicLinkSegmentType extractDirectionalLinkSegmentTypeByOsmWay(OsmWay osmWay, Map<String, String> tags, MacroscopicLinkSegmentType linkSegmentType, boolean forwardDirection) throws PlanItException {
        Set<Mode> toBeAddedModes = null;
        Set<Mode> toBeRemovedModes = null;
        if (this.settings.isModeAccessOverwrittenByOsmWayId(osmWay.getId())) {
            Set<Mode> allowedPlanitModes = this.settings.getMappedPlanitModes(this.settings.getModeAccessOverwrittenByOsmWayId(osmWay.getId()));
            if (!allowedPlanitModes.isEmpty()) {
                allowedPlanitModes.retainAll(this.networkLayer.getSupportedModes());
            }
            toBeAddedModes = linkSegmentType.getDisallowedModesFrom(allowedPlanitModes);
            toBeRemovedModes = linkSegmentType.getAllowedModesNotIn(allowedPlanitModes);
        } else {
            boolean accessTagAppliesToExploredDirection;
            Set<Mode> excludedModes = this.modeParser.getExplicitlyExcludedModes(tags, forwardDirection, this.settings);
            Set<Mode> includedModes = this.modeParser.getExplicitlyIncludedModes(tags, forwardDirection, this.settings);
            boolean isOneWay = OsmOneWayTags.isOneWay(tags);
            boolean bl = accessTagAppliesToExploredDirection = !isOneWay || forwardDirection || OsmOneWayTags.isReversedOneWay(tags);
            if (accessTagAppliesToExploredDirection && tags.containsKey("access")) {
                this.modeParser.updateAccessKeyBasedModeRestrictions(tags, includedModes, excludedModes);
            }
            if (!includedModes.isEmpty()) {
                includedModes.retainAll(this.networkLayer.getSupportedModes());
            }
            toBeAddedModes = linkSegmentType.getDisallowedModesFrom(includedModes);
            toBeRemovedModes = linkSegmentType.getAllowedModesFrom(excludedModes);
        }
        MacroscopicLinkSegmentType finalLinkSegmentType = this.updateExistingLinkSegmentType(toBeAddedModes, toBeRemovedModes, tags, linkSegmentType);
        return finalLinkSegmentType;
    }

    private LineString extractPartialLinkGeometry(OsmWay osmWay, int startNodeIndex, int endNodeIndex) throws PlanItException {
        LineString lineString = OsmWayUtils.extractLineStringNoThrow(osmWay, startNodeIndex, endNodeIndex, this.networkData.getOsmNodes());
        lineString = PlanitJtsUtils.createCopyWithoutAdjacentDuplicateCoordinates(lineString);
        return lineString;
    }

    private Pair<Double, Double> extractDirectionalSpeedLimits(Link link, Map<String, String> tags) throws PlanItException {
        double[] maxSpeedLimitLanes;
        Double speedLimitForwardKmh = null;
        Double speedLimitBackwardKmh = null;
        if (tags.containsKey("maxspeed:backward") || tags.containsKey("maxspeed:backward:lanes")) {
            if (tags.containsKey("maxspeed:backward")) {
                speedLimitBackwardKmh = PlanitOsmUtils.parseMaxSpeedValueKmPerHour(tags.get("maxspeed:backward"));
            }
            if (tags.containsKey("maxspeed:backward:lanes")) {
                maxSpeedLimitLanes = PlanitOsmUtils.parseMaxSpeedValueLanesKmPerHour(tags.get("maxspeed:backward:lanes"));
                speedLimitBackwardKmh = ArrayUtils.getMaximum(maxSpeedLimitLanes);
            }
        }
        if (tags.containsKey("maxspeed:forward") || tags.containsKey("maxspeed:forward:lanes")) {
            if (tags.containsKey("maxspeed:forward")) {
                speedLimitForwardKmh = PlanitOsmUtils.parseMaxSpeedValueKmPerHour(tags.get("maxspeed:forward"));
            }
            if (tags.containsKey("maxspeed:forward:lanes")) {
                maxSpeedLimitLanes = PlanitOsmUtils.parseMaxSpeedValueLanesKmPerHour(tags.get("maxspeed:forward:lanes"));
                speedLimitForwardKmh = ArrayUtils.getMaximum(maxSpeedLimitLanes);
            }
        }
        if (speedLimitBackwardKmh == null || speedLimitForwardKmh == null) {
            Double nonDirectionalSpeedLimitKmh = null;
            if (tags.containsKey("maxspeed")) {
                nonDirectionalSpeedLimitKmh = PlanitOsmUtils.parseMaxSpeedValueKmPerHour(tags.get("maxspeed"));
            } else if (tags.containsKey("maxspeed:lanes")) {
                double[] maxSpeedLimitLanes2 = PlanitOsmUtils.parseMaxSpeedValueLanesKmPerHour(tags.get("maxspeed:lanes"));
                nonDirectionalSpeedLimitKmh = ArrayUtils.getMaximum(maxSpeedLimitLanes2);
            } else {
                nonDirectionalSpeedLimitKmh = this.settings.getDefaultSpeedLimitByOsmWayType(tags);
                this.layerData.getProfiler().incrementMissingSpeedLimitCounter();
            }
            if (nonDirectionalSpeedLimitKmh != null) {
                speedLimitForwardKmh = speedLimitForwardKmh == null ? nonDirectionalSpeedLimitKmh : speedLimitForwardKmh;
                speedLimitBackwardKmh = speedLimitBackwardKmh == null ? nonDirectionalSpeedLimitKmh : speedLimitBackwardKmh;
            } else {
                throw new PlanItException(String.format("no default speed limit available for OSM way %s", link.getExternalId()));
            }
        }
        return Pair.of(speedLimitForwardKmh, speedLimitBackwardKmh);
    }

    private Pair<Integer, Integer> extractDirectionalLanes(Link link, Map<String, String> tags, Pair<MacroscopicLinkSegmentType, MacroscopicLinkSegmentType> linkSegmentTypes) {
        Integer totalLanes = null;
        Integer lanesForward = null;
        Integer lanesBackward = null;
        String osmWayKey = null;
        if (tags.containsKey("highway")) {
            osmWayKey = "highway";
            if (tags.containsKey("lanes")) {
                totalLanes = Integer.parseInt(tags.get("lanes"));
            }
            if (tags.containsKey(OsmLaneTags.LANES_FORWARD)) {
                lanesForward = Integer.parseInt(tags.get(OsmLaneTags.LANES_FORWARD));
            }
            if (tags.containsKey(OsmLaneTags.LANES_BACKWARD)) {
                lanesBackward = Integer.parseInt(tags.get(OsmLaneTags.LANES_BACKWARD));
            }
            if (totalLanes != null && (lanesForward == null || lanesBackward == null) && OsmOneWayTags.isOneWay(tags)) {
                boolean isReversedOneWay = OsmOneWayTags.isReversedOneWay(tags);
                if (isReversedOneWay && lanesBackward == null) {
                    lanesBackward = totalLanes;
                } else if (!isReversedOneWay && lanesForward == null) {
                    lanesForward = totalLanes;
                } else if (lanesForward == null && lanesBackward == null && totalLanes % 2 == 0) {
                    lanesForward = lanesBackward = Integer.valueOf(totalLanes / 2);
                }
            }
        } else if (tags.containsKey("railway")) {
            osmWayKey = "railway";
            if (tags.containsKey("tracks")) {
                lanesBackward = lanesForward = Integer.valueOf(Integer.parseInt(tags.get("tracks")));
            }
        }
        if (lanesForward == null && lanesBackward == null) {
            lanesBackward = lanesForward = this.settings.getDefaultDirectionalLanesByWayType(osmWayKey, tags.get(osmWayKey));
            this.layerData.getProfiler().incrementMissingLaneCounter();
        }
        boolean missingLaneInformation = false;
        if (lanesForward == null && linkSegmentTypes.first() != null) {
            lanesForward = this.settings.getDefaultDirectionalLanesByWayType(osmWayKey, tags.get(osmWayKey));
            missingLaneInformation = true;
        }
        if (lanesBackward == null && linkSegmentTypes.second() != null) {
            lanesBackward = this.settings.getDefaultDirectionalLanesByWayType(osmWayKey, tags.get(osmWayKey));
            missingLaneInformation = true;
        }
        if (missingLaneInformation) {
            this.layerData.getProfiler().incrementMissingLaneCounter();
        }
        return Pair.of(lanesForward, lanesBackward);
    }

    private MacroscopicLinkSegment extractMacroscopicLinkSegment(OsmWay osmWay, Map<String, String> tags, Link link, MacroscopicLinkSegmentType linkSegmentType, boolean directionAb) throws PlanItException {
        MacroscopicLinkSegment linkSegment = (MacroscopicLinkSegment)link.getEdgeSegment(directionAb);
        if (linkSegment == null) {
            linkSegment = this.networkLayer.getLinkSegments().getFactory().registerNew(link, directionAb, true);
            linkSegment.setXmlId(Long.toString(linkSegment.getId()));
            linkSegment.setExternalId(link.getExternalId());
        } else {
            LOGGER.warning(String.format("Already exists link segment (id:%d) between OSM nodes (%s, %s) of OSM way (%d), ignored entity", linkSegment.getId(), link.getVertexA().getExternalId(), link.getVertexB().getExternalId(), osmWay.getId()));
        }
        linkSegment.setLinkSegmentType(linkSegmentType);
        this.layerData.getProfiler().logLinkSegmentStatus(this.networkLayer.getNumberOfLinkSegments());
        return linkSegment;
    }

    private void extractMacroscopicLinkSegments(OsmWay osmWay, Map<String, String> tags, Link link, Pair<MacroscopicLinkSegmentType, MacroscopicLinkSegmentType> linkSegmentTypes) throws PlanItException {
        MacroscopicLinkSegmentType linkSegmentTypeBa;
        MacroscopicLinkSegmentType linkSegmentTypeAb;
        boolean directionAbIsForward;
        boolean bl = directionAbIsForward = link.isGeometryInAbDirection();
        if (!directionAbIsForward) {
            LOGGER.warning("directionAB is not forward in geometry SHOULD NOT HAPPEN!");
        }
        Pair<Double, Double> speedLimits = this.extractDirectionalSpeedLimits(link, tags);
        Pair<Integer, Integer> lanes = this.extractDirectionalLanes(link, tags, linkSegmentTypes);
        MacroscopicLinkSegmentType macroscopicLinkSegmentType = linkSegmentTypeAb = directionAbIsForward ? linkSegmentTypes.first() : linkSegmentTypes.second();
        if (linkSegmentTypeAb != null) {
            this.extractMacroscopicLinkSegment(osmWay, tags, link, linkSegmentTypeAb, true);
            Double speedLimit = directionAbIsForward ? speedLimits.first() : speedLimits.second();
            link.getLinkSegmentAb().setPhysicalSpeedLimitKmH(speedLimit);
            link.getLinkSegmentAb().setNumberOfLanes(directionAbIsForward ? lanes.first() : lanes.second());
        }
        MacroscopicLinkSegmentType macroscopicLinkSegmentType2 = linkSegmentTypeBa = directionAbIsForward ? linkSegmentTypes.second() : linkSegmentTypes.first();
        if (linkSegmentTypeBa != null) {
            this.extractMacroscopicLinkSegment(osmWay, tags, link, linkSegmentTypeBa, false);
            link.getLinkSegmentBa().setPhysicalSpeedLimitKmH(directionAbIsForward ? speedLimits.second() : speedLimits.first());
            link.getLinkSegmentBa().setNumberOfLanes(directionAbIsForward ? lanes.second() : lanes.first());
        }
    }

    private Pair<Node, Integer> extractFirstNode(OsmWay osmWay, Integer startNodeIndex, boolean changeStartNodeIndexIfNotPresent) throws PlanItException {
        Node nodeFirst = this.extractNode(osmWay.getNodeId(startNodeIndex));
        if (nodeFirst == null && changeStartNodeIndexIfNotPresent) {
            if ((startNodeIndex = OsmWayUtils.findFirstAvailableOsmNodeIndexAfter(startNodeIndex, osmWay, this.networkData.getOsmNodes())) != null) {
                nodeFirst = this.extractNode(osmWay.getNodeId(startNodeIndex));
                if (nodeFirst != null && !this.isNearNetworkBoundingBox(nodeFirst.getPosition(), this.geoUtils)) {
                    LOGGER.warning(String.format("SALVAGED: Osm way %s geometry incomplete, likely cut-off by network bounding box, truncated at osm node %s", osmWay.getId(), nodeFirst.getExternalId()));
                }
            } else {
                return null;
            }
        }
        return Pair.of(nodeFirst, startNodeIndex);
    }

    private Pair<Node, Integer> extractLastNode(OsmWay osmWay, Integer startNodeIndex, Integer endNodeIndex, boolean changeEndNodeIndexIfNotPresent) throws PlanItException {
        Node nodeLast = this.extractNode(osmWay.getNodeId(endNodeIndex));
        if (nodeLast == null && changeEndNodeIndexIfNotPresent) {
            endNodeIndex = OsmWayUtils.findLastAvailableOsmNodeIndexAfter(startNodeIndex, osmWay, this.networkData.getOsmNodes());
            if (endNodeIndex != null) {
                nodeLast = this.extractNode(osmWay.getNodeId(endNodeIndex));
                if (nodeLast != null && !this.isNearNetworkBoundingBox(nodeLast.getPosition(), this.geoUtils)) {
                    LOGGER.fine(String.format("OSM way %s not fully available, likely due to network bounding box, please verify, truncated at osm node %s", osmWay.getId(), nodeLast.getExternalId()));
                }
            } else {
                return null;
            }
        }
        return Pair.of(nodeLast, endNodeIndex);
    }

    private Node extractNode(long osmNodeId) throws PlanItException {
        OsmNode osmNode = this.networkData.getOsmNode(osmNodeId);
        if (osmNode == null) {
            return null;
        }
        Node node = this.layerData.getPlanitNodeByOsmNode(osmNode);
        if (node == null) {
            node = OsmNetworkHandlerHelper.createPopulateAndRegisterNode(osmNode, this.networkLayer, this.layerData);
        }
        return node;
    }

    private Link extractLink(OsmWay osmWay, Map<String, String> tags, int startNodeIndex, int endNodeIndex, boolean allowTruncationIfGeometryIncomplete) throws PlanItException {
        Link link = this.createAndPopulateLink(osmWay, tags, startNodeIndex, endNodeIndex, allowTruncationIfGeometryIncomplete);
        if (link != null) {
            if (allowTruncationIfGeometryIncomplete) {
                startNodeIndex = OsmWayUtils.getOsmWayNodeIndexByLocation(osmWay, link.getNodeA().getPosition(), this.networkData);
                endNodeIndex = OsmWayUtils.getOsmWayNodeIndexByLocation(osmWay, link.getNodeB().getPosition(), this.networkData);
            }
            this.registerLinkInternalOsmNodes(link, startNodeIndex + 1, endNodeIndex - 1, osmWay);
            this.layerData.getProfiler().logLinkStatus(this.networkLayer.getNumberOfLinks());
        }
        return link;
    }

    protected Pair<MacroscopicLinkSegmentType, MacroscopicLinkSegmentType> updatedLinkSegmentTypeBasedOnOsmWay(OsmWay osmWay, Map<String, String> tags, MacroscopicLinkSegmentType linkSegmentType) throws PlanItException {
        boolean forwardDirection = true;
        MacroscopicLinkSegmentType forwardDirectionLinkSegmentType = this.extractDirectionalLinkSegmentTypeByOsmWay(osmWay, tags, linkSegmentType, forwardDirection);
        MacroscopicLinkSegmentType backwardDirectionLinkSegmentType = this.extractDirectionalLinkSegmentTypeByOsmWay(osmWay, tags, linkSegmentType, !forwardDirection);
        if (!forwardDirectionLinkSegmentType.hasAllowedModes()) {
            forwardDirectionLinkSegmentType = null;
        }
        if (!backwardDirectionLinkSegmentType.hasAllowedModes()) {
            backwardDirectionLinkSegmentType = null;
        }
        return Pair.of(forwardDirectionLinkSegmentType, backwardDirectionLinkSegmentType);
    }

    protected OsmNetworkLayerParser(MacroscopicNetworkLayer networkLayer, OsmNetworkReaderData networkData, OsmNetworkReaderSettings settings, PlanitJtsCrsUtils geoUtils) {
        this.networkLayer = networkLayer;
        this.networkData = networkData;
        this.geoUtils = geoUtils;
        this.settings = settings;
        this.layerData = new OsmNetworkReaderLayerData();
        this.modeParser = new OsmNetworkLayerModeParser(settings, networkLayer);
        this.initialiseEventListeners();
    }

    public Link extractPartialOsmWay(OsmWay osmWay, Map<String, String> tags, int startNodeIndex, int endNodeIndex, boolean isPartOfCircularWay, Pair<MacroscopicLinkSegmentType, MacroscopicLinkSegmentType> linkSegmentTypes) throws PlanItException {
        boolean allowGeometryTruncation;
        Link link = null;
        if (linkSegmentTypes != null && linkSegmentTypes.anyIsNotNull() && (link = this.extractLink(osmWay, tags, startNodeIndex, endNodeIndex, allowGeometryTruncation = !isPartOfCircularWay)) != null) {
            if (isPartOfCircularWay) {
                linkSegmentTypes = OsmWayUtils.isCircularWayDefaultDirectionClockwise(this.settings.getCountryName()) ? Pair.of(linkSegmentTypes.first(), null) : Pair.of(null, linkSegmentTypes.second());
            }
            this.extractMacroscopicLinkSegments(osmWay, tags, link, linkSegmentTypes);
        }
        return link;
    }

    protected boolean breakLinksWithInternalNode(Node thePlanitNode) throws PlanItException {
        Point osmNodeLocation = OsmNodeUtils.createPoint(Long.valueOf(thePlanitNode.getExternalId()), this.networkData.getOsmNodes());
        if (this.layerData.isLocationInternalToAnyLink(osmNodeLocation)) {
            List<Link> linksToBreak = this.layerData.findPlanitLinksWithInternalLocation(osmNodeLocation);
            Map<Long, Set<Link>> newOsmWaysWithMultipleLinks = OsmNetworkHandlerHelper.breakLinksWithInternalNode(thePlanitNode, linksToBreak, this.networkLayer, this.geoUtils.getCoordinateReferenceSystem());
            this.layerData.updateOsmWaysWithMultiplePlanitLinks(newOsmWaysWithMultipleLinks);
            return true;
        }
        return false;
    }

    protected void breakLinksWithInternalConnections() {
        LOGGER.info("Breaking OSM ways with internal connections into multiple links ...");
        try {
            long nodeIndex = -1L;
            long originalNumberOfNodes = this.networkLayer.getNumberOfNodes();
            HashSet<Long> processedOsmNodeIds = new HashSet<Long>();
            while (++nodeIndex < originalNumberOfNodes) {
                Node node = (Node)this.networkLayer.getNodes().get(nodeIndex);
                boolean linksBroken = this.breakLinksWithInternalNode(node);
                if (!linksBroken) continue;
                processedOsmNodeIds.add(Long.valueOf(node.getExternalId()));
            }
            Set<OsmNode> osmNodesInternalToPlanitLinks = this.layerData.getRegisteredOsmNodesInternalToAnyPlanitLink(2);
            for (OsmNode osmNode : osmNodesInternalToPlanitLinks) {
                if (processedOsmNodeIds.contains(osmNode.getId())) continue;
                Node planitIntersectionNode = this.extractNode(osmNode.getId());
                if (planitIntersectionNode == null) {
                    LOGGER.severe(String.format("OSM node %d internal to one or more OSM ways could not be extracted as PLANit node when breaking links at its location, this should not happen", osmNode.getId()));
                }
                this.breakLinksWithInternalNode(planitIntersectionNode);
            }
            LOGGER.info(String.format("Broke %d OSM ways into multiple links...DONE", this.getLayerData().getNumberOfOsmWaysWithMultiplePlanitLinks()));
        }
        catch (PlanItException e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe("unable to break OSM links with internal intersections");
        }
    }

    public void logProfileInformation() {
        this.layerData.getProfiler().logProfileInformation(this.networkLayer);
    }

    public void reset() {
        this.layerData.reset();
        this.modifiedLinkSegmentTypes.reset();
        this.initialiseEventListeners();
    }

    public void complete() {
        this.breakLinksWithInternalConnections();
        this.networkLayer.validate();
        this.logProfileInformation();
    }

    public OsmNetworkReaderLayerData getLayerData() {
        return this.layerData;
    }
}

