/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import de.topobyte.osm4j.core.model.iface.OsmNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import org.goplanit.osm.converter.network.OsmNetworkHandlerHelper;
import org.goplanit.osm.converter.network.OsmNetworkHandlerProfiler;
import org.goplanit.osm.util.OsmNodeUtils;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.network.layer.physical.Node;
import org.locationtech.jts.geom.Point;

public class OsmNetworkReaderLayerData {
    private static final Logger LOGGER = Logger.getLogger(OsmNetworkReaderLayerData.class.getCanonicalName());
    private final OsmNetworkHandlerProfiler profiler = new OsmNetworkHandlerProfiler();
    protected Map<Long, Set<Link>> osmWaysWithMultiplePlanitLinks = new HashMap<Long, Set<Link>>();
    protected final Map<Point, Pair<Node, OsmNode>> planitNodesByLocation = new HashMap<Point, Pair<Node, OsmNode>>();
    protected Map<Point, Pair<List<Link>, OsmNode>> originalLinkInternalAvailableLocations = new HashMap<Point, Pair<List<Link>, OsmNode>>();

    private void updateLinksForInternalLocation(Point location, Map<Long, Set<Link>> osmWaysWithMultiplePlanitLinks, List<Link> linksWithLocationInternally) {
        if (location != null && linksWithLocationInternally != null && !linksWithLocationInternally.isEmpty()) {
            HashSet<Link> replacementLinks = new HashSet<Link>();
            Iterator<Link> linksWithLocationInternal = linksWithLocationInternally.iterator();
            while (linksWithLocationInternal.hasNext()) {
                Link orginalLinkToBreak = linksWithLocationInternal.next();
                Long osmOriginalWayId = Long.valueOf(orginalLinkToBreak.getExternalId());
                if (osmWaysWithMultiplePlanitLinks == null || !osmWaysWithMultiplePlanitLinks.containsKey(osmOriginalWayId)) continue;
                Set<Link> earlierBrokenLinks = osmWaysWithMultiplePlanitLinks.get(osmOriginalWayId);
                Link matchingEarlierBrokenLink = null;
                boolean locationInternal = true;
                for (Link link : earlierBrokenLinks) {
                    Optional<Integer> coordinatePosition = PlanitJtsUtils.findFirstCoordinatePosition(location.getCoordinate(), link.getGeometry());
                    if (!coordinatePosition.isPresent()) continue;
                    matchingEarlierBrokenLink = link;
                    int position = coordinatePosition.get();
                    if (position != 0 && position != link.getGeometry().getNumPoints() - 1) break;
                    locationInternal = false;
                    break;
                }
                linksWithLocationInternal.remove();
                if (matchingEarlierBrokenLink == null) {
                    LOGGER.warning(String.format("unable to locate broken sublink of OSM way %s (id:%d), likely malformed way encountered, ignored", orginalLinkToBreak.getExternalId(), orginalLinkToBreak.getId()));
                    continue;
                }
                if (!locationInternal) continue;
                replacementLinks.add(matchingEarlierBrokenLink);
            }
            linksWithLocationInternally.addAll(replacementLinks);
        }
    }

    public Node getPlanitNodeByOsmNode(OsmNode osmNode) throws PlanItException {
        if (osmNode != null) {
            Node planitNode = this.getPlanitNodeByLocation(OsmNodeUtils.createPoint(osmNode));
            if (planitNode != null && osmNode.getId() != Long.valueOf(planitNode.getExternalId()).longValue()) {
                LOGGER.warning(String.format("OsmNodes %d and %s, reside on same location, likely tagging error", osmNode.getId(), planitNode.getExternalId()));
            }
            return planitNode;
        }
        return null;
    }

    public Node getPlanitNodeByLocation(Point location) throws PlanItException {
        Pair<Node, OsmNode> result;
        if (location != null && (result = this.planitNodesByLocation.get(location)) != null) {
            return result.first();
        }
        return null;
    }

    public OsmNode getOsmNodeByLocation(Point location) {
        if (location != null) {
            Pair<Node, OsmNode> result = this.planitNodesByLocation.get(location);
            if (result != null) {
                return result.second();
            }
            return this.getOsmNodeInternalToLinkByLocation(location);
        }
        return null;
    }

    public Map<Point, Pair<Node, OsmNode>> getCreatedPlanitNodesByLocation() {
        return Collections.unmodifiableMap(this.planitNodesByLocation);
    }

    public void registerPlanitNodeByOsmNode(OsmNode osmNode, Node planitNode) throws PlanItException {
        Point osmNodeLocation = OsmNodeUtils.createPoint(osmNode);
        this.planitNodesByLocation.put(osmNodeLocation, Pair.of(planitNode, osmNode));
    }

    public void registerPlanitNodeByLocation(Point location, Node planitNode) throws PlanItException {
        this.planitNodesByLocation.put(location, Pair.of(planitNode, null));
    }

    public void registerOsmNodeAsInternalToPlanitLink(OsmNode osmNode, Link planitLink) throws PlanItException {
        Point location = OsmNodeUtils.createPoint(osmNode);
        this.originalLinkInternalAvailableLocations.putIfAbsent(location, Pair.of(new ArrayList(), osmNode));
        this.registerLocationAsInternalToPlanitLink(location, planitLink);
    }

    public void registerLocationAsInternalToPlanitLink(Point location, Link planitLink) {
        this.originalLinkInternalAvailableLocations.putIfAbsent(location, Pair.of(new ArrayList(), null));
        this.originalLinkInternalAvailableLocations.get(location).first().add(planitLink);
    }

    public void updateOsmWaysWithMultiplePlanitLinks(Map<Long, Set<Link>> newOsmWayToPlanitLinkMapping) {
        OsmNetworkHandlerHelper.addAllTo(newOsmWayToPlanitLinkMapping, this.osmWaysWithMultiplePlanitLinks);
    }

    public void updateOsmWaysWithMultiplePlanitLinks(Long osmWayId, Set<Link> newOsmWayToPlanitLinkMapping) {
        if (newOsmWayToPlanitLinkMapping.size() < 2) {
            LOGGER.warning(String.format("registering multiple planit links for osm way %d, but only one or less planit links provided", osmWayId));
        }
        if (this.osmWaysWithMultiplePlanitLinks.containsKey(osmWayId)) {
            this.osmWaysWithMultiplePlanitLinks.get(osmWayId).addAll(newOsmWayToPlanitLinkMapping);
        } else {
            this.osmWaysWithMultiplePlanitLinks.put(osmWayId, newOsmWayToPlanitLinkMapping);
        }
    }

    public long getNumberOfOsmWaysWithMultiplePlanitLinks() {
        return this.osmWaysWithMultiplePlanitLinks.size();
    }

    public boolean isLocationInternalToAnyLink(Point location) {
        return this.originalLinkInternalAvailableLocations.containsKey(location);
    }

    public boolean isOsmNodePresentInLayer(OsmNode osmNode) throws PlanItException {
        return this.isLocationPresentInLayer(OsmNodeUtils.createPoint(osmNode));
    }

    public boolean isLocationPresentInLayer(Point location) {
        return this.planitNodesByLocation.containsKey(location) || this.isLocationInternalToAnyLink(location);
    }

    public Set<Point> getRegisteredLocationsInternalToAnyPlanitLink() {
        return Collections.unmodifiableSet(this.originalLinkInternalAvailableLocations.keySet());
    }

    public Set<Point> getRegisteredLocationsInternalToAnyPlanitLink(int numberOfLinksNodeMustAtLeastBeInternalTo) {
        HashSet<Point> foundLocations = new HashSet<Point>();
        for (Map.Entry<Point, Pair<List<Link>, OsmNode>> entry : this.originalLinkInternalAvailableLocations.entrySet()) {
            if (entry.getValue().first().size() < numberOfLinksNodeMustAtLeastBeInternalTo) continue;
            foundLocations.add(entry.getKey());
        }
        return foundLocations;
    }

    public Set<OsmNode> getRegisteredOsmNodesInternalToAnyPlanitLink(int numberOfLinksNodeMustAtLeastBeInternalTo) {
        HashSet<OsmNode> foundOsmNodes = new HashSet<OsmNode>();
        for (Map.Entry<Point, Pair<List<Link>, OsmNode>> entry : this.originalLinkInternalAvailableLocations.entrySet()) {
            List<Link> planitLinks = entry.getValue().first();
            OsmNode osmNode = entry.getValue().second();
            if (planitLinks.size() < numberOfLinksNodeMustAtLeastBeInternalTo || osmNode == null) continue;
            foundOsmNodes.add(entry.getValue().second());
        }
        return foundOsmNodes;
    }

    public OsmNode getOsmNodeInternalToLinkByLocation(Point location) {
        Pair<List<Link>, OsmNode> result = this.originalLinkInternalAvailableLocations.get(location);
        if (result != null) {
            return result.second();
        }
        return null;
    }

    public List<Link> findPlanitLinksWithInternalLocation(Point location) {
        if (location == null) {
            return null;
        }
        Pair<List<Link>, OsmNode> result = this.originalLinkInternalAvailableLocations.get(location);
        if (result == null || result.first() == null) {
            LOGGER.fine(String.format("DISCARD: Osm pt stop_position %s not available on network layer within planit link or as extreme node", location.toString()));
            return null;
        }
        List<Link> linksWithLocationInternally = result.first();
        this.updateLinksForInternalLocation(location, this.osmWaysWithMultiplePlanitLinks, linksWithLocationInternally);
        return linksWithLocationInternally;
    }

    public void reset() {
        this.planitNodesByLocation.clear();
        this.originalLinkInternalAvailableLocations.clear();
        this.osmWaysWithMultiplePlanitLinks.clear();
    }

    public OsmNetworkHandlerProfiler getProfiler() {
        return this.profiler;
    }
}

