/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.zoning;

import de.topobyte.osm4j.core.access.OsmInputException;
import de.topobyte.osm4j.core.access.OsmReader;
import java.net.URL;
import java.util.logging.Logger;
import org.goplanit.converter.zoning.ZoningReader;
import org.goplanit.osm.converter.network.OsmNetworkToZoningReaderData;
import org.goplanit.osm.converter.zoning.OsmPublicTransportReaderSettings;
import org.goplanit.osm.converter.zoning.OsmZoningReaderData;
import org.goplanit.osm.converter.zoning.handler.OsmZoningHandlerBase;
import org.goplanit.osm.converter.zoning.handler.OsmZoningHandlerProfiler;
import org.goplanit.osm.converter.zoning.handler.OsmZoningPostProcessingHandler;
import org.goplanit.osm.converter.zoning.handler.OsmZoningPreProcessingHandler;
import org.goplanit.osm.converter.zoning.handler.OsmZoningProcessingHandler;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;
import org.goplanit.osm.util.Osm4JUtils;
import org.goplanit.osm.util.PlanitZoningUtils;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.zoning.Zoning;

public class OsmZoningReader
implements ZoningReader {
    private static final Logger LOGGER = Logger.getLogger(OsmZoningReader.class.getCanonicalName());
    private OsmZoningPreProcessingHandler osmPreProcessingHandler = null;
    private OsmZoningProcessingHandler osmHandler = null;
    private OsmZoningPostProcessingHandler osmPostProcessingHandler = null;
    private final OsmPublicTransportReaderSettings transferSettings;
    private OsmZoningReaderData zoningReaderData;
    private Zoning zoning;

    private void logInfo() {
        LOGGER.info(String.format("OSM (transfer) zoning input file: %s", this.getSettings().getInputSource()));
        if (this.getSettings().hasBoundingPolygon()) {
            LOGGER.info(String.format("Bounding polygon set to: %s", this.getSettings().getBoundingPolygon().toString()));
        }
    }

    private void validateZoningBoundingPolygon() {
        OsmNetworkToZoningReaderData network2ZoningReaderData = this.getSettings().getNetworkDataForZoningReader();
        boolean zoningBoundingPolygonWithinNetworkBoundingPolygon = true;
        if (this.getSettings().hasBoundingPolygon() && network2ZoningReaderData.getNetworkSettings().hasBoundingPolygon() && !this.getSettings().getBoundingPolygon().equalsTopo(network2ZoningReaderData.getNetworkSettings().getBoundingPolygon())) {
            zoningBoundingPolygonWithinNetworkBoundingPolygon = this.getSettings().getBoundingPolygon().within(network2ZoningReaderData.getNetworkSettings().getBoundingPolygon());
        } else if (!this.getSettings().hasBoundingPolygon() && network2ZoningReaderData.getNetworkSettings().hasBoundingPolygon()) {
            zoningBoundingPolygonWithinNetworkBoundingPolygon = false;
        }
        if (!zoningBoundingPolygonWithinNetworkBoundingPolygon) {
            LOGGER.warning("SALVAGE: Bounding polygon for network is more restrictive than public transport, truncating to network bounding polygon");
            this.getSettings().setBoundingPolygon(network2ZoningReaderData.getNetworkSettings().getBoundingPolygon());
        }
    }

    private void initialiseBeforeParsing() {
        if (this.zoning == null) {
            this.zoning = new Zoning(this.getSettings().getReferenceNetwork().getIdGroupingToken(), this.getSettings().getReferenceNetwork().getNetworkGroupingTokenId());
        }
        this.zoningReaderData = new OsmZoningReaderData(this.getSettings().getCountryName());
        this.zoningReaderData.getPlanitData().initialiseSpatiallyIndexedLinks(this.getSettings().getReferenceNetwork());
        this.validateZoningBoundingPolygon();
    }

    private void doPreprocessing(OsmZoningHandlerProfiler profiler) throws PlanItException {
        OsmReader osmReader = Osm4JUtils.createOsm4jReader(this.getSettings().getInputSource());
        if (osmReader == null) {
            LOGGER.severe("unable to create OSM reader for pre-processing zones, aborting");
        } else {
            this.osmPreProcessingHandler = new OsmZoningPreProcessingHandler(this.transferSettings, this.zoningReaderData, profiler);
            this.read(osmReader, this.osmPreProcessingHandler);
        }
    }

    private void doMainProcessing(OsmZoningHandlerProfiler profiler) throws PlanItException {
        OsmReader osmReader = Osm4JUtils.createOsm4jReader(this.getSettings().getInputSource());
        if (osmReader == null) {
            LOGGER.severe("unable to create OSM reader for zones, aborting");
        } else {
            this.osmHandler = new OsmZoningProcessingHandler(this.transferSettings, this.zoningReaderData, this.zoning, profiler);
            this.read(osmReader, this.osmHandler);
        }
    }

    private void doPostProcessing(OsmZoningHandlerProfiler profiler) throws PlanItException {
        OsmReader osmReader = Osm4JUtils.createOsm4jReader(this.getSettings().getInputSource());
        if (osmReader == null) {
            LOGGER.severe("unable to create OSM reader for post-processing zones, aborting");
        } else {
            this.osmPostProcessingHandler = new OsmZoningPostProcessingHandler(this.transferSettings, this.zoningReaderData, this.zoning, profiler);
            this.read(osmReader, this.osmPostProcessingHandler);
        }
    }

    protected void read(OsmReader osmReader, OsmZoningHandlerBase osmHandler) throws PlanItException {
        try {
            osmHandler.initialiseBeforeParsing();
            osmReader.setHandler(osmHandler);
            osmReader.read();
        }
        catch (OsmInputException e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("error during parsing of osm file", e);
        }
    }

    protected OsmZoningReader(OsmPublicTransportReaderSettings settings, Zoning zoningToPopulate) {
        this.transferSettings = settings;
        this.zoning = zoningToPopulate;
    }

    protected OsmZoningReader(URL inputSource, String countryName, Zoning zoningToPopulate) {
        this(inputSource, countryName, zoningToPopulate, null);
    }

    protected OsmZoningReader(URL inputSource, String countryName, Zoning zoningToPopulate, PlanitOsmNetwork referenceNetwork) {
        this(inputSource, countryName, zoningToPopulate, referenceNetwork, null);
    }

    protected OsmZoningReader(URL inputSource, String countryName, Zoning zoningToPopulate, PlanitOsmNetwork referenceNetwork, OsmNetworkToZoningReaderData network2ZoningData) {
        this.transferSettings = new OsmPublicTransportReaderSettings(inputSource, countryName, referenceNetwork, network2ZoningData);
        this.zoning = zoningToPopulate;
    }

    @Override
    public Zoning read() throws PlanItException {
        PlanItException.throwIf(StringUtils.isNullOrBlank(this.getSettings().getCountryName()), "Country not set for OSM zoning reader, unable to proceed", new Object[0]);
        PlanItException.throwIfNull(this.getSettings().getInputSource(), "Input source not set for OSM zoning reader, unable to proceed");
        PlanItException.throwIfNull(this.getSettings().getReferenceNetwork(), "Reference network not available when parsing OSM zoning, unable to proceed");
        PlanItException.throwIfNull(this.getSettings().getNetworkDataForZoningReader(), "Reference network data (newtork to zoning data) not available when parsing OSM zoning, unable to proceed until provided via zoning settings");
        this.initialiseBeforeParsing();
        OsmZoningHandlerProfiler handlerProfiler = new OsmZoningHandlerProfiler();
        this.logInfo();
        this.doPreprocessing(handlerProfiler);
        this.doMainProcessing(handlerProfiler);
        this.doPostProcessing(handlerProfiler);
        handlerProfiler.logProcessingStats(this.zoningReaderData, this.zoning);
        if (this.getSettings().isRemoveDanglingZones()) {
            PlanitZoningUtils.removeDanglingZones(this.zoning);
        }
        if (this.getSettings().isRemoveDanglingTransferZoneGroups()) {
            PlanitZoningUtils.removeDanglingTransferZoneGroups(this.zoning);
        }
        LOGGER.info(" OSM zoning parsing...DONE");
        return this.zoning;
    }

    @Override
    public void reset() {
        this.osmHandler.reset();
        this.osmPreProcessingHandler.reset();
        this.osmPostProcessingHandler.reset();
        this.zoningReaderData.reset();
        this.getSettings().reset();
    }

    @Override
    public OsmPublicTransportReaderSettings getSettings() {
        return this.transferSettings;
    }
}

