/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.zoning;

import java.net.URL;
import java.nio.file.Paths;
import org.goplanit.osm.converter.network.OsmNetworkToZoningReaderData;
import org.goplanit.osm.converter.zoning.OsmPublicTransportReaderSettings;
import org.goplanit.osm.converter.zoning.OsmZoningReader;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.zoning.Zoning;

public class OsmZoningReaderFactory {
    public static OsmZoningReader create(Zoning zoningToPopulate) throws PlanItException {
        PlanItException.throwIfNull(zoningToPopulate, "no zoning instance provided to OSM zoning reader factory method");
        return OsmZoningReaderFactory.create(new OsmPublicTransportReaderSettings(), zoningToPopulate);
    }

    public static OsmZoningReader create(OsmPublicTransportReaderSettings settings) throws PlanItException {
        PlanItException.throwIfNull(settings, "no settings instance provided to OSM zoning reader factory method");
        PlanItException.throwIfNull(settings.getReferenceNetwork(), "Unable to initialise OSM zoning reader, network not available to base zoning instance from");
        return OsmZoningReaderFactory.create(settings, new Zoning(settings.getReferenceNetwork().getIdGroupingToken(), settings.getReferenceNetwork().getNetworkGroupingTokenId()));
    }

    public static OsmZoningReader create(OsmPublicTransportReaderSettings settings, Zoning zoningToPopulate) throws PlanItException {
        PlanItException.throwIfNull(settings, "no settings instance provided to OSM zoning reader factory method");
        PlanItException.throwIfNull(zoningToPopulate, "no zoning instance provided to OSM zoning reader factory method");
        return new OsmZoningReader(settings, zoningToPopulate);
    }

    public static OsmZoningReader create(String inputFile, String countryName, PlanitOsmNetwork referenceNetwork) throws PlanItException {
        try {
            return OsmZoningReaderFactory.create(Paths.get(inputFile, new String[0]).toUri().toURL(), countryName, referenceNetwork);
        }
        catch (Exception e) {
            throw new PlanItException("Unable to convert input file %s to Url", (Throwable)e, inputFile);
        }
    }

    public static OsmZoningReader create(String inputFile, String countryName, PlanitOsmNetwork referenceNetwork, OsmNetworkToZoningReaderData network2ZoningData) throws PlanItException {
        try {
            return OsmZoningReaderFactory.create(Paths.get(inputFile, new String[0]).toUri().toURL(), countryName, referenceNetwork, network2ZoningData);
        }
        catch (Exception e) {
            throw new PlanItException("Unable to convert input file %s to Url", (Throwable)e, inputFile);
        }
    }

    public static OsmZoningReader create(String inputFile, String countryName, Zoning zoningToPopulate, PlanitOsmNetwork referenceNetwork, OsmNetworkToZoningReaderData network2ZoningData) throws PlanItException {
        try {
            return OsmZoningReaderFactory.create(Paths.get(inputFile, new String[0]).toUri().toURL(), countryName, zoningToPopulate, referenceNetwork, network2ZoningData);
        }
        catch (Exception e) {
            throw new PlanItException("Unable to convert input file %s to Url", (Throwable)e, inputFile);
        }
    }

    public static OsmZoningReader create(URL inputSource, String countryName, PlanitOsmNetwork referenceNetwork) throws PlanItException {
        PlanItException.throwIfNull(referenceNetwork, "no reference network provided to OSM zoning reader factory method");
        return new OsmZoningReader(inputSource, countryName, new Zoning(referenceNetwork.getIdGroupingToken(), referenceNetwork.getNetworkGroupingTokenId()), referenceNetwork);
    }

    public static OsmZoningReader create(URL inputSource, String countryName, PlanitOsmNetwork referenceNetwork, OsmNetworkToZoningReaderData network2ZoningData) throws PlanItException {
        PlanItException.throwIfNull(referenceNetwork, "no reference network provided to OSM zoning reader factory method");
        return OsmZoningReaderFactory.create(inputSource, countryName, new Zoning(referenceNetwork.getIdGroupingToken(), referenceNetwork.getNetworkGroupingTokenId()), referenceNetwork, network2ZoningData);
    }

    public static OsmZoningReader create(URL inputSource, String countryName, Zoning zoningToPopulate, PlanitOsmNetwork referenceNetwork, OsmNetworkToZoningReaderData network2ZoningData) throws PlanItException {
        PlanItException.throwIfNull(zoningToPopulate, "no zoning instance provided to OSM zoning reader factory method");
        PlanItException.throwIfNull(referenceNetwork, "no reference network provided to OSM zoning reader factory method");
        return new OsmZoningReader(inputSource, countryName, zoningToPopulate, referenceNetwork, network2ZoningData);
    }
}

