/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.zoning;

import de.topobyte.osm4j.core.model.iface.EntityType;
import de.topobyte.osm4j.core.model.iface.OsmEntity;
import de.topobyte.osm4j.core.model.iface.OsmNode;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.goplanit.osm.util.Osm4JUtils;
import org.goplanit.osm.util.OsmPtVersionScheme;
import org.goplanit.utils.misc.Pair;

public class OsmZoningReaderOsmData {
    private static final Logger LOGGER = Logger.getLogger(OsmZoningReaderOsmData.class.getCanonicalName());
    private final Map<EntityType, Map<Long, OsmEntity>> unprocessedPtv1Stations = new TreeMap<EntityType, Map<Long, OsmEntity>>();
    private final Map<EntityType, Map<Long, OsmEntity>> unprocessedPtv2Stations = new TreeMap<EntityType, Map<Long, OsmEntity>>();
    private final Set<Long> unprocessedStopPositions = new TreeSet<Long>();
    private final Map<Long, OsmWay> osmOuterRoleOsmWaysToKeep = new TreeMap<Long, OsmWay>();
    private final Map<EntityType, Set<Long>> invalidStopAreaStopPositions = new TreeMap<EntityType, Set<Long>>();
    private final Map<EntityType, Set<Long>> waitingAreaWithoutMappedPlanitMode = new TreeMap<EntityType, Set<Long>>();

    public Pair<OsmPtVersionScheme, OsmEntity> getUnprocessedStation(EntityType entityType, long osmId) {
        OsmPtVersionScheme version = OsmPtVersionScheme.NONE;
        OsmEntity osmEntity = this.getUnprocessedPtv1Stations(entityType).get(osmId);
        if (osmEntity == null) {
            osmEntity = this.getUnprocessedPtv2Stations(entityType).get(osmId);
            version = OsmPtVersionScheme.VERSION_2;
        } else {
            version = OsmPtVersionScheme.VERSION_1;
        }
        return osmEntity == null ? null : Pair.of(version, osmEntity);
    }

    public Map<Long, OsmEntity> getUnprocessedPtv1Stations(EntityType entityType) {
        this.unprocessedPtv1Stations.putIfAbsent(entityType, new TreeMap());
        return Collections.unmodifiableMap(this.unprocessedPtv1Stations.get((Object)entityType));
    }

    public void addUnprocessedPtv1Station(OsmEntity osmEntity) {
        EntityType type = null;
        if (osmEntity instanceof OsmNode) {
            type = EntityType.Node;
        } else if (osmEntity instanceof OsmWay) {
            type = EntityType.Way;
        } else {
            LOGGER.severe(String.format("unknown entity type when adding unprocessed Ptv1 station wit osm id %d, ignored", new Object[0]));
        }
        this.unprocessedPtv1Stations.putIfAbsent(type, new TreeMap());
        this.unprocessedPtv1Stations.get((Object)type).put(osmEntity.getId(), osmEntity);
    }

    public void addUnprocessedPtv2Station(OsmEntity osmEntity) {
        EntityType type = null;
        if (osmEntity instanceof OsmNode) {
            type = EntityType.Node;
        } else if (osmEntity instanceof OsmWay) {
            type = EntityType.Way;
        } else {
            LOGGER.severe(String.format("unknown entity type when adding unprocessed Ptv2 station wit osm id %d, ignored", new Object[0]));
        }
        this.unprocessedPtv2Stations.putIfAbsent(type, new TreeMap());
        this.unprocessedPtv2Stations.get((Object)type).put(osmEntity.getId(), osmEntity);
    }

    public Map<Long, OsmEntity> getUnprocessedPtv2Stations(EntityType entityType) {
        this.unprocessedPtv2Stations.putIfAbsent(entityType, new TreeMap());
        return Collections.unmodifiableMap(this.unprocessedPtv2Stations.get((Object)entityType));
    }

    public Set<Long> getUnprocessedStopPositions() {
        return Collections.unmodifiableSet(this.unprocessedStopPositions);
    }

    public void removeUnprocessedStopPosition(long osmId) {
        this.unprocessedStopPositions.remove(osmId);
    }

    public void addUnprocessedStopPosition(long osmId) {
        this.unprocessedStopPositions.add(osmId);
    }

    public boolean hasUnprocessedStopPosition(long osmId) {
        return this.unprocessedStopPositions.contains(osmId);
    }

    public void removeUnproccessedStation(OsmPtVersionScheme ptVersion, OsmEntity osmEntity) {
        EntityType type = Osm4JUtils.getEntityType(osmEntity);
        switch (ptVersion) {
            case VERSION_1: {
                this.unprocessedPtv1Stations.get((Object)type).remove(osmEntity.getId());
                break;
            }
            case VERSION_2: {
                this.unprocessedPtv2Stations.get((Object)type).remove(osmEntity.getId());
                break;
            }
            default: {
                LOGGER.warning(String.format("could not remove station %d from earlier identified unprocessed stations, this should not happen", osmEntity.getId()));
            }
        }
    }

    public void removeAllUnproccessedStations(OsmPtVersionScheme ptVersion) {
        switch (ptVersion) {
            case VERSION_1: {
                this.unprocessedPtv1Stations.clear();
                break;
            }
            case VERSION_2: {
                this.unprocessedPtv2Stations.clear();
                break;
            }
            default: {
                LOGGER.warning(String.format("could not remove stations, invalid pt version provided", new Object[0]));
            }
        }
    }

    public void removeAllUnproccessedStations(OsmPtVersionScheme ptVersion, EntityType type) {
        switch (ptVersion) {
            case VERSION_1: {
                this.getUnprocessedPtv1Stations(type).clear();
                break;
            }
            case VERSION_2: {
                this.getUnprocessedPtv2Stations(type).clear();
                break;
            }
            default: {
                LOGGER.warning(String.format("could not remove stations, invalid pt version provided", new Object[0]));
            }
        }
    }

    public void markOsmRelationOuterRoleOsmWayToKeep(long osmWayId) {
        this.osmOuterRoleOsmWaysToKeep.put(osmWayId, null);
    }

    public void removeOsmRelationOuterRoleOsmWay(long osmWayId) {
        this.osmOuterRoleOsmWaysToKeep.remove(osmWayId);
    }

    public boolean shouldOsmRelationOuterRoleOsmWayBeKept(OsmWay osmWay) {
        return this.osmOuterRoleOsmWaysToKeep.containsKey(osmWay.getId());
    }

    public OsmWay addOsmRelationOuterRoleOsmWay(OsmWay osmWay) {
        return this.osmOuterRoleOsmWaysToKeep.put(osmWay.getId(), osmWay);
    }

    public boolean hasOuterRoleOsmWay(long osmWayId) {
        return this.osmOuterRoleOsmWaysToKeep.containsKey(osmWayId);
    }

    public OsmWay getOuterRoleOsmWay(long osmWayId) {
        return this.osmOuterRoleOsmWaysToKeep.get(osmWayId);
    }

    public boolean hasOsmRelationOuterRoleOsmWays() {
        return !this.osmOuterRoleOsmWaysToKeep.isEmpty();
    }

    public long getNumberOfOuterRoleOsmWays() {
        return this.osmOuterRoleOsmWaysToKeep.size();
    }

    public void addInvalidStopAreaStopPosition(EntityType type, long osmId) {
        this.invalidStopAreaStopPositions.putIfAbsent(type, new TreeSet());
        this.invalidStopAreaStopPositions.get((Object)type).add(osmId);
    }

    public boolean isInvalidStopAreaStopPosition(EntityType type, long osmId) {
        if (type != null) {
            this.invalidStopAreaStopPositions.putIfAbsent(type, new TreeSet());
            return this.invalidStopAreaStopPositions.get((Object)type).contains(osmId);
        }
        return false;
    }

    public void addWaitingAreaWithoutMappedPlanitMode(EntityType type, long osmId) {
        this.waitingAreaWithoutMappedPlanitMode.putIfAbsent(type, new TreeSet());
        this.waitingAreaWithoutMappedPlanitMode.get((Object)type).add(osmId);
    }

    public boolean isWaitingAreaWithoutMappedPlanitMode(EntityType type, long osmId) {
        if (type != null) {
            this.waitingAreaWithoutMappedPlanitMode.putIfAbsent(type, new TreeSet());
            return this.waitingAreaWithoutMappedPlanitMode.get((Object)type).contains(osmId);
        }
        return false;
    }

    public void reset() {
        this.removeAllUnproccessedStations(OsmPtVersionScheme.VERSION_1);
        this.removeAllUnproccessedStations(OsmPtVersionScheme.VERSION_2);
        this.unprocessedStopPositions.clear();
        this.osmOuterRoleOsmWaysToKeep.clear();
        this.waitingAreaWithoutMappedPlanitMode.clear();
    }
}

