/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.zoning.handler;

import de.topobyte.osm4j.core.access.DefaultOsmHandler;
import de.topobyte.osm4j.core.model.iface.EntityType;
import de.topobyte.osm4j.core.model.iface.OsmNode;
import de.topobyte.osm4j.core.model.iface.OsmRelationMember;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.osm.converter.network.OsmNetworkToZoningReaderData;
import org.goplanit.osm.converter.zoning.OsmPublicTransportReaderSettings;
import org.goplanit.osm.converter.zoning.OsmZoningReaderData;
import org.goplanit.osm.converter.zoning.handler.OsmZoningHandlerProfiler;
import org.goplanit.osm.converter.zoning.handler.helper.ConnectoidHelper;
import org.goplanit.osm.converter.zoning.handler.helper.OsmPublicTransportModeHelper;
import org.goplanit.osm.converter.zoning.handler.helper.TransferZoneGroupHelper;
import org.goplanit.osm.converter.zoning.handler.helper.TransferZoneHelper;
import org.goplanit.osm.util.OsmBoundingAreaUtils;
import org.goplanit.osm.util.OsmPtVersionScheme;
import org.goplanit.osm.util.OsmPtVersionSchemeUtils;
import org.goplanit.osm.util.PlanitNetworkLayerUtils;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.zoning.Zoning;
import org.locationtech.jts.geom.Geometry;

public abstract class OsmZoningHandlerBase
extends DefaultOsmHandler {
    private static final Logger LOGGER = Logger.getLogger(OsmZoningHandlerBase.class.getCanonicalName());
    private final Zoning zoning;
    private final OsmPublicTransportReaderSettings transferSettings;
    private final OsmZoningReaderData zoningReaderData;
    private final OsmZoningHandlerProfiler profiler;
    private final PlanitJtsCrsUtils geoUtils;
    private final TransferZoneHelper transferZoneHelper;
    private final TransferZoneGroupHelper transferZoneGroupHelper;
    private final OsmPublicTransportModeHelper publicTransportModeHelper;
    private final ConnectoidHelper connectoidHelper;

    private boolean skipOsmPtEntity(EntityType entityType, long osmId) {
        return entityType.equals((Object)EntityType.Node) && this.getSettings().isExcludedOsmNode(osmId) || entityType.equals((Object)EntityType.Way) && this.getSettings().isExcludedOsmWay(osmId);
    }

    protected boolean skipOsmPtEntity(OsmRelationMember member) {
        return this.skipOsmPtEntity(member.getType(), member.getId());
    }

    protected boolean skipOsmNode(OsmNode osmNode) {
        return this.skipOsmPtEntity(EntityType.Node, osmNode.getId());
    }

    protected boolean skipOsmWay(OsmWay osmWay) {
        return this.skipOsmPtEntity(EntityType.Way, osmWay.getId());
    }

    protected boolean isCoveredByZoningBoundingPolygon(OsmNode osmNode) {
        if (!this.getSettings().hasBoundingPolygon()) {
            return true;
        }
        return OsmBoundingAreaUtils.isCoveredByZoningBoundingPolygon(osmNode, this.getSettings().getBoundingPolygon());
    }

    protected boolean isCoveredByZoningBoundingPolygon(OsmWay osmWay) {
        if (!this.getSettings().hasBoundingPolygon()) {
            return true;
        }
        return OsmBoundingAreaUtils.isCoveredByZoningBoundingPolygon(osmWay, this.getSettings().getNetworkDataForZoningReader().getOsmNodes(), this.getSettings().getBoundingPolygon());
    }

    protected boolean hasNetworkLayersWithActiveOsmNode(long osmNodeId) throws PlanItException {
        return PlanitNetworkLayerUtils.hasNetworkLayersWithActiveOsmNode(osmNodeId, this.getSettings().getReferenceNetwork(), this.getNetworkToZoningData());
    }

    protected OsmPtVersionScheme isActivatedPublicTransportInfrastructure(Map<String, String> tags) {
        if (this.transferSettings.isParserActive()) {
            return OsmPtVersionSchemeUtils.isPublicTransportBasedInfrastructure(tags);
        }
        return OsmPtVersionScheme.NONE;
    }

    protected void logWarningIfNotNearBoundingBox(String message, Geometry geometry) throws PlanItException {
        OsmBoundingAreaUtils.logWarningIfNotNearBoundingBox(message, geometry, this.getNetworkToZoningData().getNetworkBoundingBox(), this.geoUtils);
    }

    protected final PlanitJtsCrsUtils getGeoUtils() {
        return this.geoUtils;
    }

    protected final OsmZoningHandlerProfiler getProfiler() {
        return this.profiler;
    }

    protected final OsmZoningReaderData getZoningReaderData() {
        return this.zoningReaderData;
    }

    protected final Zoning getZoning() {
        return this.zoning;
    }

    protected final OsmNetworkToZoningReaderData getNetworkToZoningData() {
        return this.getSettings().getNetworkDataForZoningReader();
    }

    protected OsmPublicTransportReaderSettings getSettings() {
        return this.transferSettings;
    }

    protected TransferZoneHelper getTransferZoneHelper() {
        return this.transferZoneHelper;
    }

    protected TransferZoneGroupHelper getTransferZoneGroupHelper() {
        return this.transferZoneGroupHelper;
    }

    protected OsmPublicTransportModeHelper getPtModeHelper() {
        return this.publicTransportModeHelper;
    }

    protected ConnectoidHelper getConnectoidHelper() {
        return this.connectoidHelper;
    }

    public OsmZoningHandlerBase(OsmPublicTransportReaderSettings transferSettings, OsmZoningReaderData zoningReaderData, Zoning zoningToPopulate, OsmZoningHandlerProfiler profiler) {
        this.profiler = profiler;
        this.zoning = zoningToPopulate;
        this.transferSettings = transferSettings;
        this.zoningReaderData = zoningReaderData;
        this.geoUtils = new PlanitJtsCrsUtils(this.getSettings().getReferenceNetwork().getCoordinateReferenceSystem());
        this.transferZoneHelper = new TransferZoneHelper(zoningToPopulate, zoningReaderData, transferSettings, profiler);
        this.transferZoneGroupHelper = new TransferZoneGroupHelper(zoningToPopulate, zoningReaderData, transferSettings, profiler);
        this.publicTransportModeHelper = new OsmPublicTransportModeHelper(transferSettings.getNetworkDataForZoningReader().getNetworkSettings());
        this.connectoidHelper = new ConnectoidHelper(zoningToPopulate, zoningReaderData, transferSettings, profiler);
    }

    public abstract void initialiseBeforeParsing() throws PlanItException;

    public abstract void reset();
}

