/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.zoning.handler.helper;

import de.topobyte.osm4j.core.model.iface.EntityType;
import de.topobyte.osm4j.core.model.iface.OsmNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.goplanit.osm.converter.network.OsmNetworkHandlerHelper;
import org.goplanit.osm.converter.network.OsmNetworkReaderLayerData;
import org.goplanit.osm.converter.zoning.OsmPublicTransportReaderSettings;
import org.goplanit.osm.converter.zoning.OsmZoningReaderData;
import org.goplanit.osm.converter.zoning.handler.OsmZoningHandlerProfiler;
import org.goplanit.osm.converter.zoning.handler.helper.ZoningHelperBase;
import org.goplanit.osm.util.OsmBoundingAreaUtils;
import org.goplanit.osm.util.OsmNodeUtils;
import org.goplanit.osm.util.PlanitLinkSegmentUtils;
import org.goplanit.osm.util.PlanitLinkUtils;
import org.goplanit.osm.util.PlanitTransferZoneUtils;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.locale.DrivingDirectionDefaultByCountry;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.TrackModeType;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.goplanit.zoning.Zoning;
import org.goplanit.zoning.modifier.event.handler.UpdateDirectedConnectoidsOnBreakLinkSegmentHandler;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.linearref.LinearLocation;

public class ConnectoidHelper
extends ZoningHelperBase {
    private static final Logger LOGGER = Logger.getLogger(ConnectoidHelper.class.getCanonicalName());
    private final Zoning zoning;
    private final OsmZoningReaderData zoningReaderData;
    private final OsmZoningHandlerProfiler profiler;
    private final PlanitJtsCrsUtils geoUtils;

    private static Collection<DirectedConnectoid> findDirectedConnectoidsRefencingLink(Link link, Map<Point, List<DirectedConnectoid>> knownConnectoidsByLocation) {
        HashSet<DirectedConnectoid> referencingConnectoids = new HashSet<DirectedConnectoid>();
        HashSet<Point> eligibleLocations = new HashSet<Point>();
        if (link.hasEdgeSegmentAb()) {
            eligibleLocations.add(link.getEdgeSegmentAb().getDownstreamVertex().getPosition());
        }
        if (link.hasEdgeSegmentBa()) {
            eligibleLocations.add(link.getEdgeSegmentBa().getDownstreamVertex().getPosition());
        }
        for (Point location : eligibleLocations) {
            Collection knownConnectoidsForLink = knownConnectoidsByLocation.get(location);
            if (knownConnectoidsForLink == null || knownConnectoidsForLink.isEmpty()) continue;
            for (DirectedConnectoid connectoid : knownConnectoidsForLink) {
                if (!connectoid.getAccessLinkSegment().idEquals(link.getEdgeSegmentAb()) && !connectoid.getAccessLinkSegment().idEquals(link.getEdgeSegmentBa())) continue;
                referencingConnectoids.add(connectoid);
            }
        }
        return referencingConnectoids;
    }

    private static Map<Point, DirectedConnectoid> collectConnectoidAccessNodeLocations(Collection<Link> links, Map<Point, List<DirectedConnectoid>> connectoidsByLocation) {
        HashMap<Point, DirectedConnectoid> connectoidsDownstreamVerticesBeforeBreakLink = new HashMap<Point, DirectedConnectoid>();
        for (Link link : links) {
            Collection<DirectedConnectoid> connectoids = ConnectoidHelper.findDirectedConnectoidsRefencingLink(link, connectoidsByLocation);
            if (connectoids == null || connectoids.isEmpty()) continue;
            connectoids.forEach(connectoid -> connectoidsDownstreamVerticesBeforeBreakLink.put(connectoid.getAccessNode().getPosition(), (DirectedConnectoid)connectoid));
        }
        return connectoidsDownstreamVerticesBeforeBreakLink;
    }

    private static boolean isWaitingAreaForPtModeRestrictedToDrivingDirectionLocation(Mode accessMode, TransferZone transferZone, Long osmStopLocationNodeId, OsmPublicTransportReaderSettings settings) {
        boolean mustAvoidCrossingTraffic = true;
        if (accessMode.getPhysicalFeatures().getTrackType().equals((Object)TrackModeType.RAIL)) {
            mustAvoidCrossingTraffic = false;
        } else if (osmStopLocationNodeId != null && settings.isOverwriteStopLocationWaitingArea(osmStopLocationNodeId)) {
            mustAvoidCrossingTraffic = Long.valueOf(transferZone.getExternalId()).equals(settings.getOverwrittenStopLocationWaitingArea(osmStopLocationNodeId).second());
        }
        return mustAvoidCrossingTraffic;
    }

    private void logWarningIfNotNearBoundingBox(String message, Geometry geometry) throws PlanItException {
        OsmBoundingAreaUtils.logWarningIfNotNearBoundingBox(message, geometry, this.getNetworkToZoningData().getNetworkBoundingBox(), this.geoUtils);
    }

    private boolean hasStandAloneTransferZoneValidAccessLinkSegmentForLinkNodeModeCombination(TransferZone transferZone, Link accessLink, Node node, Mode accessMode) throws PlanItException {
        Long osmStopLocationId = node.getExternalId() != null ? Long.valueOf(node.getExternalId()) : null;
        boolean mustAvoidCrossingTraffic = ConnectoidHelper.isWaitingAreaForPtModeRestrictedToDrivingDirectionLocation(accessMode, transferZone, osmStopLocationId, this.getSettings());
        Collection<EdgeSegment> accessLinkSegments = this.findAccessLinkSegmentsForStandAloneTransferZone(transferZone, accessLink, node, accessMode, mustAvoidCrossingTraffic, this.geoUtils);
        return !accessLinkSegments.isEmpty();
    }

    private boolean hasStandAloneTransferZoneValidAccessLinkSegmentForLinkInternalLocationModeCombination(TransferZone transferZone, Link accessLink, Point connectoidLocation, Mode accessMode) throws PlanItException {
        MacroscopicNetworkLayer networkLayer = (MacroscopicNetworkLayer)this.getSettings().getReferenceNetwork().getLayerByMode(accessMode);
        OsmNode osmNode = this.getNetworkToZoningData().getNetworkLayerData(networkLayer).getOsmNodeByLocation(connectoidLocation);
        Long osmStopLocationId = osmNode != null ? Long.valueOf(osmNode.getId()) : null;
        boolean mustAvoidCrossingTraffic = ConnectoidHelper.isWaitingAreaForPtModeRestrictedToDrivingDirectionLocation(accessMode, transferZone, osmStopLocationId, this.getSettings());
        MacroscopicLinkSegment oneWayLinkSegment = PlanitLinkSegmentUtils.getLinkSegmentIfLinkIsOneWayForMode(accessLink, accessMode);
        if (mustAvoidCrossingTraffic && oneWayLinkSegment != null) {
            boolean isLeftHandDrive;
            boolean reverseLinearLocationGeometry;
            Coordinate[] linkCoordinates = accessLink.getGeometry().getCoordinates();
            int coordinateIndex = PlanitJtsUtils.getCoordinateIndexOf(connectoidLocation.getCoordinate(), linkCoordinates);
            if (coordinateIndex <= 0) {
                throw new PlanItException("Unable to locate link internal location %s for osm way even though it is expected to exist for osm entity %s", accessLink.getExternalId(), transferZone.getExternalId());
            }
            LineSegment lineSegment = new LineSegment(linkCoordinates[coordinateIndex - 1], linkCoordinates[coordinateIndex]);
            boolean bl = reverseLinearLocationGeometry = oneWayLinkSegment.isDirectionAb() != oneWayLinkSegment.getParentEdge().isGeometryInAbDirection();
            if (reverseLinearLocationGeometry) {
                lineSegment.reverse();
            }
            return (isLeftHandDrive = DrivingDirectionDefaultByCountry.isLeftHandDrive(this.zoningReaderData.getCountryName())) == PlanitTransferZoneUtils.isTransferZoneLeftOf(transferZone, lineSegment.p0, lineSegment.p1, this.geoUtils);
        }
        return true;
    }

    private Collection<EdgeSegment> findAccessLinkSegmentsForStandAloneTransferZone(TransferZone transferZone, Link accessLink, Node node, Mode accessMode, boolean mustAvoidCrossingTraffic, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Long osmWaitingAreaId = Long.valueOf(transferZone.getExternalId());
        Long osmNodeIdOfLinkExtremeNode = node.getExternalId() != null ? Long.valueOf(node.getExternalId()) : null;
        EntityType osmWaitingAreaEntityType = PlanitTransferZoneUtils.extractOsmEntityType(transferZone);
        ArrayList<EdgeSegment> accessLinkSegments = new ArrayList<EdgeSegment>(4);
        for (EdgeSegment linkSegment : node.getEntryEdgeSegments()) {
            if (!((MacroscopicLinkSegment)linkSegment).isModeAllowed(accessMode) || !linkSegment.getParentEdge().idEquals(accessLink)) continue;
            accessLinkSegments.add(linkSegment);
        }
        if (accessLinkSegments == null || accessLinkSegments.isEmpty()) {
            return accessLinkSegments;
        }
        boolean removeInvalidAccessLinkSegmentsIfNoMatchLeft = true;
        if (node.getExternalId() != null && this.getSettings().isOverwriteStopLocationWaitingArea(osmNodeIdOfLinkExtremeNode)) {
            Pair<EntityType, Long> result = this.getSettings().getOverwrittenStopLocationWaitingArea(osmNodeIdOfLinkExtremeNode);
            removeInvalidAccessLinkSegmentsIfNoMatchLeft = osmWaitingAreaId == result.second();
        } else if (this.getSettings().hasWaitingAreaNominatedOsmWayForStopLocation(osmWaitingAreaId, osmWaitingAreaEntityType)) {
            long osmWayId = this.getSettings().getWaitingAreaNominatedOsmWayForStopLocation(osmWaitingAreaId, osmWaitingAreaEntityType);
            boolean bl = removeInvalidAccessLinkSegmentsIfNoMatchLeft = !Long.valueOf(accessLink.getExternalId()).equals(osmWayId);
        }
        if (mustAvoidCrossingTraffic) {
            boolean isLeftHandDrive = DrivingDirectionDefaultByCountry.isLeftHandDrive(this.zoningReaderData.getCountryName());
            Collection<EdgeSegment> toBeRemoveAccessLinkSegments = PlanitTransferZoneUtils.identifyInvalidTransferZoneAccessLinkSegmentsBasedOnRelativeLocationToInfrastructure(accessLinkSegments, transferZone, accessMode, isLeftHandDrive, geoUtils);
            if (removeInvalidAccessLinkSegmentsIfNoMatchLeft || toBeRemoveAccessLinkSegments.size() < accessLinkSegments.size()) {
                accessLinkSegments.removeAll(toBeRemoveAccessLinkSegments);
            }
        }
        return accessLinkSegments;
    }

    private void updateDirectedConnectoid(DirectedConnectoid connectoidToUpdate, TransferZone accessZone, Set<Mode> allowedModes) {
        Set<Mode> realAllowedModes = ((MacroscopicLinkSegment)connectoidToUpdate.getAccessLinkSegment()).getAllowedModesFrom(allowedModes);
        if (realAllowedModes != null && !realAllowedModes.isEmpty()) {
            if (!connectoidToUpdate.hasAccessZone(accessZone)) {
                connectoidToUpdate.addAccessZone(accessZone);
            }
            connectoidToUpdate.addAllowedModes(accessZone, realAllowedModes);
        }
    }

    private void breakLinksAtPlanitNode(Node planitNode, MacroscopicNetworkLayer networkLayer, List<Link> linksToBreak) throws PlanItException {
        OsmNetworkReaderLayerData layerData = this.getNetworkToZoningData().getNetworkLayerData(networkLayer);
        Map<Point, DirectedConnectoid> connectoidsAccessNodeLocationBeforeBreakLink = ConnectoidHelper.collectConnectoidAccessNodeLocations(linksToBreak, this.zoningReaderData.getPlanitData().getDirectedConnectoidsByLocation(networkLayer));
        UpdateDirectedConnectoidsOnBreakLinkSegmentHandler listener = new UpdateDirectedConnectoidsOnBreakLinkSegmentHandler(connectoidsAccessNodeLocationBeforeBreakLink);
        networkLayer.getLayerModifier().addListener(listener);
        this.zoningReaderData.getPlanitData().removeLinksFromSpatialLinkIndex(linksToBreak);
        Map<Long, Set<Link>> newlyBrokenLinks = OsmNetworkHandlerHelper.breakLinksWithInternalNode(planitNode, linksToBreak, networkLayer, this.getSettings().getReferenceNetwork().getCoordinateReferenceSystem());
        newlyBrokenLinks.forEach((id, links) -> this.zoningReaderData.getPlanitData().addLinksToSpatialLinkIndex((Collection<Link>)links));
        layerData.updateOsmWaysWithMultiplePlanitLinks(newlyBrokenLinks);
        networkLayer.getLayerModifier().removeListener(listener);
    }

    private DirectedConnectoid createAndRegisterDirectedConnectoid(TransferZone accessZone, MacroscopicLinkSegment linkSegment, Set<Mode> allowedModes) throws PlanItException {
        Set<Mode> realAllowedModes = linkSegment.getAllowedModesFrom(allowedModes);
        if (realAllowedModes != null && !realAllowedModes.isEmpty()) {
            DirectedConnectoid connectoid = this.zoning.transferConnectoids.getFactory().registerNew(linkSegment, accessZone);
            connectoid.setXmlId(String.valueOf(connectoid.getId()));
            connectoid.addAllowedModes(accessZone, realAllowedModes);
            return connectoid;
        }
        return null;
    }

    private Collection<DirectedConnectoid> createAndRegisterDirectedConnectoids(TransferZone transferZone, MacroscopicNetworkLayer networkLayer, Collection<? extends EdgeSegment> linkSegments, Set<Mode> allowedModes) throws PlanItException {
        HashSet<DirectedConnectoid> createdConnectoids = new HashSet<DirectedConnectoid>();
        for (EdgeSegment edgeSegment : linkSegments) {
            DirectedConnectoid newConnectoid = this.createAndRegisterDirectedConnectoid(transferZone, (MacroscopicLinkSegment)edgeSegment, allowedModes);
            if (newConnectoid == null) continue;
            createdConnectoids.add(newConnectoid);
            this.zoningReaderData.getPlanitData().addDirectedConnectoidByLocation(networkLayer, newConnectoid.getAccessLinkSegment().getDownstreamVertex().getPosition(), newConnectoid);
            this.zoningReaderData.getPlanitData().addConnectoidByTransferZone(transferZone, newConnectoid);
        }
        return createdConnectoids;
    }

    private boolean extractDirectedConnectoidsForMode(TransferZone transferZone, Mode planitMode, Collection<EdgeSegment> eligibleLinkSegments, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        MacroscopicNetworkLayer networkLayer = (MacroscopicNetworkLayer)this.getSettings().getReferenceNetwork().getLayerByMode(planitMode);
        for (EdgeSegment edgeSegment : eligibleLinkSegments) {
            Collection<DirectedConnectoid> newConnectoids;
            Point proposedConnectoidLocation = edgeSegment.getDownstreamVertex().getPosition();
            boolean createConnectoidsForLinkSegment = true;
            if (this.zoningReaderData.getPlanitData().hasDirectedConnectoidForLocation(networkLayer, proposedConnectoidLocation)) {
                List<DirectedConnectoid> connectoidsForNode = this.zoningReaderData.getPlanitData().getDirectedConnectoidsByLocation(proposedConnectoidLocation, networkLayer);
                for (DirectedConnectoid connectoid : connectoidsForNode) {
                    if (!edgeSegment.idEquals(connectoid.getAccessLinkSegment())) continue;
                    this.updateDirectedConnectoid(connectoid, transferZone, Collections.singleton(planitMode));
                    createConnectoidsForLinkSegment = false;
                    break;
                }
            }
            if (!createConnectoidsForLinkSegment || (newConnectoids = this.createAndRegisterDirectedConnectoids(transferZone, networkLayer, Collections.singleton(edgeSegment), Collections.singleton(planitMode))) != null && !newConnectoids.isEmpty()) continue;
            LOGGER.warning(String.format("Found eligible mode %s for stop_location of transferzone %s, but no access link segment supports this mode", planitMode.getExternalId(), transferZone.getExternalId()));
            return false;
        }
        return true;
    }

    private boolean extractDirectedConnectoidsForMode(Point location, TransferZone transferZone, Mode planitMode, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        return this.extractDirectedConnectoidsForMode(location, transferZone, planitMode, null, geoUtils);
    }

    private Node extractConnectoidAccessNodeByLocation(Point osmNodeLocation, MacroscopicNetworkLayer networkLayer) throws PlanItException {
        List<Link> linksToBreak;
        OsmNetworkReaderLayerData layerData = this.getNetworkToZoningData().getNetworkLayerData(networkLayer);
        Node planitNode = layerData.getPlanitNodeByLocation(osmNodeLocation);
        if (planitNode == null && (linksToBreak = layerData.findPlanitLinksWithInternalLocation(osmNodeLocation)) != null) {
            OsmNode osmNode = layerData.getOsmNodeByLocation(osmNodeLocation);
            planitNode = osmNode != null ? OsmNetworkHandlerHelper.createPopulateAndRegisterNode(osmNode, networkLayer, layerData) : OsmNetworkHandlerHelper.createPopulateAndRegisterNode(osmNodeLocation, networkLayer, layerData);
            this.profiler.logConnectoidStatus(this.zoning.transferConnectoids.size());
            this.breakLinksAtPlanitNode(planitNode, networkLayer, linksToBreak);
        }
        return planitNode;
    }

    private Node extractConnectoidAccessNodeByOsmNode(OsmNode osmNode, MacroscopicNetworkLayer networkLayer) throws PlanItException {
        Point osmNodeLocation = OsmNodeUtils.createPoint(osmNode);
        return this.extractConnectoidAccessNodeByLocation(osmNodeLocation, networkLayer);
    }

    private Point extractConnectoidLocationForstandAloneTransferZoneOnLink(TransferZone transferZone, Link accessLink, Mode accessMode, double maxAllowedStopToTransferZoneDistanceMeters, MacroscopicNetworkLayer networkLayer) throws PlanItException {
        Coordinate closestExistingCoordinate;
        Point connectoidLocation = this.findConnectoidLocationForstandAloneTransferZoneOnLink(transferZone, accessLink, accessMode, maxAllowedStopToTransferZoneDistanceMeters, networkLayer);
        if (connectoidLocation != null && !(closestExistingCoordinate = this.geoUtils.getClosestExistingLineStringCoordinateToGeometry(transferZone.getGeometry(), accessLink.getGeometry())).equals2D(connectoidLocation.getCoordinate())) {
            LinearLocation projectedLinearLocationOnLink = PlanitTransferZoneUtils.extractClosestProjectedLinearLocationOnEdgeForTransferZone(transferZone, accessLink, this.geoUtils);
            Pair<LineString, LineString> splitLineString = PlanitJtsUtils.splitLineString(accessLink.getGeometry(), projectedLinearLocationOnLink);
            LineString linkGeometryWithExplicitProjectedCoordinate = PlanitJtsUtils.mergeLineStrings(splitLineString.first(), splitLineString.second());
            accessLink.setGeometry(linkGeometryWithExplicitProjectedCoordinate);
            this.getNetworkToZoningData().getNetworkLayerData(networkLayer).registerLocationAsInternalToPlanitLink(connectoidLocation, accessLink);
        }
        return connectoidLocation;
    }

    public ConnectoidHelper(Zoning zoning, OsmZoningReaderData zoningReaderData, OsmPublicTransportReaderSettings transferSettings, OsmZoningHandlerProfiler profiler) {
        super(transferSettings);
        this.zoning = zoning;
        this.zoningReaderData = zoningReaderData;
        this.profiler = profiler;
        this.geoUtils = new PlanitJtsCrsUtils(transferSettings.getReferenceNetwork().getCoordinateReferenceSystem());
    }

    public Point findConnectoidLocationForstandAloneTransferZoneOnLink(TransferZone transferZone, Link accessLink, Mode accessMode, double maxAllowedStopToTransferZoneDistanceMeters, MacroscopicNetworkLayer networkLayer) throws PlanItException {
        LinearLocation projectedLinearLocationOnLink;
        Coordinate closestProjectedCoordinate;
        Coordinate closestExistingCoordinate = this.geoUtils.getClosestExistingLineStringCoordinateToGeometry(transferZone.getGeometry(), accessLink.getGeometry());
        double distanceToExistingCoordinateOnLinkInMeters = this.geoUtils.getClosestDistanceInMeters(PlanitJtsUtils.createPoint(closestExistingCoordinate), transferZone.getGeometry());
        Point connectoidLocation = null;
        if (distanceToExistingCoordinateOnLinkInMeters < maxAllowedStopToTransferZoneDistanceMeters) {
            if (accessLink.getVertexA().isPositionEqual2D(closestExistingCoordinate)) {
                if (this.hasStandAloneTransferZoneValidAccessLinkSegmentForLinkNodeModeCombination(transferZone, accessLink, (Node)accessLink.getNodeA(), accessMode)) {
                    connectoidLocation = PlanitJtsUtils.createPoint(closestExistingCoordinate);
                }
            } else if (accessLink.getVertexB().isPositionEqual2D(closestExistingCoordinate)) {
                if (this.hasStandAloneTransferZoneValidAccessLinkSegmentForLinkNodeModeCombination(transferZone, accessLink, (Node)accessLink.getNodeB(), accessMode)) {
                    connectoidLocation = PlanitJtsUtils.createPoint(closestExistingCoordinate);
                }
            } else {
                int coordinateIndex = PlanitJtsUtils.getCoordinateIndexOf(closestExistingCoordinate, accessLink.getGeometry().getCoordinates());
                if (coordinateIndex <= 0 || coordinateIndex == accessLink.getGeometry().getCoordinates().length - 1) {
                    throw new PlanItException("Unable to locate link internal osm node even though it is expected to exist when creating stop locations for osm entity %s", transferZone.getExternalId());
                }
                connectoidLocation = PlanitJtsUtils.createPoint(closestExistingCoordinate);
                if (!this.hasStandAloneTransferZoneValidAccessLinkSegmentForLinkInternalLocationModeCombination(transferZone, accessLink, connectoidLocation, accessMode)) {
                    connectoidLocation = null;
                }
            }
        }
        if (connectoidLocation == null && !closestExistingCoordinate.equals2D(closestProjectedCoordinate = (projectedLinearLocationOnLink = PlanitTransferZoneUtils.extractClosestProjectedLinearLocationOnEdgeForTransferZone(transferZone, accessLink, this.geoUtils)).getCoordinate(accessLink.getGeometry())) && !(this.geoUtils.getClosestDistanceInMeters(PlanitJtsUtils.createPoint(closestProjectedCoordinate), transferZone.getGeometry()) > maxAllowedStopToTransferZoneDistanceMeters)) {
            connectoidLocation = PlanitJtsUtils.createPoint(closestProjectedCoordinate);
        }
        return connectoidLocation;
    }

    public Collection<DirectedConnectoid> createAndRegisterDirectedConnectoidsOnTopOfTransferZone(TransferZone transferZone, MacroscopicNetworkLayer networkLayer, Mode planitMode, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        OsmNode osmNode = this.getNetworkToZoningData().getOsmNodes().get(Long.valueOf(transferZone.getExternalId()));
        Collection<Object> nominatedLinkSegments = null;
        if (this.getSettings().hasWaitingAreaNominatedOsmWayForStopLocation(osmNode.getId(), EntityType.Node)) {
            long osmWayId = this.getSettings().getWaitingAreaNominatedOsmWayForStopLocation(osmNode.getId(), EntityType.Node);
            Link nominatedLink = PlanitLinkUtils.getClosestLinkWithOsmWayIdToGeometry(osmWayId, OsmNodeUtils.createPoint(osmNode), networkLayer, geoUtils);
            if (nominatedLink != null) {
                nominatedLinkSegments = nominatedLink.getEdgeSegments();
            } else {
                LOGGER.severe(String.format("User nominated osm way not available for waiting area on road infrastructure %d", osmWayId));
            }
        } else {
            Node planitNode = this.extractConnectoidAccessNodeByOsmNode(osmNode, networkLayer);
            if (planitNode == null) {
                LOGGER.warning(String.format("DISCARD: osm node (%d) could not be converted to access node for transfer zone osm entity %s at same location", osmNode.getId(), transferZone.getExternalId()));
                return null;
            }
            nominatedLinkSegments = planitNode.getEntryLinkSegments();
        }
        return this.createAndRegisterDirectedConnectoids(transferZone, networkLayer, nominatedLinkSegments, Collections.singleton(planitMode));
    }

    public boolean extractDirectedConnectoidsForMode(Point location, TransferZone transferZone, Mode planitMode, Collection<Link> eligibleAccessLinks, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        boolean mustAvoidCrossingTraffic;
        if (location == null || transferZone == null || planitMode == null || geoUtils == null) {
            return false;
        }
        MacroscopicNetworkLayer networkLayer = (MacroscopicNetworkLayer)this.getSettings().getReferenceNetwork().getLayerByMode(planitMode);
        OsmNode osmNode = this.getNetworkToZoningData().getNetworkLayerData(networkLayer).getOsmNodeByLocation(location);
        Node planitNode = this.extractConnectoidAccessNodeByLocation(location, networkLayer);
        if (planitNode == null) {
            if (osmNode != null) {
                LOGGER.warning(String.format("DISCARD: osm node %d could not be converted to access node for transfer zone representation of osm entity %s", osmNode.getId(), transferZone.getXmlId(), transferZone.getExternalId()));
            } else {
                LOGGER.warning(String.format("DISCARD: location (%s) could not be converted to access node for transfer zone representation of osm entity %s", location.toString(), transferZone.getXmlId(), transferZone.getExternalId()));
            }
            return false;
        }
        boolean bl = mustAvoidCrossingTraffic = !planitNode.getPosition().equalsTopo(transferZone.getGeometry());
        if (mustAvoidCrossingTraffic) {
            mustAvoidCrossingTraffic = ConnectoidHelper.isWaitingAreaForPtModeRestrictedToDrivingDirectionLocation(planitMode, transferZone, osmNode != null ? Long.valueOf(osmNode.getId()) : null, this.getSettings());
        }
        Collection<EdgeSegment> accessLinkSegments = null;
        for (Link link : planitNode.getLinks()) {
            Collection<EdgeSegment> linkAccessLinkSegments = this.findAccessLinkSegmentsForStandAloneTransferZone(transferZone, link, planitNode, planitMode, mustAvoidCrossingTraffic, geoUtils);
            if (linkAccessLinkSegments == null || linkAccessLinkSegments.isEmpty()) continue;
            if (accessLinkSegments == null) {
                accessLinkSegments = linkAccessLinkSegments;
                continue;
            }
            accessLinkSegments.addAll(linkAccessLinkSegments);
        }
        if (accessLinkSegments == null || accessLinkSegments.isEmpty()) {
            LOGGER.info(String.format("DICARD platform/pole/station %s its stop_location %s deemed invalid, no access link segment found due to incompatible modes or transfer zone on wrong side of road/rail", transferZone.getExternalId(), planitNode.getExternalId() != null ? planitNode.getExternalId() : ""));
            return false;
        }
        return this.extractDirectedConnectoidsForMode(transferZone, planitMode, accessLinkSegments, geoUtils);
    }

    public boolean extractDirectedConnectoidsForMode(OsmNode osmNode, TransferZone transferZone, Mode planitMode, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Point osmNodeLocation = OsmNodeUtils.createPoint(osmNode);
        return this.extractDirectedConnectoidsForMode(osmNodeLocation, transferZone, planitMode, geoUtils);
    }

    public boolean extractDirectedConnectoids(OsmNode osmNode, Map<String, String> tags, Collection<TransferZone> transferZones, Collection<Mode> planitModes, TransferZoneGroup transferZoneGroup) throws PlanItException {
        boolean success = false;
        for (Mode planitMode : planitModes) {
            MacroscopicNetworkLayer networkLayer = (MacroscopicNetworkLayer)this.getSettings().getReferenceNetwork().getLayerByMode(planitMode);
            if (!this.getNetworkToZoningData().getNetworkLayerData(networkLayer).isOsmNodePresentInLayer(osmNode)) {
                this.logWarningIfNotNearBoundingBox(String.format("DISCARD: stop_position %d is not present in parsed network layer supporting mode %s, likely it is dangling in original osm file", osmNode.getId(), planitMode.getExternalId()), OsmNodeUtils.createPoint(osmNode));
                continue;
            }
            for (TransferZone transferZone : transferZones) {
                success = this.extractDirectedConnectoidsForMode(osmNode, transferZone, planitMode, this.geoUtils) || success;
                if (!success || transferZoneGroup == null || transferZone.isInTransferZoneGroup(transferZoneGroup)) continue;
                LOGGER.info(String.format("Platform/pole %s identified for stop_position %d, platform/pole not in stop_area %s of stop_position, added it", transferZone.getExternalId(), osmNode.getId(), transferZoneGroup.getExternalId()));
                transferZoneGroup.addTransferZone(transferZone);
            }
        }
        return success;
    }

    public void extractDirectedConnectoidsForStandAloneTransferZoneByPlanitLink(long osmWaitingAreaId, Geometry waitingAreaGeometry, Link accessLink, TransferZone transferZone, Mode accessMode, double maxAllowedStopToTransferZoneDistanceMeters, MacroscopicNetworkLayer networkLayer) throws PlanItException {
        OsmNode osmStopLocationNode;
        Point connectoidLocation = this.extractConnectoidLocationForstandAloneTransferZoneOnLink(transferZone, accessLink, accessMode, maxAllowedStopToTransferZoneDistanceMeters, networkLayer);
        if (connectoidLocation == null) {
            this.logWarningIfNotNearBoundingBox(String.format("DISCARD: Unable to create stop_location on identified access link %s, identified location is likely too far from waiting area %s", accessLink.getExternalId(), transferZone.getExternalId()), transferZone.getGeometry());
        }
        if ((osmStopLocationNode = this.getNetworkToZoningData().getNetworkLayerData(networkLayer).getOsmNodeByLocation(connectoidLocation)) != null && this.getSettings().isOverwriteStopLocationWaitingArea(osmStopLocationNode.getId())) {
            Pair<EntityType, Long> overwriteResult = this.getSettings().getOverwrittenStopLocationWaitingArea(osmStopLocationNode.getId());
            if (!(waitingAreaGeometry instanceof Point) || Long.valueOf(transferZone.getExternalId()) != overwriteResult.second()) {
                return;
            }
            if (Long.valueOf(transferZone.getExternalId()) != overwriteResult.second()) {
                return;
            }
        }
        this.extractDirectedConnectoidsForMode(connectoidLocation, transferZone, accessMode, Collections.singleton(accessLink), this.geoUtils);
    }
}

