/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.defaults;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.goplanit.osm.defaults.OsmInfrastructureConfiguration;
import org.goplanit.utils.exceptions.PlanItException;

public class OsmRailwayTypeConfiguration
extends OsmInfrastructureConfiguration {
    private static final Logger LOGGER = Logger.getLogger(OsmRailwayTypeConfiguration.class.getCanonicalName());
    protected static final Set<String> DEFAULT_ACTIVATED_OSM_RAILWAY_TYPES = new HashSet<String>();
    protected static final Set<String> DEFAULT_DEACTIVATED_OSM_RAILWAY_TYPES = new HashSet<String>();

    protected static void initialiseDefaultActivatedOsmRailwayTypes() throws PlanItException {
        DEFAULT_ACTIVATED_OSM_RAILWAY_TYPES.add("light_rail");
        DEFAULT_ACTIVATED_OSM_RAILWAY_TYPES.add("rail");
        DEFAULT_ACTIVATED_OSM_RAILWAY_TYPES.add("subway");
        DEFAULT_ACTIVATED_OSM_RAILWAY_TYPES.add("tram");
    }

    protected static void initialiseDefaultDeactivatedOsmRailwayTypes() throws PlanItException {
        DEFAULT_DEACTIVATED_OSM_RAILWAY_TYPES.add("funicular");
        DEFAULT_DEACTIVATED_OSM_RAILWAY_TYPES.add("monorail");
        DEFAULT_DEACTIVATED_OSM_RAILWAY_TYPES.add("narrow_gauge");
        DEFAULT_DEACTIVATED_OSM_RAILWAY_TYPES.add("abandoned");
        DEFAULT_DEACTIVATED_OSM_RAILWAY_TYPES.add("construction");
        DEFAULT_DEACTIVATED_OSM_RAILWAY_TYPES.add("disused");
        DEFAULT_DEACTIVATED_OSM_RAILWAY_TYPES.add("miniature");
        DEFAULT_DEACTIVATED_OSM_RAILWAY_TYPES.add("razed");
        DEFAULT_DEACTIVATED_OSM_RAILWAY_TYPES.add("turntable");
        DEFAULT_DEACTIVATED_OSM_RAILWAY_TYPES.add("proposed");
    }

    public OsmRailwayTypeConfiguration() {
        super("railway", DEFAULT_ACTIVATED_OSM_RAILWAY_TYPES, DEFAULT_DEACTIVATED_OSM_RAILWAY_TYPES);
    }

    static {
        try {
            OsmRailwayTypeConfiguration.initialiseDefaultActivatedOsmRailwayTypes();
            OsmRailwayTypeConfiguration.initialiseDefaultDeactivatedOsmRailwayTypes();
        }
        catch (PlanItException e) {
            LOGGER.severe("unable to create default supported and/or unsupported OSM railway types for this network");
        }
    }
}

