/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.defaults;

import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.apache.commons.csv.CSVRecord;
import org.goplanit.osm.defaults.CountrySpecificDefaultUtils;
import org.goplanit.osm.defaults.OsmSpeedLimitDefaults;
import org.goplanit.osm.defaults.OsmSpeedLimitDefaultsCategory;
import org.goplanit.osm.tags.OsmHighwayTags;
import org.goplanit.osm.tags.OsmRailwayTags;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.locale.LocaleUtils;
import org.goplanit.utils.misc.Pair;

public class OsmSpeedLimitDefaultsByCountry {
    private static final Logger LOGGER = Logger.getLogger(OsmSpeedLimitDefaultsByCountry.class.getCanonicalName());
    private static final String SPEED_LIMIT_RESOURCE_DIR = "speed_limit";
    private static final String SPEED_LIMIT_HIGHWAY_RESOURCE_DIR = "speed_limit".concat("/highway");
    private static final String SPEED_LIMIT_RAILWAY_RESOURCE_DIR = "speed_limit".concat("/railway");
    protected static final OsmSpeedLimitDefaults GLOBAL_SPEED_LIMIT_DEFAULTS = new OsmSpeedLimitDefaults("global");
    protected static Map<String, OsmSpeedLimitDefaults> speedLimitDefaultsByCountryCode = new HashMap<String, OsmSpeedLimitDefaults>();

    protected static void populateGlobalSpeedLimits() throws PlanItException {
        OsmSpeedLimitDefaultsByCountry.populateGlobalDefaultHighwaySpeedLimits();
        OsmSpeedLimitDefaultsByCountry.populateGlobalDefaultRailwaySpeedLimits();
    }

    protected static void populateCountrySpecificSpeedLimits() throws PlanItException {
        CountrySpecificDefaultUtils.callForEachFileInResourceDir(SPEED_LIMIT_RAILWAY_RESOURCE_DIR, OsmSpeedLimitDefaultsByCountry::populateCountrySpecificRailwayDefaultSpeedLimits);
        CountrySpecificDefaultUtils.callForEachFileInResourceDir(SPEED_LIMIT_HIGHWAY_RESOURCE_DIR, OsmSpeedLimitDefaultsByCountry::populateCountrySpecificHighwayDefaultSpeedLimits);
    }

    protected static void populateCountrySpecificRailwayDefaultSpeedLimits(InputStreamReader inputReader, String fullCountryName) {
        try {
            boolean defaultsNotYetRegistered = false;
            OsmSpeedLimitDefaults countryDefaults = OsmSpeedLimitDefaultsByCountry.getDefaultsByCountryName(fullCountryName);
            if (countryDefaults == null) {
                countryDefaults = GLOBAL_SPEED_LIMIT_DEFAULTS.clone();
                countryDefaults.setCountry(fullCountryName);
                defaultsNotYetRegistered = true;
            }
            TreeMap<String, Double> updatedSpeedLimits = new TreeMap<String, Double>();
            Iterable<CSVRecord> records = CountrySpecificDefaultUtils.collectCsvRecordIterable(inputReader);
            for (CSVRecord record : records) {
                if (record.size() != 2) {
                    LOGGER.warning(String.format("DISCARD: Csv record row in railway speed limit defaults should have two columns, found %s", record.toString()));
                    continue;
                }
                String osmRailwayType = record.get(0).trim();
                if (!OsmRailwayTags.isRailBasedRailway(osmRailwayType)) {
                    LOGGER.warning(String.format("DISCARD: Csv record row in railway speed limit defaults should have first column reflect a valid railway value type, found %s", osmRailwayType));
                    continue;
                }
                try {
                    updatedSpeedLimits.put(osmRailwayType, Double.parseDouble(record.get(1).trim()));
                }
                catch (NumberFormatException e) {
                    LOGGER.warning(String.format("Invalid speed limit found for railway %s", osmRailwayType));
                }
            }
            if (!updatedSpeedLimits.isEmpty()) {
                OsmSpeedLimitDefaultsCategory countryRailwayDefaults = countryDefaults.getRailwayDefaults();
                updatedSpeedLimits.entrySet().stream().forEach(entry -> countryRailwayDefaults.setSpeedLimitDefault((String)entry.getKey(), (Double)entry.getValue()));
                if (defaultsNotYetRegistered) {
                    OsmSpeedLimitDefaultsByCountry.setDefaultsByCountry(countryDefaults);
                }
            }
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe(String.format("Parsing of csv input stream with railway speed limit defaults failed for %s", fullCountryName));
        }
    }

    protected static void populateCountrySpecificHighwayDefaultSpeedLimits(InputStreamReader inputReader, String fullCountryName) {
        try {
            boolean defaultsNotYetRegistered = false;
            OsmSpeedLimitDefaults countryDefaults = OsmSpeedLimitDefaultsByCountry.getDefaultsByCountryName(fullCountryName);
            if (countryDefaults == null) {
                countryDefaults = GLOBAL_SPEED_LIMIT_DEFAULTS.clone();
                countryDefaults.setCountry(fullCountryName);
                defaultsNotYetRegistered = true;
            }
            TreeMap<String, Pair<Double, Double>> updatedSpeedLimits = new TreeMap<String, Pair<Double, Double>>();
            Iterable<CSVRecord> records = CountrySpecificDefaultUtils.collectCsvRecordIterable(inputReader);
            for (CSVRecord record : records) {
                if (record.size() != 3) {
                    LOGGER.warning(String.format("DISCARD: Csv record row in highway speed limit defaults should have three columns, found %s", record.toString()));
                    continue;
                }
                String osmHighwayType = record.get(0).trim();
                if (!OsmHighwayTags.isRoadBasedHighwayValueTag(osmHighwayType)) {
                    LOGGER.warning(String.format("DISCARD: Csv record row in highway speed limit defaults should have first column reflect a valid highway value type, found %s", record.get(0)));
                    continue;
                }
                try {
                    updatedSpeedLimits.put(osmHighwayType, Pair.of(Double.parseDouble(record.get(1).trim()), Double.parseDouble(record.get(2).trim())));
                }
                catch (NumberFormatException e) {
                    LOGGER.warning(String.format("Invalid speed limit found for highway %s", osmHighwayType));
                }
            }
            if (!updatedSpeedLimits.isEmpty()) {
                OsmSpeedLimitDefaultsCategory countryHighwayUrbanDefaults = countryDefaults.getUrbanHighwayDefaults();
                OsmSpeedLimitDefaultsCategory countryHighwayNonUrbanDefaults = countryDefaults.getNonUrbanHighwayDefaults();
                updatedSpeedLimits.entrySet().stream().forEach(entry -> countryHighwayUrbanDefaults.setSpeedLimitDefault((String)entry.getKey(), (Double)((Pair)entry.getValue()).first()));
                updatedSpeedLimits.entrySet().stream().forEach(entry -> countryHighwayNonUrbanDefaults.setSpeedLimitDefault((String)entry.getKey(), (Double)((Pair)entry.getValue()).second()));
                if (defaultsNotYetRegistered) {
                    OsmSpeedLimitDefaultsByCountry.setDefaultsByCountry(countryDefaults);
                }
            }
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe(String.format("Parsing of csv input stream with highway speed limit defaults failed for %s", fullCountryName));
        }
    }

    protected static void setGlobalHighwaySpeedLimitDefaults(String type, double urbanSpeedLimit, double nonUrbanSpeedLimit) {
        GLOBAL_SPEED_LIMIT_DEFAULTS.getUrbanHighwayDefaults().setSpeedLimitDefault(type, urbanSpeedLimit);
        GLOBAL_SPEED_LIMIT_DEFAULTS.getNonUrbanHighwayDefaults().setSpeedLimitDefault(type, nonUrbanSpeedLimit);
    }

    protected static void setGlobalRailwaySpeedLimitDefaults(String type, double speedLimit) {
        GLOBAL_SPEED_LIMIT_DEFAULTS.getRailwayDefaults().setSpeedLimitDefault(type, speedLimit);
    }

    protected static void populateGlobalDefaultHighwaySpeedLimits() throws PlanItException {
        OsmSpeedLimitDefaultsByCountry.setGlobalHighwaySpeedLimitDefaults("motorway", 100.0, 120.0);
        OsmSpeedLimitDefaultsByCountry.setGlobalHighwaySpeedLimitDefaults("motorway_link", 100.0, 120.0);
        OsmSpeedLimitDefaultsByCountry.setGlobalHighwaySpeedLimitDefaults("trunk", 80.0, 100.0);
        OsmSpeedLimitDefaultsByCountry.setGlobalHighwaySpeedLimitDefaults("trunk_link", 80.0, 100.0);
        OsmSpeedLimitDefaultsByCountry.setGlobalHighwaySpeedLimitDefaults("primary", 60.0, 100.0);
        OsmSpeedLimitDefaultsByCountry.setGlobalHighwaySpeedLimitDefaults("primary_link", 60.0, 100.0);
        OsmSpeedLimitDefaultsByCountry.setGlobalHighwaySpeedLimitDefaults("secondary", 50.0, 80.0);
        OsmSpeedLimitDefaultsByCountry.setGlobalHighwaySpeedLimitDefaults("secondary_link", 50.0, 80.0);
        OsmSpeedLimitDefaultsByCountry.setGlobalHighwaySpeedLimitDefaults("tertiary", 50.0, 80.0);
        OsmSpeedLimitDefaultsByCountry.setGlobalHighwaySpeedLimitDefaults("tertiary_link", 50.0, 80.0);
        OsmSpeedLimitDefaultsByCountry.setGlobalHighwaySpeedLimitDefaults("unclassified", 50.0, 80.0);
        OsmSpeedLimitDefaultsByCountry.setGlobalHighwaySpeedLimitDefaults("residential", 40.0, 80.0);
        OsmSpeedLimitDefaultsByCountry.setGlobalHighwaySpeedLimitDefaults("living_street", 20.0, 20.0);
        OsmSpeedLimitDefaultsByCountry.setGlobalHighwaySpeedLimitDefaults("pedestrian", 20.0, 20.0);
        OsmSpeedLimitDefaultsByCountry.setGlobalHighwaySpeedLimitDefaults("track", 20.0, 40.0);
        OsmSpeedLimitDefaultsByCountry.setGlobalHighwaySpeedLimitDefaults("road", 20.0, 40.0);
        OsmSpeedLimitDefaultsByCountry.setGlobalHighwaySpeedLimitDefaults("service", 20.0, 40.0);
        OsmSpeedLimitDefaultsByCountry.setGlobalHighwaySpeedLimitDefaults("footway", 20.0, 20.0);
        OsmSpeedLimitDefaultsByCountry.setGlobalHighwaySpeedLimitDefaults("path", 20.0, 20.0);
        OsmSpeedLimitDefaultsByCountry.setGlobalHighwaySpeedLimitDefaults("cycleway", 20.0, 20.0);
        OsmSpeedLimitDefaultsByCountry.setGlobalHighwaySpeedLimitDefaults("steps", 10.0, 10.0);
        OsmSpeedLimitDefaultsByCountry.setGlobalHighwaySpeedLimitDefaults("bridleway", 20.0, 20.0);
    }

    protected static void populateDefaultRailwaySpeedLimits(OsmSpeedLimitDefaultsCategory speedLimitsToPopulate) {
        speedLimitsToPopulate.setSpeedLimitDefault("funicular", 70.0);
        speedLimitsToPopulate.setSpeedLimitDefault("light_rail", 70.0);
        speedLimitsToPopulate.setSpeedLimitDefault("monorail", 70.0);
        speedLimitsToPopulate.setSpeedLimitDefault("narrow_gauge", 70.0);
        speedLimitsToPopulate.setSpeedLimitDefault("rail", 70.0);
        speedLimitsToPopulate.setSpeedLimitDefault("subway", 70.0);
        speedLimitsToPopulate.setSpeedLimitDefault("tram", 70.0);
    }

    protected static void populateGlobalDefaultRailwaySpeedLimits() throws PlanItException {
        OsmSpeedLimitDefaultsByCountry.populateDefaultRailwaySpeedLimits(GLOBAL_SPEED_LIMIT_DEFAULTS.getRailwayDefaults());
    }

    protected static void populateAustralianSpeedLimits() throws PlanItException {
        OsmSpeedLimitDefaults australianSpeedLimits = new OsmSpeedLimitDefaults("Australia", GLOBAL_SPEED_LIMIT_DEFAULTS);
        australianSpeedLimits.getUrbanHighwayDefaults().setSpeedLimitDefault("motorway", 100.0);
        australianSpeedLimits.getUrbanHighwayDefaults().setSpeedLimitDefault("motorway_link", 80.0);
        australianSpeedLimits.getUrbanHighwayDefaults().setSpeedLimitDefault("trunk", 60.0);
        australianSpeedLimits.getUrbanHighwayDefaults().setSpeedLimitDefault("trunk_link", 60.0);
        australianSpeedLimits.getUrbanHighwayDefaults().setSpeedLimitDefault("primary", 60.0);
        australianSpeedLimits.getUrbanHighwayDefaults().setSpeedLimitDefault("primary_link", 60.0);
        australianSpeedLimits.getUrbanHighwayDefaults().setSpeedLimitDefault("secondary", 60.0);
        australianSpeedLimits.getUrbanHighwayDefaults().setSpeedLimitDefault("secondary_link", 60.0);
        australianSpeedLimits.getUrbanHighwayDefaults().setSpeedLimitDefault("tertiary", 50.0);
        australianSpeedLimits.getUrbanHighwayDefaults().setSpeedLimitDefault("tertiary_link", 50.0);
        australianSpeedLimits.getUrbanHighwayDefaults().setSpeedLimitDefault("unclassified", 50.0);
        australianSpeedLimits.getUrbanHighwayDefaults().setSpeedLimitDefault("residential", 50.0);
        australianSpeedLimits.getUrbanHighwayDefaults().setSpeedLimitDefault("living_street", 20.0);
        australianSpeedLimits.getNonUrbanHighwayDefaults().setSpeedLimitDefault("motorway", 100.0);
        australianSpeedLimits.getNonUrbanHighwayDefaults().setSpeedLimitDefault("motorway_link", 80.0);
        australianSpeedLimits.getNonUrbanHighwayDefaults().setSpeedLimitDefault("trunk", 100.0);
        australianSpeedLimits.getNonUrbanHighwayDefaults().setSpeedLimitDefault("trunk_link", 60.0);
        australianSpeedLimits.getNonUrbanHighwayDefaults().setSpeedLimitDefault("primary", 80.0);
        australianSpeedLimits.getNonUrbanHighwayDefaults().setSpeedLimitDefault("primary_link", 60.0);
        australianSpeedLimits.getNonUrbanHighwayDefaults().setSpeedLimitDefault("secondary", 80.0);
        australianSpeedLimits.getNonUrbanHighwayDefaults().setSpeedLimitDefault("secondary_link", 60.0);
        australianSpeedLimits.getNonUrbanHighwayDefaults().setSpeedLimitDefault("tertiary", 80.0);
        australianSpeedLimits.getNonUrbanHighwayDefaults().setSpeedLimitDefault("tertiary_link", 60.0);
        australianSpeedLimits.getNonUrbanHighwayDefaults().setSpeedLimitDefault("unclassified", 80.0);
        australianSpeedLimits.getNonUrbanHighwayDefaults().setSpeedLimitDefault("residential", 80.0);
        australianSpeedLimits.getNonUrbanHighwayDefaults().setSpeedLimitDefault("living_street", 20.0);
        OsmSpeedLimitDefaultsByCountry.populateDefaultRailwaySpeedLimits(australianSpeedLimits.getRailwayDefaults());
        OsmSpeedLimitDefaultsByCountry.setDefaultsByCountry(australianSpeedLimits);
    }

    protected static double getSpeedLimitByHighwayType(OsmSpeedLimitDefaults countryDefaults, boolean outside, String type) throws PlanItException {
        Double speedLimit;
        Double d = speedLimit = outside ? countryDefaults.getNonUrbanHighwayDefaults().getSpeedLimit(type) : countryDefaults.getUrbanHighwayDefaults().getSpeedLimit(type);
        if (speedLimit == null) {
            Double d2 = speedLimit = outside ? GLOBAL_SPEED_LIMIT_DEFAULTS.getNonUrbanHighwayDefaults().getSpeedLimit(type) : GLOBAL_SPEED_LIMIT_DEFAULTS.getUrbanHighwayDefaults().getSpeedLimit(type);
        }
        if (speedLimit == null) {
            throw new PlanItException(String.format("unable to find speed limit for highway=%s (urban area=%s)", type, Boolean.toString(outside)));
        }
        return speedLimit;
    }

    protected static void setDefaultsByCountry(OsmSpeedLimitDefaults countrySpeedLimits) throws PlanItException {
        String iso2Australia = LocaleUtils.getIso2CountryCodeByName(countrySpeedLimits.getCountry());
        PlanItException.throwIfNull(iso2Australia, "country name could not be converted into ISO2 code");
        speedLimitDefaultsByCountryCode.put(iso2Australia, countrySpeedLimits.clone());
    }

    protected static OsmSpeedLimitDefaults getDefaultsByCountryName(String countryName) {
        return OsmSpeedLimitDefaultsByCountry.getDefaultsByCountryISO2(LocaleUtils.getIso2CountryCodeByName(countryName));
    }

    protected static OsmSpeedLimitDefaults getDefaultsByCountryISO2(String countryISO2) {
        return speedLimitDefaultsByCountryCode.get(countryISO2);
    }

    public static OsmSpeedLimitDefaults create() {
        OsmSpeedLimitDefaults createdDefaults = null;
        createdDefaults = GLOBAL_SPEED_LIMIT_DEFAULTS.clone();
        return createdDefaults;
    }

    public static OsmSpeedLimitDefaults create(String countryName) {
        OsmSpeedLimitDefaults createdDefaults = null;
        if (countryName != null && !countryName.isBlank() && !countryName.equals("global")) {
            createdDefaults = OsmSpeedLimitDefaultsByCountry.getDefaultsByCountryName(countryName);
        }
        if (createdDefaults == null) {
            createdDefaults = OsmSpeedLimitDefaultsByCountry.create();
            LOGGER.warning(String.format("No OSM speed limit defaults available for %s, reverting to global defaults", countryName));
        } else {
            createdDefaults = createdDefaults.clone();
        }
        return createdDefaults;
    }

    public static OsmSpeedLimitDefaultsCategory getGlobalUrbanHighwayDefaults() {
        return GLOBAL_SPEED_LIMIT_DEFAULTS.getUrbanHighwayDefaults();
    }

    public static OsmSpeedLimitDefaultsCategory getGlobalNonUrbanHighwayDefaults() {
        return GLOBAL_SPEED_LIMIT_DEFAULTS.getNonUrbanHighwayDefaults();
    }

    public static OsmSpeedLimitDefaultsCategory getGlobalRailwayDefaults() {
        return GLOBAL_SPEED_LIMIT_DEFAULTS.getRailwayDefaults();
    }

    static {
        try {
            OsmSpeedLimitDefaultsByCountry.populateGlobalSpeedLimits();
            OsmSpeedLimitDefaultsByCountry.populateCountrySpecificSpeedLimits();
        }
        catch (PlanItException e) {
            LOGGER.severe("unable to initialise global and/or country specific OSM speed limit defaults");
        }
    }
}

