/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.tags;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OsmPtv2Tags {
    private static final Set<String> PTV2_VALUE_TAGS = new HashSet<String>();
    public static final String PUBLIC_TRANSPORT = "public_transport";
    public static final String PLATFORM = "platform";
    public static final String STATION = "station";
    public static final String CONSTRUCTION = "construction";
    public static final String STOP_AREA = "stop_area";
    public static final String STOP_POSITION = "stop_position";
    public static final String STOP_ROLE = "stop";
    public static final String PLATFORM_ROLE = "platform";

    private static void populateOsmPublicTransportValueTags() {
        PTV2_VALUE_TAGS.add("platform");
        PTV2_VALUE_TAGS.add(STATION);
        PTV2_VALUE_TAGS.add(STOP_AREA);
        PTV2_VALUE_TAGS.add(STOP_POSITION);
        PTV2_VALUE_TAGS.add(CONSTRUCTION);
    }

    public static final Set<String> getPtv2ValueTags() {
        return PTV2_VALUE_TAGS;
    }

    public static boolean hasPtv2ValueTag(Map<String, String> tags) {
        if (OsmPtv2Tags.hasPublicTransportKeyTag(tags)) {
            return PTV2_VALUE_TAGS.contains(tags.get(PUBLIC_TRANSPORT));
        }
        return false;
    }

    public static boolean hasPublicTransportKeyTag(Map<String, String> tags) {
        return tags.containsKey(PUBLIC_TRANSPORT);
    }

    static {
        OsmPtv2Tags.populateOsmPublicTransportValueTags();
    }
}

