/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.tags;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.goplanit.osm.tags.OsmPtv1Tags;

public class OsmRailwayTags {
    private static final Set<String> RAILBASED_OSM_RAILWAY_VALUE_TAGS = new HashSet<String>();
    private static final Set<String> AREABASED_OSM_RAILWAY_VALUE_TAGS = new HashSet<String>();
    protected static final Set<String> NON_RAILBASED_OSM_RAILWAY_VALUE_TAGS = new HashSet<String>();
    public static final String RAILWAY = "railway";
    public static final String ABANDONED = "abandoned";
    public static final String CONSTRUCTION = "construction";
    public static final String PROPOSED = "proposed";
    public static final String DISUSED = "disused";
    public static final String FUNICULAR = "funicular";
    public static final String LIGHT_RAIL = "light_rail";
    public static final String MONO_RAIL = "monorail";
    public static final String NARROW_GAUGE = "narrow_gauge";
    public static final String PRESERVED = "preserved";
    public static final String RAIL = "rail";
    public static final String SUBWAY = "subway";
    public static final String TRAM = "tram";
    public static final String MINIATURE = "miniature";
    public static final String TURNTABLE = "turntable";
    public static final String RAZED = "razed";
    public static final String FUEL = "fuel";
    public static final String TRAVERSER = "traverser";
    public static final String WASH = "wash";
    public static final String ROUNDHOUSE = "roundahouse";
    public static final String YARD = "yard";
    public static final String SIGNAL_BOX = "signal_box";
    public static final String WORKSHOP = "workshop";

    private static void populateRailBasedOsmRailwayValueTags() {
        RAILBASED_OSM_RAILWAY_VALUE_TAGS.add(FUNICULAR);
        RAILBASED_OSM_RAILWAY_VALUE_TAGS.add(LIGHT_RAIL);
        RAILBASED_OSM_RAILWAY_VALUE_TAGS.add(MONO_RAIL);
        RAILBASED_OSM_RAILWAY_VALUE_TAGS.add(NARROW_GAUGE);
        RAILBASED_OSM_RAILWAY_VALUE_TAGS.add(MINIATURE);
        RAILBASED_OSM_RAILWAY_VALUE_TAGS.add(RAZED);
        RAILBASED_OSM_RAILWAY_VALUE_TAGS.add(TURNTABLE);
        RAILBASED_OSM_RAILWAY_VALUE_TAGS.add(RAIL);
        RAILBASED_OSM_RAILWAY_VALUE_TAGS.add(SUBWAY);
        RAILBASED_OSM_RAILWAY_VALUE_TAGS.add(TRAM);
    }

    private static void populateAreaBasedOsmRailwayValueTags() {
        AREABASED_OSM_RAILWAY_VALUE_TAGS.add(FUEL);
        AREABASED_OSM_RAILWAY_VALUE_TAGS.add(TRAVERSER);
        AREABASED_OSM_RAILWAY_VALUE_TAGS.add(WASH);
        AREABASED_OSM_RAILWAY_VALUE_TAGS.add(ROUNDHOUSE);
        AREABASED_OSM_RAILWAY_VALUE_TAGS.add(YARD);
        AREABASED_OSM_RAILWAY_VALUE_TAGS.add(SIGNAL_BOX);
        AREABASED_OSM_RAILWAY_VALUE_TAGS.add(WORKSHOP);
        AREABASED_OSM_RAILWAY_VALUE_TAGS.addAll(OsmPtv1Tags.getAreaBasedRailwayValueTags());
    }

    private static void populateNonRailBasedOsmRailwayValueTags() {
        NON_RAILBASED_OSM_RAILWAY_VALUE_TAGS.addAll(AREABASED_OSM_RAILWAY_VALUE_TAGS);
        NON_RAILBASED_OSM_RAILWAY_VALUE_TAGS.addAll(OsmPtv1Tags.getRailwayValueTags());
    }

    public static boolean isRailBasedRailway(String railwayTagValue) {
        return RAILBASED_OSM_RAILWAY_VALUE_TAGS.contains(railwayTagValue);
    }

    public static boolean isAreaBasedRailway(String railwayTagValue) {
        return AREABASED_OSM_RAILWAY_VALUE_TAGS.contains(railwayTagValue);
    }

    public static boolean isNonRailBasedRailway(String railwayTagValue) {
        return NON_RAILBASED_OSM_RAILWAY_VALUE_TAGS.contains(railwayTagValue);
    }

    public static boolean isRailwayKeyTag(String railwayTag) {
        return RAILWAY.equals(railwayTag);
    }

    public static boolean hasRailwayKeyTag(Map<String, String> tags) {
        return tags.containsKey(RAILWAY);
    }

    static {
        OsmRailwayTags.populateRailBasedOsmRailwayValueTags();
        OsmRailwayTags.populateAreaBasedOsmRailwayValueTags();
        OsmRailwayTags.populateNonRailBasedOsmRailwayValueTags();
    }
}

