/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.tags;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class OsmRoadModeTags {
    private static final Set<String> MODE_TAGS = new HashSet<String>();
    private static final Set<String> PT_MODE_TAGS = new HashSet<String>();
    public static final String FOOT = "foot";
    public static final String DOG = "dog";
    public static final String HORSE = "horse";
    public static final String BICYCLE = "bicycle";
    public static final String CARRIAGE = "carriage";
    public static final String TRAILER = "trailer";
    public static final String CARAVAN = "caravan";
    public static final String MOTOR_CYCLE = "motorcycle";
    public static final String MOPED = "moped";
    public static final String MOFA = "mofa";
    public static final String MOTOR_CAR = "motorcar";
    public static final String MOTOR_HOME = "motorhome";
    public static final String TOURIST_BUS = "tourist_bus";
    public static final String COACH = "coach";
    public static final String AGRICULTURAL = "agricultural";
    public static final String GOLF_CART = "golf_cart";
    public static final String ATV = "atv";
    public static final String GOODS = "goods";
    public static final String HEAVY_GOODS = "hgv";
    public static final String HEAVY_GOODS_ARTICULATED = "hgv_articulated";
    public static final String BUS = "bus";
    public static final String TAXI = "taxi";
    public static final String SHARE_TAXI = "share_taxi";
    public static final String MINI_BUS = "minibus";

    private static void populatePTModeTags() {
        PT_MODE_TAGS.add(CARRIAGE);
        PT_MODE_TAGS.add(TOURIST_BUS);
        PT_MODE_TAGS.add(COACH);
        PT_MODE_TAGS.add(BUS);
        PT_MODE_TAGS.add(SHARE_TAXI);
        PT_MODE_TAGS.add(MINI_BUS);
    }

    private static void populateModeTags() {
        MODE_TAGS.add(FOOT);
        MODE_TAGS.add(DOG);
        MODE_TAGS.add(HORSE);
        MODE_TAGS.add(BICYCLE);
        MODE_TAGS.add(CARRIAGE);
        MODE_TAGS.add(TRAILER);
        MODE_TAGS.add(CARAVAN);
        MODE_TAGS.add(MOTOR_CYCLE);
        MODE_TAGS.add(MOPED);
        MODE_TAGS.add(MOFA);
        MODE_TAGS.add(MOTOR_CAR);
        MODE_TAGS.add(MOTOR_HOME);
        MODE_TAGS.add(TOURIST_BUS);
        MODE_TAGS.add(COACH);
        MODE_TAGS.add(AGRICULTURAL);
        MODE_TAGS.add(GOLF_CART);
        MODE_TAGS.add(ATV);
        MODE_TAGS.add(GOODS);
        MODE_TAGS.add(HEAVY_GOODS);
        MODE_TAGS.add(HEAVY_GOODS_ARTICULATED);
        MODE_TAGS.add(BUS);
        MODE_TAGS.add(TAXI);
        MODE_TAGS.add(SHARE_TAXI);
        MODE_TAGS.add(MINI_BUS);
    }

    public static boolean isRoadModeTag(String modeTag) {
        return MODE_TAGS.contains(modeTag);
    }

    public static final Collection<String> getSupportedRoadModeTags() {
        return new HashSet<String>(MODE_TAGS);
    }

    public static final String[] getSupportedRoadModeTagsAsArray() {
        String[] modeTagsArray = new String[MODE_TAGS.size()];
        return MODE_TAGS.toArray(modeTagsArray);
    }

    public static boolean containsAnyMode(Collection<String> osmModes) {
        return !Collections.disjoint(MODE_TAGS, osmModes);
    }

    public static Collection<String> getModesFrom(Collection<String> eligibleOsmModes) {
        HashSet<String> intersectionModes = new HashSet<String>(eligibleOsmModes);
        intersectionModes.retainAll(MODE_TAGS);
        return intersectionModes;
    }

    public static Collection<String> getPublicTransportModesFrom(Collection<String> eligibleOsmModes) {
        HashSet<String> intersectionModes = new HashSet<String>(eligibleOsmModes);
        intersectionModes.retainAll(PT_MODE_TAGS);
        return intersectionModes;
    }

    static {
        OsmRoadModeTags.populatePTModeTags();
        OsmRoadModeTags.populateModeTags();
    }
}

