/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.util;

import de.topobyte.osm4j.core.model.iface.OsmEntity;
import de.topobyte.osm4j.core.model.iface.OsmNode;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.osm.util.Osm4JUtils;
import org.goplanit.osm.util.OsmNodeUtils;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;

public class OsmBoundingAreaUtils {
    private static final Logger LOGGER = Logger.getLogger(OsmBoundingAreaUtils.class.getCanonicalName());

    private static Envelope createBoundingBox(OsmWay osmWay, double offsetInMeters, Map<Long, OsmNode> osmNodes, PlanitJtsCrsUtils geoUtils) {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (int index = 0; index < osmWay.getNumberOfNodes(); ++index) {
            OsmNode osmNode = osmNodes.get(osmWay.getNodeId(index));
            if (osmNode == null) continue;
            minX = Math.min(minX, OsmNodeUtils.getX(osmNode));
            minY = Math.min(minY, OsmNodeUtils.getY(osmNode));
            maxX = Math.max(maxX, OsmNodeUtils.getX(osmNode));
            maxY = Math.max(maxY, OsmNodeUtils.getY(osmNode));
        }
        return geoUtils.createBoundingBox(minX, minY, maxX, maxY, offsetInMeters);
    }

    public static void logWarningIfNotNearBoundingBox(String message, Geometry geometry, Envelope boundingBox, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        if (!OsmBoundingAreaUtils.isNearNetworkBoundingBox(geometry, boundingBox, geoUtils)) {
            LOGGER.warning(message);
        }
    }

    public static boolean isNearNetworkBoundingBox(Geometry geometry, Envelope networkBoundingBox, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        return geoUtils.isGeometryNearBoundingBox(geometry, networkBoundingBox, 200.0);
    }

    public static boolean isCoveredByZoningBoundingPolygon(OsmNode osmNode, Polygon boundingPolygon) {
        if (osmNode == null || boundingPolygon == null) {
            return false;
        }
        return OsmNodeUtils.createPoint(osmNode).coveredBy(boundingPolygon);
    }

    public static boolean isCoveredByZoningBoundingPolygon(OsmWay osmWay, Map<Long, OsmNode> osmNodes, Polygon boundingPolygon) {
        if (osmWay == null || boundingPolygon == null) {
            return false;
        }
        boolean coveredByBoundingPolygon = false;
        for (int index = 0; index < osmWay.getNumberOfNodes(); ++index) {
            OsmNode osmNode;
            long osmNodeId = osmWay.getNodeId(index);
            if (!osmNodes.containsKey(osmNodeId) || !OsmBoundingAreaUtils.isCoveredByZoningBoundingPolygon(osmNode = osmNodes.get(osmNodeId), boundingPolygon)) continue;
            coveredByBoundingPolygon = true;
            break;
        }
        return coveredByBoundingPolygon;
    }

    public static Envelope createBoundingBoxForOsmWay(OsmEntity osmEntity, double offsetInMeters, Map<Long, OsmNode> osmNodes, PlanitJtsCrsUtils geoUtils) {
        Envelope boundingBox = null;
        switch (Osm4JUtils.getEntityType(osmEntity)) {
            case Node: {
                boundingBox = OsmBoundingAreaUtils.createBoundingBox((OsmNode)osmEntity, offsetInMeters, geoUtils);
                break;
            }
            case Way: {
                boundingBox = OsmBoundingAreaUtils.createBoundingBox((OsmWay)osmEntity, offsetInMeters, osmNodes, geoUtils);
                break;
            }
            default: {
                LOGGER.severe(String.format("unknown entity type %s when identifying bounding box for osm entity %s", Osm4JUtils.getEntityType(osmEntity).toString(), osmEntity.getId()));
            }
        }
        return boundingBox;
    }

    public static Envelope createBoundingBox(OsmNode osmNode, double offsetInMeters, PlanitJtsCrsUtils geoUtils) {
        double xCoord = OsmNodeUtils.getX(osmNode);
        double yCoord = OsmNodeUtils.getY(osmNode);
        return geoUtils.createBoundingBox(xCoord, yCoord, offsetInMeters);
    }
}

