/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.util;

import java.util.Map;

public class OsmTagUtils {
    public static final String VALUETAG_SPECIALCHAR_STRIP_REGEX = "[^\\w\\s]";

    public static boolean matchesAnyValueTag(String valueTag, String ... valueTags) {
        for (int index = 0; index < valueTags.length; ++index) {
            if (!valueTag.equals(valueTags[index])) continue;
            return true;
        }
        return false;
    }

    public static boolean keyMatchesAnyValueTag(Map<String, String> tags, String keyTag, String ... valueTags) {
        return OsmTagUtils.anyKeyMatchesAnyValueTag(tags, new String[]{keyTag}, valueTags);
    }

    public static boolean anyKeyMatchesAnyValueTag(Map<String, String> tags, String[] keyTags, String ... valueTags) {
        return OsmTagUtils.anyKeyMatchesAnyValueTag(tags, VALUETAG_SPECIALCHAR_STRIP_REGEX, keyTags, valueTags);
    }

    public static boolean anyKeyMatchesAnyValueTag(Map<String, String> tags, String regEx, String[] keyTags, String ... valueTags) {
        if (OsmTagUtils.containsAnyKey(tags, keyTags)) {
            for (int index = 0; index < keyTags.length; ++index) {
                String currentKey = keyTags[index];
                if (!tags.containsKey(currentKey) || !OsmTagUtils.matchesAnyValueTag(tags.get(currentKey).replaceAll(regEx, ""), valueTags)) continue;
                return true;
            }
        }
        return false;
    }

    public static String createCompositeOsmKey(String currentKey, String ... subTagConditions) {
        String compositeKey;
        String string = compositeKey = currentKey != null && !currentKey.isBlank() ? currentKey : "";
        if (subTagConditions != null) {
            for (int index = 0; index < subTagConditions.length; ++index) {
                String subTag = subTagConditions[index];
                compositeKey = subTag != null && !subTag.isBlank() ? compositeKey.concat(":").concat(subTag) : compositeKey;
            }
        }
        return compositeKey;
    }

    public static boolean containsAnyKey(Map<String, String> tags, String ... potentialKeys) {
        for (int index = 0; index < potentialKeys.length; ++index) {
            String potentialKey = potentialKeys[index];
            if (!tags.containsKey(potentialKey)) continue;
            return true;
        }
        return false;
    }

    public static String getValueForSupportedRefKeys(Map<String, String> tags) {
        if (tags.containsKey("ref")) {
            return tags.get("ref");
        }
        if (tags.containsKey("loc_ref")) {
            return tags.get("loc_ref");
        }
        if (tags.containsKey("local_ref")) {
            return tags.get("local_ref");
        }
        return null;
    }
}

