/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.util;

import de.topobyte.osm4j.core.model.iface.EntityType;
import de.topobyte.osm4j.core.model.iface.OsmEntity;
import de.topobyte.osm4j.core.model.iface.OsmNode;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.osm.tags.OsmPtv1Tags;
import org.goplanit.osm.util.Osm4JUtils;
import org.goplanit.osm.util.OsmNodeUtils;
import org.goplanit.osm.util.OsmWayUtils;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitGraphGeoUtils;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.goplanit.utils.zoning.TransferZoneType;
import org.goplanit.utils.zoning.Zone;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.linearref.LinearLocation;

public class PlanitTransferZoneUtils {
    private static final Logger LOGGER = Logger.getLogger(PlanitTransferZoneUtils.class.getCanonicalName());
    private static final String TRANSFERZONE_SERVICED_OSM_MODES_INPUT_PROPERTY_KEY = "osmmodes";
    private static final String TRANSFERZONE_STATION_INPUT_PROPERTY_KEY = "station";

    private static Zone findZoneClosest(OsmEntity osmEntity, Collection<? extends Zone> zones, Map<Long, OsmNode> osmNodes, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        EntityType type = Osm4JUtils.getEntityType(osmEntity);
        switch (type) {
            case Node: {
                return OsmNodeUtils.findZoneClosest((OsmNode)osmEntity, zones, geoUtils);
            }
            case Way: {
                return OsmWayUtils.findZoneClosest((OsmWay)osmEntity, zones, osmNodes, geoUtils);
            }
        }
        LOGGER.warning(String.format("unsupported osm entity type when finding closest zone to %d", osmEntity.getId()));
        return null;
    }

    private static void setTransferZoneStationName(TransferZone transferZone, String stationName) {
        transferZone.addInputProperty(TRANSFERZONE_STATION_INPUT_PROPERTY_KEY, stationName);
    }

    private static boolean hasTransferZoneStationName(TransferZone transferZone) {
        return PlanitTransferZoneUtils.getTransferZoneStationName(transferZone) != null;
    }

    public static TransferZone findTransferZoneClosestByTransferGroup(OsmEntity osmEntity, Collection<? extends TransferZoneGroup> transferZoneGroups, Map<Long, OsmNode> osmNodes, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        HashSet<TransferZone> closestPerGroup = new HashSet<TransferZone>();
        for (TransferZoneGroup transferZoneGroup : transferZoneGroups) {
            TransferZone closestOfGroup = (TransferZone)PlanitTransferZoneUtils.findZoneClosest(osmEntity, transferZoneGroup.getTransferZones(), osmNodes, geoUtils);
            closestPerGroup.add(closestOfGroup);
        }
        return (TransferZone)PlanitTransferZoneUtils.findZoneClosest(osmEntity, closestPerGroup, osmNodes, geoUtils);
    }

    public static boolean isTransferZoneAtLocation(TransferZone transferZone, Point location) throws PlanItException {
        PlanItException.throwIfNull(transferZone, "Transfer zone is null, unable to verify location");
        if (transferZone.hasCentroid() && transferZone.getCentroid().hasPosition()) {
            return location.equals(transferZone.getCentroid().getPosition());
        }
        if (transferZone.hasGeometry()) {
            if (transferZone.getGeometry() instanceof Point) {
                return location.equals(transferZone.getGeometry());
            }
        } else {
            throw new PlanItException("Transferzone representing platform/pole %s has no valid geometry attached, unable to verify location", transferZone.getExternalId());
        }
        return false;
    }

    public static boolean isTransferZoneLeftOf(TransferZone transferZone, Coordinate coordA, Coordinate coordB, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Geometry transferzoneGeometry = null;
        if (transferZone.hasCentroid() && transferZone.getCentroid().hasPosition()) {
            transferzoneGeometry = transferZone.getCentroid().getPosition();
        } else if (transferZone.hasGeometry()) {
            transferzoneGeometry = transferZone.getGeometry();
        } else {
            throw new PlanItException("Transferzone representing platform/pole %s has no valid geometry attached, unable to determine on which side of line AB (%s, %s) is resides", transferZone.getExternalId(), coordA.toString(), coordB.toString());
        }
        return geoUtils.isGeometryLeftOf(transferzoneGeometry, coordA, coordB);
    }

    public static Collection<EdgeSegment> identifyInvalidTransferZoneAccessLinkSegmentsBasedOnRelativeLocationToInfrastructure(Collection<EdgeSegment> accessLinkSegments, TransferZone transferZone, Mode planitMode, boolean leftHandDrive, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        ArrayList<EdgeSegment> invalidAccessLinkSegments = new ArrayList<EdgeSegment>(accessLinkSegments.size());
        for (EdgeSegment linkSegment : accessLinkSegments) {
            LineSegment finalLineSegment = PlanitGraphGeoUtils.extractClosestLineSegmentTo(transferZone.getGeometry(), linkSegment, geoUtils);
            boolean isTransferZoneLeftOfInfrastructure = PlanitTransferZoneUtils.isTransferZoneLeftOf(transferZone, finalLineSegment.p0, finalLineSegment.p1, geoUtils);
            if (isTransferZoneLeftOfInfrastructure == leftHandDrive) continue;
            invalidAccessLinkSegments.add(linkSegment);
        }
        return invalidAccessLinkSegments;
    }

    public static void updateTransferZoneStationName(TransferZone transferZone, Map<String, String> tags) {
        String stationName = tags.get("name");
        if (!transferZone.hasName() && stationName != null) {
            transferZone.setName(stationName);
        }
        if (!PlanitTransferZoneUtils.hasTransferZoneStationName(transferZone)) {
            PlanitTransferZoneUtils.setTransferZoneStationName(transferZone, stationName);
        }
    }

    public static void registerOsmModesOnTransferZone(TransferZone transferZone, Collection<String> eligibleOsmModes) {
        if (transferZone != null && eligibleOsmModes != null) {
            transferZone.addInputProperty(TRANSFERZONE_SERVICED_OSM_MODES_INPUT_PROPERTY_KEY, eligibleOsmModes);
        }
    }

    public static Collection<String> getRegisteredOsmModesForTransferZone(TransferZone transferZone) {
        Collection eligibleOsmModes = (Collection)transferZone.getInputProperty(TRANSFERZONE_SERVICED_OSM_MODES_INPUT_PROPERTY_KEY);
        if (eligibleOsmModes != null) {
            return Collections.unmodifiableCollection(eligibleOsmModes);
        }
        return null;
    }

    public static String getTransferZoneStationName(TransferZone transferZone) {
        return (String)transferZone.getInputProperty(TRANSFERZONE_STATION_INPUT_PROPERTY_KEY);
    }

    public static EntityType extractOsmEntityType(TransferZone transferZone) throws PlanItException {
        if (transferZone.getGeometry() instanceof Point) {
            return EntityType.Node;
        }
        if (transferZone.getGeometry() instanceof Polygon || transferZone.getGeometry() instanceof LineString) {
            return EntityType.Way;
        }
        throw new PlanItException("unknown geometry type encountered for transfer zone (osm id %s)", transferZone.getExternalId());
    }

    public static LinearLocation extractClosestProjectedLinearLocationOnEdgeForTransferZone(TransferZone transferZone, Edge accessEdge, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        LinearLocation projectedLinearLocationOnLink = null;
        EntityType transferZoneGeometryType = PlanitTransferZoneUtils.extractOsmEntityType(transferZone);
        if (transferZoneGeometryType.equals((Object)EntityType.Node)) {
            projectedLinearLocationOnLink = geoUtils.getClosestProjectedLinearLocationOnGeometry((Point)transferZone.getGeometry(), accessEdge.getGeometry());
        } else if (transferZoneGeometryType.equals((Object)EntityType.Way)) {
            projectedLinearLocationOnLink = geoUtils.getClosestGeometryExistingCoordinateToProjectedLinearLocationOnLineString(transferZone.getGeometry(), accessEdge.getGeometry());
        } else {
            throw new PlanItException("Unsupported osm entity type encountered for transfer zone (osm waiting area %s)", transferZone.getExternalId());
        }
        return projectedLinearLocationOnLink;
    }

    public static TransferZoneType extractTransferZoneTypeFromPtv1Tags(OsmNode osmNode, Map<String, String> tags) {
        if (OsmPtv1Tags.isBusStop(tags)) {
            return TransferZoneType.POLE;
        }
        if (OsmPtv1Tags.isTramStop(tags)) {
            return TransferZoneType.PLATFORM;
        }
        if (OsmPtv1Tags.isHalt(tags)) {
            return TransferZoneType.SMALL_STATION;
        }
        if (OsmPtv1Tags.isStation(tags)) {
            return TransferZoneType.STATION;
        }
        LOGGER.severe(String.format("unable to map node %d to Ptv1 transferzone type", osmNode.getId()));
        return TransferZoneType.UNKNOWN;
    }
}

