/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.output.adapter;

import java.util.Optional;
import org.goplanit.assignment.TrafficAssignment;
import org.goplanit.output.adapter.OutputTypeAdapterImpl;
import org.goplanit.output.adapter.PathOutputTypeAdapter;
import org.goplanit.output.enums.OutputType;
import org.goplanit.output.enums.PathOutputIdentificationType;
import org.goplanit.output.property.OutputProperty;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.od.OdDataIterator;
import org.goplanit.utils.path.DirectedPath;
import org.goplanit.utils.time.TimePeriod;

public abstract class PathOutputTypeAdapterImpl
extends OutputTypeAdapterImpl
implements PathOutputTypeAdapter {
    public PathOutputTypeAdapterImpl(OutputType outputType, TrafficAssignment trafficAssignment) {
        super(outputType, trafficAssignment);
    }

    @Override
    public Optional<?> getPathOutputPropertyValue(OutputProperty outputProperty, OdDataIterator<? extends DirectedPath> odPathIterator, Mode mode, TimePeriod timePeriod, PathOutputIdentificationType pathOutputType) {
        try {
            Optional<?> value = this.getOutputTypeIndependentPropertyValue(outputProperty, mode, timePeriod);
            if (value.isPresent()) {
                return value;
            }
            switch (outputProperty.getOutputPropertyType()) {
                case DESTINATION_ZONE_EXTERNAL_ID: {
                    return PathOutputTypeAdapter.getDestinationZoneExternalId(odPathIterator);
                }
                case DESTINATION_ZONE_XML_ID: {
                    return PathOutputTypeAdapter.getDestinationZoneXmlId(odPathIterator);
                }
                case DESTINATION_ZONE_ID: {
                    return PathOutputTypeAdapter.getDestinationZoneId(odPathIterator);
                }
                case PATH_STRING: {
                    return PathOutputTypeAdapter.getPathAsString(odPathIterator, pathOutputType);
                }
                case PATH_ID: {
                    return PathOutputTypeAdapter.getPathId(odPathIterator);
                }
                case ORIGIN_ZONE_EXTERNAL_ID: {
                    return PathOutputTypeAdapter.getOriginZoneExternalId(odPathIterator);
                }
                case ORIGIN_ZONE_XML_ID: {
                    return PathOutputTypeAdapter.getOriginZoneXmlId(odPathIterator);
                }
                case ORIGIN_ZONE_ID: {
                    return PathOutputTypeAdapter.getOriginZoneId(odPathIterator);
                }
            }
            return Optional.of(String.format("Tried to find link property of %s which is not applicable for OD path", outputProperty.getName()));
        }
        catch (PlanItException e) {
            return Optional.of(e.getMessage());
        }
    }
}

