/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.output.configuration;

import java.util.Arrays;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.output.configuration.OutputTypeConfiguration;
import org.goplanit.output.enums.OutputType;
import org.goplanit.output.property.OutputProperty;
import org.goplanit.output.property.OutputPropertyType;
import org.goplanit.utils.exceptions.PlanItException;

public class LinkOutputTypeConfiguration
extends OutputTypeConfiguration {
    private static final Logger LOGGER = Logger.getLogger(LinkOutputTypeConfiguration.class.getCanonicalName());
    private static final int LINK_SEGMENT_IDENTIFICATION_BY_NODE_XML_ID = 1;
    private static final int LINK_SEGMENT_IDENTIFICATION_BY_NODE_EXTERNAL_ID = 2;
    private static final int LINK_SEGMENT_IDENTIFICATION_BY_ID = 3;
    private static final int LINK_SEGMENT_IDENTIFICATION_BY_XML_ID = 4;
    private static final int LINK_SEGMENT_IDENTIFICATION_BY_EXTERNAL_ID = 5;
    private static final int LINK_SEGMENT_NOT_IDENTIFIED = 6;

    private int findIdentificationMethod(OutputProperty[] outputKeyProperties) {
        Set outputKeyPropertyList = Arrays.stream(outputKeyProperties).map(op -> op.getOutputPropertyType()).collect(Collectors.toSet());
        if (outputKeyPropertyList.contains((Object)OutputPropertyType.DOWNSTREAM_NODE_XML_ID) && outputKeyPropertyList.contains((Object)OutputPropertyType.UPSTREAM_NODE_XML_ID)) {
            return 1;
        }
        if (outputKeyPropertyList.contains((Object)OutputPropertyType.LINK_SEGMENT_ID)) {
            return 3;
        }
        if (outputKeyPropertyList.contains((Object)OutputPropertyType.LINK_SEGMENT_XML_ID)) {
            return 4;
        }
        if (outputKeyPropertyList.contains((Object)OutputPropertyType.LINK_SEGMENT_EXTERNAL_ID)) {
            return 5;
        }
        if (outputKeyPropertyList.contains((Object)OutputPropertyType.DOWNSTREAM_NODE_EXTERNAL_ID) && outputKeyPropertyList.contains((Object)OutputPropertyType.UPSTREAM_NODE_EXTERNAL_ID)) {
            return 2;
        }
        return 6;
    }

    public LinkOutputTypeConfiguration() throws PlanItException {
        super(OutputType.LINK);
        this.addProperty(OutputPropertyType.LINK_SEGMENT_XML_ID);
        this.addProperty(OutputPropertyType.UPSTREAM_NODE_XML_ID);
        this.addProperty(OutputPropertyType.DOWNSTREAM_NODE_XML_ID);
        this.addProperty(OutputPropertyType.FLOW);
        this.addProperty(OutputPropertyType.CALCULATED_SPEED);
        this.addProperty(OutputPropertyType.LINK_SEGMENT_COST);
        this.addProperty(OutputPropertyType.MODE_XML_ID);
        this.addProperty(OutputPropertyType.MAXIMUM_SPEED);
        this.addProperty(OutputPropertyType.TIME_PERIOD_XML_ID);
    }

    @Override
    public OutputProperty[] validateAndFilterKeyProperties(OutputProperty[] outputKeyProperties) {
        OutputProperty[] outputKeyPropertiesArray = null;
        boolean valid = false;
        try {
            switch (this.findIdentificationMethod(outputKeyProperties)) {
                case 1: {
                    outputKeyPropertiesArray = new OutputProperty[]{OutputProperty.of(OutputPropertyType.DOWNSTREAM_NODE_XML_ID), OutputProperty.of(OutputPropertyType.UPSTREAM_NODE_XML_ID)};
                    valid = true;
                    break;
                }
                case 2: {
                    outputKeyPropertiesArray = new OutputProperty[]{OutputProperty.of(OutputPropertyType.DOWNSTREAM_NODE_EXTERNAL_ID), OutputProperty.of(OutputPropertyType.UPSTREAM_NODE_EXTERNAL_ID)};
                    valid = true;
                    break;
                }
                case 3: {
                    outputKeyPropertiesArray = new OutputProperty[]{OutputProperty.of(OutputPropertyType.LINK_SEGMENT_ID)};
                    valid = true;
                    break;
                }
                case 4: {
                    outputKeyPropertiesArray = new OutputProperty[]{OutputProperty.of(OutputPropertyType.LINK_SEGMENT_XML_ID)};
                    valid = true;
                    break;
                }
                case 5: {
                    outputKeyPropertiesArray = new OutputProperty[]{OutputProperty.of(OutputPropertyType.LINK_SEGMENT_EXTERNAL_ID)};
                    valid = true;
                    break;
                }
                default: {
                    LOGGER.warning("configured keys cannot identify link segments");
                    break;
                }
            }
        }
        catch (Exception e) {
            LOGGER.warning(e.getMessage());
            LOGGER.warning("Invalid keys encountered for identifying link segments");
        }
        if (valid) {
            return outputKeyPropertiesArray;
        }
        return null;
    }

    @Override
    public boolean isOutputPropertyValid(OutputProperty baseOutputProperty) {
        switch (baseOutputProperty.getOutputPropertyType()) {
            case CALCULATED_SPEED: {
                return true;
            }
            case CAPACITY_PER_LANE: {
                return true;
            }
            case DENSITY: {
                return true;
            }
            case DOWNSTREAM_NODE_EXTERNAL_ID: {
                return true;
            }
            case DOWNSTREAM_NODE_XML_ID: {
                return true;
            }
            case DOWNSTREAM_NODE_ID: {
                return true;
            }
            case DOWNSTREAM_NODE_LOCATION: {
                return true;
            }
            case UPSTREAM_NODE_EXTERNAL_ID: {
                return true;
            }
            case UPSTREAM_NODE_XML_ID: {
                return true;
            }
            case UPSTREAM_NODE_ID: {
                return true;
            }
            case UPSTREAM_NODE_LOCATION: {
                return true;
            }
            case FLOW: {
                return true;
            }
            case ITERATION_INDEX: {
                return true;
            }
            case LENGTH: {
                return true;
            }
            case LINK_SEGMENT_COST: {
                return true;
            }
            case LINK_SEGMENT_TYPE_ID: {
                return true;
            }
            case LINK_SEGMENT_TYPE_NAME: {
                return true;
            }
            case LINK_SEGMENT_TYPE_XML_ID: {
                return true;
            }
            case LINK_SEGMENT_EXTERNAL_ID: {
                return true;
            }
            case LINK_SEGMENT_XML_ID: {
                return true;
            }
            case LINK_SEGMENT_ID: {
                return true;
            }
            case MAXIMUM_DENSITY: {
                return true;
            }
            case MAXIMUM_SPEED: {
                return true;
            }
            case MODE_EXTERNAL_ID: {
                return true;
            }
            case MODE_XML_ID: {
                return true;
            }
            case MODE_ID: {
                return true;
            }
            case NUMBER_OF_LANES: {
                return true;
            }
            case RUN_ID: {
                return true;
            }
            case TIME_PERIOD_EXTERNAL_ID: {
                return true;
            }
            case TIME_PERIOD_XML_ID: {
                return true;
            }
            case TIME_PERIOD_ID: {
                return true;
            }
            case VC_RATIO: {
                return true;
            }
            case COST_TIMES_FLOW: {
                return true;
            }
        }
        LOGGER.warning("tried to add " + baseOutputProperty.getName() + " as an ouput property, which is inappropriate for Link output.  This will be ignored");
        return false;
    }
}

