/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.project;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.component.PlanitComponent;
import org.goplanit.component.PlanitComponentFactory;
import org.goplanit.cost.physical.initial.InitialLinkSegmentCost;
import org.goplanit.cost.physical.initial.InitialPhysicalCost;
import org.goplanit.demands.Demands;
import org.goplanit.input.InputBuilderListener;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.Network;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.network.TransportLayerNetwork;
import org.goplanit.path.OdPathSets;
import org.goplanit.project.ProjectDemands;
import org.goplanit.project.ProjectNetworks;
import org.goplanit.project.ProjectOdPathSets;
import org.goplanit.project.ProjectRoutedServices;
import org.goplanit.project.ProjectServiceNetworks;
import org.goplanit.project.ProjectZonings;
import org.goplanit.service.routed.RoutedServices;
import org.goplanit.service.routed.RoutedServicesLayer;
import org.goplanit.supply.fundamentaldiagram.FundamentalDiagramComponent;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.network.layer.ServiceNetworkLayer;
import org.goplanit.utils.network.layer.TransportLayer;
import org.goplanit.utils.network.layers.ServiceNetworkLayers;
import org.goplanit.utils.time.TimePeriod;
import org.goplanit.zoning.Zoning;

public class PlanItProjectInput {
    private static final Logger LOGGER = Logger.getLogger(PlanItProjectInput.class.getCanonicalName());
    private final IdGroupingToken projectGroupId;
    private final long projectId;
    protected final Map<TransportLayerNetwork<?, ?>, List<InitialLinkSegmentCost>> initialLinkSegmentCosts = new HashMap();
    protected final Collection<PlanitComponentFactory<?>> planitComponentFactories = new ArrayList();
    protected final ProjectNetworks physicalNetworks = new ProjectNetworks();
    protected final ProjectDemands demands = new ProjectDemands();
    protected final ProjectZonings zonings = new ProjectZonings();
    protected final ProjectServiceNetworks serviceNetworks = new ProjectServiceNetworks();
    protected final ProjectRoutedServices routedServices = new ProjectRoutedServices();
    protected final ProjectOdPathSets odPathSets = new ProjectOdPathSets();

    private void initialiseFactories(InputBuilderListener inputBuilderListener) {
        this.planitComponentFactories.clear();
        this.planitComponentFactories.add(new PlanitComponentFactory(InitialPhysicalCost.class));
        this.planitComponentFactories.add(new PlanitComponentFactory(Network.class.getCanonicalName()));
        this.planitComponentFactories.add(new PlanitComponentFactory(Zoning.class));
        this.planitComponentFactories.add(new PlanitComponentFactory(Demands.class));
        this.planitComponentFactories.add(new PlanitComponentFactory(RoutedServices.class));
        this.planitComponentFactories.add(new PlanitComponentFactory(FundamentalDiagramComponent.class));
        this.planitComponentFactories.forEach(factory -> factory.addListener(inputBuilderListener));
    }

    private <T extends PlanitComponent<?>> PlanitComponentFactory<T> getComponentFactory(Class<T> clazz) throws PlanItException {
        return this.planitComponentFactories.stream().filter(factory -> factory.isFactoryForDerivedClassesOf(clazz)).findFirst().orElseThrow(() -> new PlanItException("component factory unavailable for %s", clazz.getCanonicalName()));
    }

    protected InitialLinkSegmentCost createAndRegisterInitialLinkSegmentCost(TransportLayerNetwork<?, ?> network, String fileName, TimePeriod timePeriod) throws PlanItException {
        PlanItException.throwIf(network == null, "Physical network must be read in before initial costs can be read", new Object[0]);
        if (!this.initialLinkSegmentCosts.containsKey(network)) {
            this.initialLinkSegmentCosts.put(network, new ArrayList());
        }
        InitialLinkSegmentCost initialLinkSegmentCost = (InitialLinkSegmentCost)this.getComponentFactory(InitialPhysicalCost.class).create(InitialLinkSegmentCost.class.getCanonicalName(), new Object[]{this.projectGroupId}, fileName, network, timePeriod);
        if (timePeriod != null) {
            LOGGER.info(LoggingUtils.createProjectPrefix(this.projectId) + LoggingUtils.createTimePeriodPrefix(timePeriod) + "populated initial link segment costs");
        } else {
            LOGGER.info(LoggingUtils.createProjectPrefix(this.projectId) + "populated initial link segment costs");
        }
        this.initialLinkSegmentCosts.get(network).add(initialLinkSegmentCost);
        return initialLinkSegmentCost;
    }

    public PlanItProjectInput(long projectId, IdGroupingToken projectGroupId, InputBuilderListener inputBuilderListener) {
        this.projectId = projectId;
        this.projectGroupId = projectGroupId;
        this.initialiseFactories(inputBuilderListener);
    }

    public TransportLayerNetwork<?, ?> createAndRegisterInfrastructureNetwork(String infrastructureNetworkType) throws PlanItException {
        LOGGER.info(LoggingUtils.createProjectPrefix(this.projectId) + "populating network");
        Network theNetwork = this.getComponentFactory(Network.class).create(infrastructureNetworkType, new Object[]{this.projectGroupId});
        if (!(theNetwork instanceof TransportLayerNetwork)) {
            throw new PlanItException("we currently only support networks derived from InfrastructureNetwork");
        }
        TransportLayerNetwork infrastructureNetwork = (TransportLayerNetwork)theNetwork;
        String prefix = LoggingUtils.createProjectPrefix(this.projectId) + LoggingUtils.createNetworkPrefix(infrastructureNetwork.getId());
        LOGGER.info(String.format("%s#modes: %d", prefix, infrastructureNetwork.getModes().size()));
        for (TransportLayer networkLayer : infrastructureNetwork.getTransportLayers()) {
            networkLayer.logInfo(prefix);
        }
        this.physicalNetworks.register(infrastructureNetwork);
        return infrastructureNetwork;
    }

    public Zoning createAndRegisterZoning(TransportLayerNetwork<?, ?> infrastructureNetwork) throws PlanItException {
        PlanItException.throwIf(infrastructureNetwork == null, "The physical network must be defined before definition of zones can begin", new Object[0]);
        LOGGER.info(LoggingUtils.createProjectPrefix(this.projectId) + "populating zoning");
        Zoning zoning = this.getComponentFactory(Zoning.class).create(Zoning.class.getCanonicalName(), new Object[]{this.projectGroupId, infrastructureNetwork.getNetworkGroupingTokenId()}, infrastructureNetwork);
        String prefix = LoggingUtils.createProjectPrefix(this.projectId) + LoggingUtils.createZoningPrefix(zoning.getId());
        zoning.logInfo(prefix);
        this.zonings.register(zoning);
        return zoning;
    }

    public Demands createAndRegisterDemands(Zoning zoning, TransportLayerNetwork<?, ?> network) throws PlanItException {
        PlanItException.throwIf(zoning == null, "Zones must be defined before definition of demands can begin", new Object[0]);
        PlanItException.throwIf(network == null, "network must be defined before definition of demands can begin", new Object[0]);
        LOGGER.info(LoggingUtils.createProjectPrefix(this.projectId) + "populating demands");
        Demands demands = this.getComponentFactory(Demands.class).create(Demands.class.getCanonicalName(), new Object[]{this.projectGroupId}, zoning, network);
        String prefix = LoggingUtils.createProjectPrefix(this.projectId) + LoggingUtils.createDemandsPrefix(demands.getId());
        LOGGER.info(String.format("%s#time periods: %d", prefix, demands.timePeriods.size()));
        LOGGER.info(String.format("%s#traveler types: %d", prefix, demands.travelerTypes.size()));
        LOGGER.info(String.format("%s#user classes: %d", prefix, demands.userClasses.size()));
        this.demands.register(demands);
        return demands;
    }

    public ServiceNetwork createAndRegisterServiceNetwork(MacroscopicNetwork network) throws PlanItException {
        PlanItException.throwIf(network == null, "Physical network must be defined before definition of service network can begin", new Object[0]);
        LOGGER.info(String.format("%spopulating service network with parent physical network %s", LoggingUtils.createProjectPrefix(this.projectId), network.getXmlId()));
        Network theNetwork = this.getComponentFactory(Network.class).create(ServiceNetwork.class.getCanonicalName(), new Object[]{this.projectGroupId, network});
        if (!(theNetwork instanceof ServiceNetwork)) {
            throw new PlanItException("we currently only support ServiceNetwork derived classes when creating service networks");
        }
        ServiceNetwork serviceNetwork = (ServiceNetwork)theNetwork;
        String prefix = LoggingUtils.createProjectPrefix(this.projectId) + LoggingUtils.createServiceNetworkPrefix(serviceNetwork.getId());
        if (((ServiceNetworkLayers)serviceNetwork.getTransportLayers()).isEmpty()) {
            LOGGER.warning(String.format("Created service network for parent network %s is empty", network.getXmlId()));
        } else {
            LOGGER.info(String.format("%s#modes: %d", prefix, serviceNetwork.getModes().size()));
            for (ServiceNetworkLayer networkLayer : (ServiceNetworkLayers)serviceNetwork.getTransportLayers()) {
                networkLayer.logInfo(prefix);
            }
        }
        this.serviceNetworks.register(serviceNetwork);
        return serviceNetwork;
    }

    public RoutedServices createAndRegisterRoutedServices(ServiceNetwork serviceNetwork) throws PlanItException {
        PlanItException.throwIf(serviceNetwork == null, "Parent service network must be defined before definition of routed services can begin", new Object[0]);
        LOGGER.info(String.format("%spopulating routed services with parent service network %s", LoggingUtils.createProjectPrefix(this.projectId), serviceNetwork.getXmlId()));
        RoutedServices routedServices = this.getComponentFactory(RoutedServices.class).create(RoutedServices.class.getCanonicalName(), new Object[]{this.projectGroupId, serviceNetwork});
        String prefix = LoggingUtils.createProjectPrefix(this.projectId) + LoggingUtils.createRoutedServicesPrefix(routedServices.getId());
        for (RoutedServicesLayer layer : routedServices.getLayers()) {
            layer.logInfo(prefix);
        }
        this.routedServices.register(routedServices);
        return routedServices;
    }

    public OdPathSets createAndRegisterOdPathSets(TransportLayer networkLayer, Zoning zoning, String odPathSetInputPath) throws PlanItException {
        PlanItException.throwIf(zoning == null, "Zones must be defined before definition of od path sets can proceed", new Object[0]);
        PlanItException.throwIf(networkLayer == null, "Physical network must be defined before of od path sets can proceed", new Object[0]);
        LOGGER.info(LoggingUtils.createProjectPrefix(this.projectId) + "populating od path sets");
        OdPathSets odPathSets = this.getComponentFactory(OdPathSets.class).create(OdPathSets.class.getCanonicalName(), new Object[]{this.projectGroupId}, odPathSetInputPath);
        String prefix = LoggingUtils.createProjectPrefix(this.projectId) + LoggingUtils.createOdPathSetsPrefix(odPathSets.getId());
        LOGGER.info(String.format("%s#od path sets: %d", prefix, odPathSets.getNumberOfOdPathSets()));
        this.odPathSets.register(odPathSets);
        return odPathSets;
    }

    public InitialLinkSegmentCost createAndRegisterInitialLinkSegmentCost(TransportLayerNetwork<?, ?> network, String fileName) throws PlanItException {
        return this.createAndRegisterInitialLinkSegmentCost(network, fileName, null);
    }

    public List<InitialLinkSegmentCost> getInitialLinkSegmentCost(TransportLayerNetwork<?, ?> network) {
        return this.initialLinkSegmentCosts.get(network);
    }
}

