/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.service.routed;

import org.goplanit.service.routed.RoutedService;
import org.goplanit.service.routed.RoutedServiceTripInfo;
import org.goplanit.service.routed.RoutedServiceTripInfoImpl;
import org.goplanit.utils.id.ExternalIdAbleImpl;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;

public class RoutedServiceImpl
extends ExternalIdAbleImpl
implements RoutedService {
    private String name;
    private String nameDescription;
    private String serviceDescription;
    private final RoutedServiceTripInfo trips;

    protected static long generateId(IdGroupingToken tokenId) {
        return IdGenerator.generateId(tokenId, RoutedService.ROUTED_SERVICE_ID_CLASS);
    }

    public RoutedServiceImpl(IdGroupingToken tokenId) {
        super(RoutedServiceImpl.generateId(tokenId));
        this.name = null;
        this.nameDescription = null;
        this.serviceDescription = null;
        this.trips = new RoutedServiceTripInfoImpl(tokenId);
    }

    public RoutedServiceImpl(RoutedServiceImpl routedServiceImpl) {
        super(routedServiceImpl);
        this.name = routedServiceImpl.name;
        this.nameDescription = routedServiceImpl.nameDescription;
        this.serviceDescription = routedServiceImpl.serviceDescription;
        this.trips = routedServiceImpl.trips.clone();
    }

    @Override
    public long recreateManagedIds(IdGroupingToken tokenId) {
        long newId = RoutedServiceImpl.generateId(tokenId);
        this.setId(newId);
        return newId;
    }

    @Override
    public RoutedServiceImpl clone() {
        return new RoutedServiceImpl(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getNameDescription() {
        return this.nameDescription;
    }

    @Override
    public void setNameDescription(String nameDescription) {
        this.nameDescription = nameDescription;
    }

    @Override
    public String getServiceDescription() {
        return this.serviceDescription;
    }

    @Override
    public void setServiceDescription(String serviceDescription) {
        this.serviceDescription = serviceDescription;
    }

    @Override
    public RoutedServiceTripInfo getTripInfo() {
        return this.trips;
    }

    @Override
    public void resetChildManagedIdEntities() {
        this.trips.reset();
    }
}

