/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.service.routed;

import java.io.Serializable;
import java.util.logging.Logger;
import org.goplanit.component.PlanitComponent;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.service.routed.RoutedServicesLayers;
import org.goplanit.service.routed.RoutedServicesLayersImpl;
import org.goplanit.utils.id.IdGroupingToken;

public class RoutedServices
extends PlanitComponent<RoutedServices>
implements Serializable {
    private static final long serialVersionUID = -5966641341343291539L;
    private static final Logger LOGGER = Logger.getLogger(RoutedServices.class.getCanonicalName());
    private ServiceNetwork parentServiceNetwork;
    private final RoutedServicesLayers layers;

    public RoutedServices(IdGroupingToken tokenId, ServiceNetwork parentServiceNetwork) {
        super(tokenId, RoutedServices.class);
        this.parentServiceNetwork = parentServiceNetwork;
        this.layers = new RoutedServicesLayersImpl(tokenId);
    }

    public RoutedServices(RoutedServices routedServices) {
        super(routedServices);
        this.parentServiceNetwork = routedServices.parentServiceNetwork;
        this.layers = routedServices.layers.clone();
    }

    @Override
    public PlanitComponent<RoutedServices> clone() {
        return new RoutedServices(this);
    }

    public ServiceNetwork getParentNetwork() {
        return this.parentServiceNetwork;
    }

    public RoutedServicesLayers getLayers() {
        return this.layers;
    }

    @Override
    public void reset() {
        this.layers.reset();
    }
}

