/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.service.routed;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import org.goplanit.service.routed.RelativeLegTiming;
import org.goplanit.service.routed.RoutedTripDepartures;
import org.goplanit.service.routed.RoutedTripDeparturesImpl;
import org.goplanit.service.routed.RoutedTripImpl;
import org.goplanit.service.routed.RoutedTripSchedule;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.layer.service.ServiceLegSegment;

public class RoutedTripScheduleImpl
extends RoutedTripImpl
implements RoutedTripSchedule {
    private final RoutedTripDepartures departures;
    private final List<RelativeLegTiming> relativeLegTimings;
    private LocalTime defaultDwellTime;

    public RoutedTripScheduleImpl(IdGroupingToken tokenId) {
        super(tokenId);
        this.departures = new RoutedTripDeparturesImpl(tokenId);
        this.relativeLegTimings = new ArrayList<RelativeLegTiming>(1);
    }

    public RoutedTripScheduleImpl(RoutedTripScheduleImpl routedTripScheduleImpl) {
        super(routedTripScheduleImpl);
        this.departures = routedTripScheduleImpl.departures.clone();
        this.relativeLegTimings = new ArrayList<RelativeLegTiming>(routedTripScheduleImpl.relativeLegTimings);
    }

    @Override
    public long recreateManagedIds(IdGroupingToken tokenId) {
        long newId = RoutedTripScheduleImpl.generateId(tokenId);
        this.setId(newId);
        return newId;
    }

    @Override
    public void resetChildManagedIdEntities() {
        super.resetChildManagedIdEntities();
        this.departures.reset();
    }

    @Override
    public RoutedTripScheduleImpl clone() {
        return new RoutedTripScheduleImpl(this);
    }

    @Override
    public RoutedTripDepartures getDepartures() {
        return this.departures;
    }

    @Override
    public void clearRelativeLegTimings() {
        this.relativeLegTimings.clear();
    }

    @Override
    public RelativeLegTiming addRelativeLegSegmentTiming(ServiceLegSegment parentLegSegment, LocalTime duration, LocalTime dwellTime) {
        RelativeLegTiming newEntry = new RelativeLegTiming(parentLegSegment, duration, dwellTime);
        this.relativeLegTimings.add(newEntry);
        return newEntry;
    }

    @Override
    public RelativeLegTiming getRelativeLegTiming(int index) {
        return this.relativeLegTimings.get(index);
    }

    @Override
    public int getRelativeLegTimingsSize() {
        return this.relativeLegTimings.size();
    }

    public LocalTime getDefaultDwellTime() {
        return this.defaultDwellTime;
    }

    public void setDefaultDwellTime(LocalTime defaultDwellTime) {
        this.defaultDwellTime = defaultDwellTime;
    }
}

