/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.supply.fundamentaldiagram;

import org.goplanit.utils.math.Precision;

public interface FundamentalDiagramBranch
extends Cloneable {
    public double getFlowPcuHour(double var1);

    public double getDensityPcuKm(double var1);

    default public double getSpeedKmHourByFlow(double flowPcuHour) {
        if (Precision.isGreater(flowPcuHour, 0.0)) {
            return flowPcuHour / this.getDensityPcuKm(flowPcuHour);
        }
        return this.getSpeedKmHourAtZeroFlow();
    }

    public double getSpeedKmHourAtZeroFlow();

    default public double getSpeedKmHourByDensity(double densityPcuKm) {
        if (Precision.isGreater(densityPcuKm, 0.0)) {
            return this.getFlowPcuHour(densityPcuKm) / densityPcuKm;
        }
        return this.getSpeedKmHourAtZeroDensity();
    }

    public double getSpeedKmHourAtZeroDensity();

    public double getFlowTangent(double var1);

    default public double getDensityTangent(double densityPcuKm) {
        return 1.0 / this.getFlowTangent(this.getFlowPcuHour(densityPcuKm));
    }

    public int relaxedHashCode(int var1);

    public FundamentalDiagramBranch clone();

    public boolean isLinear();
}

