/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.args;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.utils.args.ArgumentStyle;
import org.goplanit.utils.exceptions.PlanItException;

public class ArgumentParser {
    private static final Logger LOGGER = Logger.getLogger(ArgumentParser.class.getCanonicalName());

    private static boolean updateMap(String splitter, String arg, Map<String, String> argsMap) {
        if (arg.contains(splitter)) {
            String[] parts = arg.split(splitter);
            argsMap.put(parts[0].toUpperCase().strip(), parts[1]);
            return true;
        }
        return false;
    }

    protected static Map<String, String> convertArgsToMapDefaultStyle(String[] args) throws PlanItException {
        HashMap<String, String> argsMap = new HashMap<String, String>();
        for (String arg : args) {
            boolean validKey = false;
            validKey = ArgumentParser.updateMap("=", arg, argsMap);
            validKey = validKey || ArgumentParser.updateMap("-", arg, argsMap);
            boolean bl = validKey = validKey || ArgumentParser.updateMap(":", arg, argsMap);
            if (validKey) continue;
            throw new PlanItException("Argument %s cannot be parsed into a program input", arg);
        }
        return argsMap;
    }

    protected static Map<String, String> convertArgsToMapDoubleHyphenStyle(String[] args) throws PlanItException {
        HashMap<String, String> argsMap = new HashMap<String, String>();
        boolean parseKey = true;
        String key = null;
        for (String arg : args) {
            String trimmedArg = arg.trim();
            if (!parseKey && trimmedArg.startsWith("--")) {
                argsMap.put(key, "");
                parseKey = true;
            }
            if (parseKey) {
                if (!trimmedArg.startsWith("--")) {
                    throw new PlanItException("keys should start with \\\"--\" but found %s", arg);
                }
                key = trimmedArg.substring(2);
                parseKey = false;
                continue;
            }
            argsMap.put(key, trimmedArg);
            parseKey = true;
        }
        return argsMap;
    }

    public static Map<String, String> convertArgsToMap(String[] args) throws PlanItException {
        return ArgumentParser.convertArgsToMap(args, ArgumentStyle.DEFAULT);
    }

    public static Map<String, String> convertArgsToMap(String[] args, ArgumentStyle style) throws PlanItException {
        switch (style) {
            case DEFAULT: {
                return ArgumentParser.convertArgsToMapDefaultStyle(args);
            }
            case DOUBLEHYPHEN: {
                return ArgumentParser.convertArgsToMapDoubleHyphenStyle(args);
            }
        }
        LOGGER.warning("Unknown argument style provided, assuming default style");
        return ArgumentParser.convertArgsToMapDefaultStyle(args);
    }
}

