/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.geo;

import java.util.Collection;
import java.util.logging.Logger;
import org.goplanit.utils.geo.PlanitJtsItemVisitor;
import org.goplanit.utils.zoning.Zone;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;

public class PlanitJtsIntersectZoneVisitor<T extends Zone>
extends PlanitJtsItemVisitor<T> {
    private static final Logger LOGGER = Logger.getLogger(PlanitJtsIntersectZoneVisitor.class.getCanonicalName());

    public PlanitJtsIntersectZoneVisitor(Polygon geometryFilter, Collection<T> filteredResultToPopulate) {
        super(geometryFilter, filteredResultToPopulate);
    }

    @Override
    protected Geometry getGeometry(T zone) {
        if (zone.hasGeometry()) {
            return zone.getGeometry();
        }
        if (zone.hasCentroid() && zone.getCentroid().hasPosition()) {
            return zone.getCentroid().getPosition();
        }
        LOGGER.severe(String.format("Zone %s has no geotry information available", zone.getXmlId()));
        return null;
    }
}

