/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.geo;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitCrsUtils;
import org.goplanit.utils.misc.Pair;
import org.locationtech.jts.algorithm.RobustDeterminant;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.linearref.LinearLocation;
import org.locationtech.jts.linearref.LocationIndexedLine;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class PlanitJtsUtils {
    private static final Logger LOGGER = Logger.getLogger(PlanitJtsUtils.class.getCanonicalName());
    protected static final GeometryFactory jtsGeometryFactory = JTSFactoryFinder.getGeometryFactory();

    public static MathTransform findMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem destinationCRS) throws PlanItException {
        PlanItException.throwIfNull(sourceCRS, "source coordinate reference system null when creating math transform");
        PlanItException.throwIfNull(destinationCRS, "destination coordinate reference system null when creating math transform");
        PlanitCrsUtils.silenceHsqlLogging();
        try {
            boolean lenient = true;
            return CRS.findMathTransform(sourceCRS, destinationCRS, lenient);
        }
        catch (Exception e) {
            throw new PlanItException(String.format("error during creation of transformer from CRS %s to CRS %s", sourceCRS.toString(), destinationCRS.toString()), e);
        }
    }

    public static Coordinate createCoordinate(DirectPosition position) {
        return new Coordinate(position.getOrdinate(0), position.getOrdinate(1));
    }

    public static Point createPoint(Coordinate coordinate) {
        Point newPoint = jtsGeometryFactory.createPoint(coordinate);
        return newPoint;
    }

    public static Point createPoint(Number xCoordinate, Number yCoordinate) throws PlanItException {
        Coordinate coordinate = new Coordinate(xCoordinate.doubleValue(), yCoordinate.doubleValue());
        return PlanitJtsUtils.createPoint(coordinate);
    }

    public static LineSegment createLineSegment(Coordinate coordinate1, Coordinate coordinate2) {
        return new LineSegment(coordinate1, coordinate2);
    }

    public static LineString createLineString(List<Double> coordinateList) throws PlanItException {
        PlanItException.throwIf(coordinateList.size() % 2 != 0, "coordinate list must contain an even number of entries to correctly identify (x,y) pairs", new Object[0]);
        Iterator<Double> iter = coordinateList.iterator();
        Coordinate[] coordinateArray = new Coordinate[coordinateList.size() / 2];
        int index = 0;
        while (iter.hasNext()) {
            coordinateArray[index++] = new Coordinate(iter.next(), iter.next());
        }
        return PlanitJtsUtils.createLineString(coordinateArray);
    }

    public static LineString createLineString(String value, char ts, char cs) throws PlanItException {
        ArrayList<Double> coordinateDoubleList = new ArrayList<Double>();
        String[] tupleString = value.split("[" + ts + "]");
        for (int index = 0; index < tupleString.length; ++index) {
            String xyCoordinateString = tupleString[index];
            String[] coordinateString = xyCoordinateString.split("[" + cs + "]");
            if (coordinateString.length != 2) {
                throw new PlanItException(String.format("invalid coordinate encountered, expected two coordinates in tuple, but found %d", coordinateString.length));
            }
            coordinateDoubleList.add(Double.parseDouble(coordinateString[0]));
            coordinateDoubleList.add(Double.parseDouble(coordinateString[1]));
        }
        return PlanitJtsUtils.createLineString(coordinateDoubleList);
    }

    public static LineString createLineString(Coordinate ... coordinates) throws PlanItException {
        return jtsGeometryFactory.createLineString(coordinates);
    }

    public static LineString createLineStringFromCsvString(String value, String ts, String cs) throws PlanItException {
        if (ts.length() > 1 || cs.length() > 1) {
            PlanItException.throwIf(ts.length() > 1, String.format("tuple separating string to create LineString is not a single character but %s", ts), new Object[0]);
            PlanItException.throwIf(cs.length() > 1, String.format("comma separating string to create LineString is not a single character but %s", cs), new Object[0]);
        }
        return PlanitJtsUtils.createLineString(value, ts.charAt(0), cs.charAt(0));
    }

    public static String createCsvStringFromCoordinates(Coordinate[] coordinates, Character ts, Character cs, DecimalFormat df) {
        StringBuilder csvStringBuilder = new StringBuilder();
        int lastIndex = coordinates.length - 1;
        for (int index = 0; index < coordinates.length; ++index) {
            Coordinate coordinate = coordinates[index];
            csvStringBuilder.append(df.format(coordinate.x)).append(cs).append(df.format(coordinate.y));
            if (index == lastIndex) break;
            csvStringBuilder.append(ts);
        }
        return csvStringBuilder.toString();
    }

    public static Polygon createPolygon() {
        Polygon polygon = jtsGeometryFactory.createPolygon();
        return polygon;
    }

    public static Polygon create2DPolygon(List<Double> coordinateList2D) {
        return PlanitJtsUtils.createPolygon(PlanitJtsUtils.listTo2DCoordinates(coordinateList2D));
    }

    public static Polygon createPolygon(Coordinate[] coords) {
        return jtsGeometryFactory.createPolygon(jtsGeometryFactory.createLinearRing(coords));
    }

    public static Polygon create2DPolygon(Envelope envelope) {
        Coordinate[] coordinates = new Coordinate[]{new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate(envelope.getMinX(), envelope.getMaxY()), new Coordinate(envelope.getMaxX(), envelope.getMaxY()), new Coordinate(envelope.getMaxX(), envelope.getMinY()), new Coordinate(envelope.getMinX(), envelope.getMinY())};
        return PlanitJtsUtils.createPolygon(coordinates);
    }

    public static Coordinate[] directPositionsToCoordinates(List<DirectPosition> positions) throws PlanItException {
        Coordinate[] coordinates = new Coordinate[positions.size()];
        for (int index = 0; index < coordinates.length; ++index) {
            coordinates[index] = PlanitJtsUtils.createCoordinate(positions.get(index));
        }
        return coordinates;
    }

    public static Coordinate[] listTo2DCoordinates(List<?> posList) {
        int dimensions = 2;
        Coordinate[] coordinates = new Coordinate[posList.size() / dimensions];
        int index = 0;
        while (index + dimensions - 1 < posList.size()) {
            coordinates[index / dimensions] = new Coordinate(Double.parseDouble(posList.get(index).toString()), Double.parseDouble(posList.get(index + 1).toString()));
            index += dimensions;
        }
        return coordinates;
    }

    public static Coordinate[] copyWithoutNullEntries(Coordinate[] coordArray) {
        Coordinate[] copy = new Coordinate[coordArray.length];
        int copyIndex = 0;
        for (int index = 0; index < copy.length; ++index) {
            Coordinate currCoord = coordArray[index];
            if (currCoord == null) continue;
            copy[copyIndex] = currCoord;
            ++copyIndex;
        }
        if (copyIndex > 0) {
            return Arrays.copyOf(copy, copyIndex);
        }
        return null;
    }

    public static boolean isClosed2D(Coordinate[] coordArray) {
        if (coordArray != null && coordArray.length > 2) {
            return coordArray[0].equals2D(coordArray[coordArray.length - 1]);
        }
        return false;
    }

    public static Coordinate[] makeClosed2D(Coordinate[] coordArray) throws PlanItException {
        if (coordArray != null && coordArray.length >= 2) {
            if (!PlanitJtsUtils.isClosed2D(coordArray)) {
                Coordinate[] closedCoordArray = Arrays.copyOf(coordArray, coordArray.length + 1);
                closedCoordArray[coordArray.length] = coordArray[0];
                return closedCoordArray;
            }
            return coordArray;
        }
        throw new PlanItException("Cannot make passed in coordinates closed 2D");
    }

    public static LineString createCopyWithoutCoordinatesBefore(Point position, LineString geometry) throws PlanItException {
        Optional<Integer> offset = PlanitJtsUtils.findFirstCoordinatePosition(position.getCoordinate(), geometry);
        if (!offset.isPresent()) {
            throw new PlanItException(String.format("point (%s) does not exist on line string (%s), unable to create copy from this location", position.toString(), geometry.toString()));
        }
        Coordinate[] coordinates = PlanitJtsUtils.copyCoordinatesFrom(offset.get(), geometry);
        if (coordinates.length == 1) {
            throw new PlanItException(String.format("linestring (%s) without coordinates before %s results in single coordinate, unable to create linestring", geometry.toString(), position.toString()));
        }
        return PlanitJtsUtils.createLineString(coordinates);
    }

    public static LineString createCopyWithoutCoordinatesBefore(int startIndex, LineString geometry) throws PlanItException {
        if (startIndex >= geometry.getNumPoints() || startIndex < 0) {
            throw new PlanItException("invalid start index for extracting coordinates from line string geometry");
        }
        return PlanitJtsUtils.createLineString(PlanitJtsUtils.copyCoordinatesFrom(startIndex, geometry));
    }

    public static LineString createCopyWithoutCoordinatesAfter(Point position, LineString geometry) throws PlanItException {
        Optional<Integer> offset = PlanitJtsUtils.findFirstCoordinatePosition(position.getCoordinate(), geometry);
        if (!offset.isPresent()) {
            throw new PlanItException(String.format("point (%s) does not exist on line string %s, unable to create copy from this location", position.toString(), geometry.toString()));
        }
        Coordinate[] coordinates = PlanitJtsUtils.copyCoordinatesUpToNotIncluding(offset.get() + 1, geometry);
        return PlanitJtsUtils.createLineString(coordinates);
    }

    public static LineString createCopyWithoutCoordinatesAfter(int endIndex, LineString geometry) throws PlanItException {
        if (geometry == null) {
            return null;
        }
        if (endIndex >= geometry.getNumPoints() || endIndex < 0) {
            throw new PlanItException("invalid end index for extracting coordinates from line string geometry");
        }
        return PlanitJtsUtils.createLineString(PlanitJtsUtils.copyCoordinatesUpToNotIncluding(endIndex + 1, geometry));
    }

    public static LineString createCopyWithoutAdjacentDuplicateCoordinates(LineString geometry) {
        if (geometry == null) {
            return null;
        }
        ArrayList<Coordinate> coordinateList = new ArrayList<Coordinate>(geometry.getNumPoints());
        int numCoordinates = geometry.getNumPoints();
        int index = 0;
        int nextIndex = index + 1;
        while (index < numCoordinates) {
            Coordinate coordinate = geometry.getCoordinateN(index);
            boolean isAdjacentDuplicate = false;
            if (nextIndex < numCoordinates) {
                Coordinate adjacentCoordinate = geometry.getCoordinateN(index + 1);
                isAdjacentDuplicate = coordinate.equals2D(adjacentCoordinate);
            }
            if (!isAdjacentDuplicate) {
                coordinateList.add(coordinate);
            }
            ++index;
            ++nextIndex;
        }
        return jtsGeometryFactory.createLineString((Coordinate[])coordinateList.stream().toArray(Coordinate[]::new));
    }

    public static Optional<Integer> findFirstCoordinatePosition(Coordinate coordinateToLocate, int offset, LineString geometry) {
        if (geometry == null || coordinateToLocate == null) {
            return Optional.empty();
        }
        int numCoordinates = geometry.getNumPoints();
        for (int index = offset; index < numCoordinates; ++index) {
            Coordinate coordinate = geometry.getCoordinateN(index);
            if (!coordinate.equals2D(coordinateToLocate)) continue;
            return Optional.of(index);
        }
        return Optional.empty();
    }

    public static Optional<Integer> findFirstCoordinatePosition(Coordinate coordinateToLocate, LineString geometry) {
        return PlanitJtsUtils.findFirstCoordinatePosition(coordinateToLocate, 0, geometry);
    }

    public static Coordinate[] copyCoordinatesFrom(int offset, LineString geometry) throws PlanItException {
        return PlanitJtsUtils.copyCoordinatesFromUpToNotIncluding(offset, geometry.getNumPoints(), geometry);
    }

    public static Coordinate[] copyCoordinatesUpToNotIncluding(int untilPoint, LineString geometry) throws PlanItException {
        return PlanitJtsUtils.copyCoordinatesFromUpToNotIncluding(0, untilPoint, geometry);
    }

    public static Coordinate[] copyCoordinatesFromUpToNotIncluding(int offset, int untilPoint, LineString geometry) throws PlanItException {
        PlanItException.throwIfNull(geometry, "provided geometry to copy coordinates from is null");
        int numCoordinates = geometry.getNumPoints();
        if (offset > untilPoint || untilPoint > numCoordinates) {
            LOGGER.severe("unable to extract coordinates from line string, offset is larger than final point, and/or final point exceeds number of coordinates in geometry");
        }
        Coordinate[] coordinates = new Coordinate[untilPoint - offset];
        for (int index = offset; index < untilPoint; ++index) {
            Coordinate coordinate;
            coordinates[index - offset] = coordinate = geometry.getCoordinateN(index);
        }
        return coordinates;
    }

    public static LineString concatenate(LineString ... geometries) {
        MultiLineString theMultiLineString = jtsGeometryFactory.createMultiLineString(geometries);
        return jtsGeometryFactory.createLineString(theMultiLineString.getCoordinates());
    }

    public static LineString convertToJtsLineString(org.opengis.geometry.coordinate.LineString openGisLineString) throws PlanItException {
        PointArray samplePoints = openGisLineString.getSamplePoints();
        List coordinates = samplePoints.stream().map(point -> PlanitJtsUtils.createCoordinate(point.getDirectPosition())).collect(Collectors.toList());
        return jtsGeometryFactory.createLineString((Coordinate[])coordinates.toArray());
    }

    public static LineString convertToLineString(MultiLineString jtsMultiLineString) throws PlanItException {
        PlanItException.throwIf(jtsMultiLineString.getNumGeometries() > 1, "MultiLineString contains multiple LineStrings", new Object[0]);
        return (LineString)jtsMultiLineString.getGeometryN(0);
    }

    public static Pair<LineString, LineString> splitLineString(LineString geometry, LinearLocation splitLocation) {
        LocationIndexedLine locIndexedLine = new LocationIndexedLine(geometry);
        LineString geometryStartToLinearLocation = (LineString)locIndexedLine.extractLine(locIndexedLine.getStartIndex(), splitLocation);
        LineString geometryLinearLocationToEnd = null;
        if (!splitLocation.isEndpoint(geometry)) {
            geometryLinearLocationToEnd = (LineString)locIndexedLine.extractLine(splitLocation, locIndexedLine.getEndIndex());
        }
        return Pair.of(geometryStartToLinearLocation, geometryLinearLocationToEnd);
    }

    public static LineString mergeLineStrings(LineString first, LineString second) {
        if (first == null && second != null) {
            return (LineString)second.copy();
        }
        if (first != null && second == null) {
            return (LineString)first.copy();
        }
        LineMerger lineMerger = new LineMerger();
        lineMerger.add((Geometry)first);
        lineMerger.add((Geometry)second);
        if (lineMerger.getMergedLineStrings() == null || lineMerger.getMergedLineStrings().isEmpty()) {
            return null;
        }
        return (LineString)lineMerger.getMergedLineStrings().iterator().next();
    }

    public static boolean isCoordinateLeftOf(Coordinate coordM, Coordinate coordA, Coordinate coordB) {
        return RobustDeterminant.orientationIndex(coordA, coordB, coordM) == 1;
    }

    public static boolean isCoordinateRightOf(Coordinate coordM, Coordinate coordA, Coordinate coordB) {
        return RobustDeterminant.orientationIndex(coordA, coordB, coordM) == -1;
    }

    public static int getCoordinateIndexOf(Coordinate coordinate, Coordinate[] coordinates) throws PlanItException {
        for (int coordinateIndex = 1; coordinateIndex < coordinates.length - 1; ++coordinateIndex) {
            Point internalPoint = PlanitJtsUtils.createPoint(coordinates[coordinateIndex]);
            if (!internalPoint.getCoordinate().equals2D(coordinate)) continue;
            return coordinateIndex;
        }
        return -1;
    }
}

