/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.graph;

import java.io.Serializable;
import org.geotools.geometry.jts.JTS;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.graph.GraphEntity;
import org.goplanit.utils.graph.Vertex;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineString;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public interface Edge
extends Serializable,
GraphEntity {
    public static final Class<Edge> EDGE_ID_CLASS = Edge.class;

    public LineString getGeometry();

    public void setGeometry(LineString var1);

    public boolean removeVertex(Vertex var1);

    public Vertex getVertexA();

    public Vertex getVertexB();

    public void setName(String var1);

    public String getName();

    public void setLengthKm(double var1);

    public double getLengthKm();

    public void addInputProperty(String var1, Object var2);

    public Object getInputProperty(String var1);

    public boolean replace(Vertex var1, Vertex var2) throws PlanItException;

    @Override
    public Edge clone();

    public boolean validate();

    default public Class<Edge> getIdClass() {
        return EDGE_ID_CLASS;
    }

    default public boolean hasName() {
        return this.getName() != null && !this.getName().isBlank();
    }

    default public boolean hasVertex(Vertex vertex) {
        return this.getVertexA().equals(vertex) || this.getVertexB().equals(vertex);
    }

    default public boolean hasGeometry() {
        return this.getGeometry() != null;
    }

    default public boolean isGeometryInAbDirection() {
        boolean isVertexAStartPoint = this.getGeometry().getStartPoint().equals(this.getVertexA().getPosition());
        boolean isVertexBEndPoint = this.getGeometry().getEndPoint().equals(this.getVertexB().getPosition());
        return isVertexAStartPoint && isVertexBEndPoint;
    }

    default public void transformGeometry(MathTransform transformer) throws MismatchedDimensionException, TransformException {
        this.setGeometry((LineString)JTS.transform(this.getGeometry(), transformer));
    }

    default public Envelope createEnvelope() {
        if (this.hasGeometry()) {
            return this.getGeometry().getEnvelopeInternal();
        }
        return null;
    }
}

