/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.graph;

import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.GraphEntities;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.id.ManagedId;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public interface UntypedGraph<V extends Vertex, E extends Edge>
extends ManagedId {
    public static final Class<UntypedGraph> GRAPH_ID_CLASS = UntypedGraph.class;

    public GraphEntities<V> getVertices();

    public GraphEntities<E> getEdges();

    default public boolean isEmpty() {
        return this.getVertices() != null && !this.getVertices().isEmpty() && this.getEdges() != null && !this.getEdges().isEmpty();
    }

    default public boolean validate() {
        boolean isValid = true;
        for (Edge edge : this.getEdges()) {
            isValid = isValid && edge.validate();
        }
        for (Vertex vertex : this.getVertices()) {
            isValid = isValid && vertex.validate();
        }
        return isValid;
    }

    default public void transformGeometries(MathTransform transformer) throws MismatchedDimensionException, TransformException {
        for (Edge edge : this.getEdges()) {
            edge.transformGeometry(transformer);
        }
        for (Vertex vertex : this.getVertices()) {
            vertex.transformPosition(transformer);
        }
    }
}

