/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.graph;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.geometry.jts.JTS;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.GraphEntity;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Point;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public interface Vertex
extends Serializable,
GraphEntity {
    public static final Logger LOGGER = Logger.getLogger(Vertex.class.getCanonicalName());
    public static final Class<Vertex> VERTEX_ID_CLASS = Vertex.class;

    public void addInputProperty(String var1, Object var2);

    public Object getInputProperty(String var1);

    public void setPosition(Point var1);

    public Point getPosition();

    public boolean addEdge(Edge var1);

    public boolean removeEdge(long var1);

    public Collection<Edge> getEdges();

    @Override
    public Vertex clone();

    default public Class<Vertex> getIdClass() {
        return VERTEX_ID_CLASS;
    }

    default public boolean hasPosition() {
        return this.getPosition() != null;
    }

    default public boolean removeEdge(Edge edge) {
        return this.removeEdge(edge.getId());
    }

    default public Set<Edge> getEdges(Vertex otherVertex) {
        HashSet<Edge> edges = new HashSet<Edge>();
        for (Edge edge : this.getEdges()) {
            if (edge.getVertexA().getId() == this.getId() && edge.getVertexB().getId() == otherVertex.getId()) {
                edges.add(edge);
                continue;
            }
            if (edge.getVertexB().getId() != this.getId() || edge.getVertexA().getId() != otherVertex.getId()) continue;
            edges.add(edge);
        }
        return edges;
    }

    default public int getNumberOfEdges() {
        return this.getEdges().size();
    }

    default public boolean replace(Edge edgeToReplace, Edge edgeToReplaceWith, boolean forceInsert) {
        if (this.removeEdge(edgeToReplace) || forceInsert) {
            return this.addEdge(edgeToReplaceWith);
        }
        return false;
    }

    default public void transformPosition(MathTransform transformer) throws MismatchedDimensionException, TransformException {
        this.setPosition((Point)JTS.transform(this.getPosition(), transformer));
    }

    default public boolean isPositionEqual2D(Coordinate coordinate) {
        return this.hasPosition() && this.getPosition().getCoordinate().equals2D(coordinate);
    }

    default public boolean validate() {
        for (Edge edge : this.getEdges()) {
            if (edge.hasVertex(this)) continue;
            LOGGER.warning(String.format("Edge (id:%d) does not contain vertex (id:%d externalId:%s) even though the vertex is connected to it", edge.getId(), this.getId(), this.getExternalId()));
            return false;
        }
        return true;
    }
}

