/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.id;

import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.ManagedId;
import org.goplanit.utils.id.ManagedIdEntities;
import org.goplanit.utils.wrapper.LongMapWrapperImpl;

public abstract class ManagedIdEntitiesImpl<E extends ManagedId>
extends LongMapWrapperImpl<E>
implements ManagedIdEntities<E> {
    protected final Class<? extends ManagedId> managedIdClass;

    protected ManagedIdEntitiesImpl(Function<E, Long> valueToKey, Class<? extends ManagedId> managedIdClass) {
        super(new TreeMap(), valueToKey);
        this.managedIdClass = managedIdClass;
    }

    protected ManagedIdEntitiesImpl(ManagedIdEntitiesImpl<E> other) {
        super(other);
        this.managedIdClass = other.managedIdClass;
    }

    protected void updateIdMapping() {
        Map updatedMap = ManagedIdEntitiesImpl.createEmptyInstance(this.getMap());
        this.getMap().forEach((? super K oldId, ? super V entity) -> updatedMap.put((Long)this.getValueToKey().apply(entity), entity));
        this.getMap().clear();
        this.setMap(updatedMap);
    }

    @Override
    public Class<? extends ManagedId> getManagedIdClass() {
        return this.managedIdClass;
    }

    @Override
    public void recreateIds(boolean resetManagedIdClass) {
        if (resetManagedIdClass) {
            IdGenerator.reset(this.getFactory().getIdGroupingToken(), this.getManagedIdClass());
        }
        if (!this.isEmpty()) {
            this.forEach(entity -> entity.recreateManagedIds(this.getFactory().getIdGroupingToken()));
            this.updateIdMapping();
        }
    }

    @Override
    public void reset() {
        for (ManagedId entry : this) {
            entry.resetChildManagedIdEntities();
        }
        this.clear();
        IdGenerator.reset(this.getFactory().getIdGroupingToken(), this.getManagedIdClass());
    }

    @Override
    public abstract ManagedIdEntitiesImpl<E> clone();
}

