/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.math;

import java.text.DecimalFormat;

public class Precision {
    public static final double EPSILON_18 = 1.0E-18;
    public static final double EPSILON_15 = 1.0E-15;
    public static final double EPSILON_12 = 1.0E-12;
    public static final double EPSILON_9 = 1.0E-9;
    public static final double EPSILON_6 = 1.0E-6;
    public static final double EPSILON_3 = 0.001;
    public static final DecimalFormat DEFAULT_DECIMAL_FORMAT = (DecimalFormat)DecimalFormat.getInstance();

    public static boolean isEqual(double d1, double d2, double epsilon) {
        return !Precision.isSmaller(d1, d2, epsilon) && !Precision.isGreater(d1, d2, epsilon);
    }

    public static boolean isEqual(double d1, double d2) {
        return Precision.isEqual(d1, d2, 1.0E-6);
    }

    public static boolean isSmallerEqual(double d1, double d2, double epsilon) {
        return d1 <= d2 + epsilon;
    }

    public static boolean isSmaller(double d1, double d2) {
        return Precision.isSmaller(d1, d2, 1.0E-6);
    }

    public static boolean isSmaller(double d1, double d2, double epsilon) {
        return d1 + epsilon < d2;
    }

    public static boolean isSmallerEqual(double d1, double d2) {
        return Precision.isSmallerEqual(d1, d2, 1.0E-6);
    }

    public static boolean isGreaterEqual(double d1, double d2, double epsilon) {
        return d1 >= d2 - epsilon;
    }

    public static boolean isGreaterEqual(double d1, double d2) {
        return Precision.isGreaterEqual(d1, d2, 1.0E-6);
    }

    public static boolean isGreater(double d1, double d2, double epsilon) {
        return d1 - epsilon > d2;
    }

    public static boolean isGreater(double d1, double d2) {
        return Precision.isGreater(d1, d2, 1.0E-6);
    }

    public static boolean isPositive(double d1) {
        return Precision.isGreater(d1, 0.0, 1.0E-6);
    }

    public static boolean isNotEqual(double d1, double d2) {
        return !Precision.isEqual(d1, d2);
    }

    static {
        DEFAULT_DECIMAL_FORMAT.setMaximumFractionDigits(8);
        DEFAULT_DECIMAL_FORMAT.setMinimumFractionDigits(2);
        DEFAULT_DECIMAL_FORMAT.setGroupingUsed(false);
    }
}

