/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.misc;

import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.logging.Logger;

public class UriUtils {
    private static final Logger LOGGER = Logger.getLogger(UriUtils.class.getCanonicalName());
    private static final String JAR_SCHEME = "jar";
    private static final String FILE_SCHEME = "file";

    public static URI getWorkingDirUri() {
        return Path.of("", new String[0]).toUri();
    }

    public static URI getJvmUserDirUri() throws URISyntaxException {
        URL resource = ClassLoader.getSystemClassLoader().getResource(".");
        if (resource == null) {
            LOGGER.fine("Unable to find JVM user dir resource, was expected to be available");
            return null;
        }
        return resource.toURI();
    }

    public static boolean isInJar(URI uri) {
        return JAR_SCHEME.equals(uri.getScheme());
    }

    public static boolean isRegularFile(URI uri) {
        return FILE_SCHEME.equals(uri.getScheme());
    }

    public static URI asDirectory(URI uri) {
        return !uri.toString().endsWith("/") ? URI.create(uri.toString().concat("/")) : uri;
    }

    public static URI jarUriOfJarEntry(URI uri) {
        try {
            JarURLConnection jarEntryConn = (JarURLConnection)uri.toURL().openConnection();
            return UriUtils.uriOfJarUrl(jarEntryConn.getJarFileURL());
        }
        catch (Exception e) {
            LOGGER.severe(String.format("Unable to extract jar component from uri %s", uri.toString()));
            return uri;
        }
    }

    public static URI asRelativeUriFromRoot(URI uri) {
        URI relativeToRoot = URI.create(uri.toString());
        if (UriUtils.hasScheme(uri)) {
            relativeToRoot = UriUtils.removeInitialScheme(relativeToRoot);
            return UriUtils.asRelativeUriFromRoot(relativeToRoot);
        }
        return !relativeToRoot.toString().startsWith("/") ? URI.create("/" + relativeToRoot.toString()) : uri;
    }

    public static URI removeInitialScheme(URI uri) {
        if (UriUtils.hasScheme(uri)) {
            return URI.create(uri.getSchemeSpecificPart().toString());
        }
        return uri;
    }

    public static boolean hasScheme(URI uri) {
        return uri.getScheme() != null && !uri.getScheme().isBlank();
    }

    public static boolean hasPath(URI uri) {
        return uri.getPath() != null && !uri.getPath().isBlank();
    }

    public static URI uriOfJarUrl(URL jarFileURL) {
        return URI.create("jar:" + jarFileURL.toString() + "!/");
    }

    public static URI asRelativeUriFromWorkingDir(URI uri) {
        URI workingDirUri = UriUtils.getWorkingDirUri();
        return workingDirUri.relativize(uri);
    }

    public static URI asRelativeUriFromUserDir(URI uri) throws URISyntaxException {
        URI workingDirUri = UriUtils.getJvmUserDirUri();
        if (workingDirUri == null) {
            return uri;
        }
        return workingDirUri.relativize(uri);
    }

    public static URI asRelativeUriFromJar(URI uri) {
        if (!UriUtils.isInJar(uri)) {
            return uri;
        }
        URI jarLocationURI = UriUtils.jarUriOfJarEntry(uri);
        URI desiredUriWithoutScheme = UriUtils.removeInitialScheme(uri);
        URI jarLocationURIWithoutScheme = UriUtils.removeInitialScheme(jarLocationURI);
        return jarLocationURIWithoutScheme.relativize(desiredUriWithoutScheme);
    }

    public static URI asRelativeUri(URI uri) throws URISyntaxException {
        URI relativeURIFromJar;
        URI relativeURIFromUserDir;
        URI relativeResourceUri = UriUtils.asRelativeUriFromWorkingDir(uri);
        if (relativeResourceUri != null && relativeResourceUri.getScheme() == null) {
            LOGGER.fine(relativeResourceUri.toString());
            return relativeResourceUri;
        }
        if (relativeResourceUri != null && relativeResourceUri.getScheme() != null && (relativeURIFromUserDir = UriUtils.asRelativeUriFromUserDir(uri)) != null && relativeResourceUri.getScheme() == null) {
            LOGGER.fine(relativeURIFromUserDir.toString());
            return relativeURIFromUserDir;
        }
        if (relativeResourceUri.getScheme() != null && UriUtils.isInJar(uri) && (relativeURIFromJar = UriUtils.asRelativeUriFromJar(uri)) != null) {
            relativeURIFromJar = UriUtils.asRelativeUriFromRoot(relativeURIFromJar);
            LOGGER.fine(relativeURIFromJar.toString());
            return relativeURIFromJar;
        }
        return uri;
    }
}

