/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.network.layer;

import java.util.Collection;
import org.goplanit.utils.id.ExternalIdAble;
import org.goplanit.utils.id.ManagedId;
import org.goplanit.utils.mode.Mode;

public interface TransportLayer
extends ExternalIdAble,
ManagedId {
    public static final Class<TransportLayer> TRANSPORT_LAYER_ID_CLASS = TransportLayer.class;

    default public Class<TransportLayer> getIdClass() {
        return TRANSPORT_LAYER_ID_CLASS;
    }

    public static String createLayerLogPrefix(TransportLayer layer) {
        return String.format("[LAYER: %s ]", layer.getXmlId());
    }

    public boolean registerSupportedMode(Mode var1);

    public boolean registerSupportedModes(Collection<Mode> var1);

    public Collection<Mode> getSupportedModes();

    public boolean isEmpty();

    public void logInfo(String var1);

    public boolean validate();

    default public boolean supports(Mode mode) {
        return this.getSupportedModes().contains(mode);
    }

    default public boolean hasSupportedModes() {
        return !this.getSupportedModes().isEmpty();
    }

    default public Mode getFirstSupportedMode() {
        return this.hasSupportedModes() ? this.getSupportedModes().iterator().next() : null;
    }

    public void reset();
}

