/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.network.layer.macroscopic;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.pcu.PcuCapacitated;

public interface MacroscopicLinkSegment
extends LinkSegment,
PcuCapacitated {
    public boolean isModeAllowed(Mode var1);

    public Set<Mode> getAllowedModes();

    public double computeFreeFlowTravelTimeHour(Mode var1);

    default public double getModelledSpeedLimitKmH(Mode mode) {
        if (!this.isModeAllowed(mode)) {
            return 0.0;
        }
        return Math.min(this.getPhysicalSpeedLimitKmH(), this.getLinkSegmentType().getMaximumSpeedKmH(mode));
    }

    public void setLinkSegmentType(MacroscopicLinkSegmentType var1);

    public MacroscopicLinkSegmentType getLinkSegmentType();

    default public boolean hasLinkSegmentType() {
        return this.getLinkSegmentType() != null;
    }

    default public Set<Mode> getAllowedModesFrom(Collection<Mode> modes) {
        HashSet<Mode> allowedModes = new HashSet<Mode>();
        for (Mode mode : modes) {
            if (!this.isModeAllowed(mode)) continue;
            allowedModes.add(mode);
        }
        return allowedModes;
    }

    @Override
    default public double getCapacityOrDefaultPcuH() {
        return this.getCapacityOrDefaultPcuHLane() * (double)this.getNumberOfLanes();
    }

    @Override
    default public double getCapacityOrDefaultPcuHLane() {
        return this.getLinkSegmentType().getExplicitCapacityPerLaneOrDefault();
    }
}

