/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.network.layers;

import java.util.ArrayList;
import java.util.Collection;
import org.goplanit.utils.id.ManagedIdEntities;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.TransportLayer;

public interface TransportLayers<T extends TransportLayer>
extends ManagedIdEntities<T> {
    @Override
    public T get(Mode var1);

    public T getByXmlId(String var1);

    default public boolean isNoLayers() {
        return this.size() <= 0;
    }

    default public boolean isEachLayerEmpty() {
        boolean eachLayerEmpty = true;
        for (TransportLayer layer : this) {
            if (layer.isEmpty()) continue;
            eachLayerEmpty = false;
            break;
        }
        return eachLayerEmpty;
    }

    default public <U extends TransportLayer> Collection<U> getLayersOfType() {
        ArrayList<TransportLayer> layerList = new ArrayList<TransportLayer>();
        for (TransportLayer layer : this) {
            try {
                TransportLayer castLayer = layer;
                layerList.add(castLayer);
            }
            catch (ClassCastException classCastException) {}
        }
        return layerList;
    }

    @Override
    public TransportLayers<T> clone();
}

