/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.od;

import java.util.Arrays;
import java.util.HashMap;
import org.goplanit.utils.id.IdAble;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.od.OdDataImpl;
import org.goplanit.utils.od.OdHashed;
import org.goplanit.utils.od.OdHashedIterator;
import org.goplanit.utils.zoning.OdZones;
import org.goplanit.utils.zoning.Zone;

public abstract class OdHashedImpl<T>
extends OdDataImpl<T>
implements OdHashed<T> {
    private final HashMap<Integer, T> odHashed;

    public OdHashedImpl(Class<? extends IdAble> idClass, IdGroupingToken groupId, OdZones zones) {
        super(idClass, groupId, zones);
        this.odHashed = new HashMap();
    }

    public OdHashedImpl(OdHashedImpl<T> other) {
        super(other);
        this.odHashed = new HashMap<Integer, T>(other.odHashed);
    }

    @Override
    public T getValue(Zone origin, Zone destination) {
        return this.odHashed.get(Arrays.hashCode(new long[]{origin.getId(), destination.getId()}));
    }

    @Override
    public T getValue(long originId, long destinationId) {
        return this.odHashed.get(Arrays.hashCode(new long[]{originId, destinationId}));
    }

    @Override
    public void setValue(Zone origin, Zone destination, T path) {
        this.odHashed.put(Arrays.hashCode(new long[]{origin.getId(), destination.getId()}), path);
    }

    @Override
    public abstract OdHashedIterator<T> iterator();

    @Override
    public abstract OdHashedImpl<T> clone();
}

