/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.od;

import org.goplanit.utils.od.OdDataIterator;
import org.goplanit.utils.zoning.OdZones;
import org.goplanit.utils.zoning.Zone;

public abstract class OdMatrixIterator<T, U>
implements OdDataIterator<T> {
    private U matrixContents;
    protected int originId;
    protected int destinationId;
    protected int currentLocation;
    protected OdZones zones;

    protected void updateCurrentLocation() {
        this.originId = this.currentLocation / this.zones.size();
        this.destinationId = this.currentLocation % this.zones.size();
        ++this.currentLocation;
    }

    protected U getMatrixContent() {
        return this.matrixContents;
    }

    public OdMatrixIterator(U matrixContents, OdZones zones) {
        this.zones = zones;
        this.currentLocation = 0;
        this.matrixContents = matrixContents;
    }

    @Override
    public boolean hasNext() {
        return this.currentLocation < this.zones.size() * this.zones.size();
    }

    @Override
    public Zone getCurrentOrigin() {
        return (Zone)this.zones.get(this.originId);
    }

    @Override
    public Zone getCurrentDestination() {
        return (Zone)this.zones.get(this.destinationId);
    }

    @Override
    public T next() {
        this.updateCurrentLocation();
        return this.getCurrentValue();
    }
}

