/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.Collections;
import java.util.logging.Logger;
import org.goplanit.utils.misc.UriUtils;

public class ResourceUtils {
    private static final Logger LOGGER = Logger.getLogger(ResourceUtils.class.getCanonicalName());

    public static URL getResourceUrl(String resourceLocation) {
        return ResourceUtils.class.getClassLoader().getResource(resourceLocation);
    }

    public static URI getResourceUri(String resourceLocation) throws URISyntaxException {
        URL url = ResourceUtils.getResourceUrl(resourceLocation);
        if (url == null) {
            LOGGER.warning(String.format("Unable to create resource URL and therefore URI for %s", resourceLocation));
            return null;
        }
        return url.toURI();
    }

    public static FileSystem getJarFileSystem(URI uri) throws IOException {
        return FileSystems.newFileSystem(uri, Collections.emptyMap(), ResourceUtils.class.getClassLoader());
    }

    public static InputStream getResourceAsStream(String resourceLocation) {
        InputStream inputStream = ResourceUtils.class.getResourceAsStream(resourceLocation);
        if (inputStream == null) {
            LOGGER.warning(String.format("Unable to create input stream for resource location %s", resourceLocation));
        }
        return inputStream;
    }

    public static InputStreamReader getResourceAsInputStreamReader(URI uri) {
        try {
            if (UriUtils.isInJar(uri)) {
                return new InputStreamReader(ResourceUtils.getResourceAsInputStream(uri));
            }
            return new InputStreamReader(ResourceUtils.getResourceAsInputStream(uri), "UTF-8");
        }
        catch (Exception e) {
            LOGGER.warning(e.getMessage());
            LOGGER.warning(String.format("Unable to create an input stream reader for resource %s", uri.toString()));
            return null;
        }
    }

    public static InputStream getResourceAsInputStream(URI uri) {
        try {
            URI relativeResourceUri = UriUtils.asRelativeUri(uri);
            if (UriUtils.isInJar(uri)) {
                return ResourceUtils.getResourceAsStream(relativeResourceUri.toString());
            }
            return new FileInputStream(new File(uri));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.warning(e.getMessage());
            LOGGER.warning(String.format("Unable to create an input stream for resource %s", uri.toString()));
            return null;
        }
    }
}

